/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.DIALECT;
import com.veryant.cobol.compiler.directives.DUMMY;
import com.veryant.cobol.compiler.directives.DirectivesFactory;
import com.veryant.cobol.compiler.directives.HIDEMESSAGE;
import com.veryant.cobol.compiler.directives.IDirectiveListener;
import com.veryant.cobol.compiler.directives.IReservedWords;
import com.veryant.cobol.compiler.directives.LISTWIDTH;
import com.veryant.cobol.compiler.directives.REMOVE;
import com.veryant.cobol.compiler.directives.ReservedWordsList;
import com.veryant.cobol.compiler.directives.SETTINGS;
import com.veryant.cobol.compiler.frontend.CobolParserConstants;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Directives {
    ArrayList<String> defaults = new ArrayList();
    private ArrayList<String> cmdLine = new ArrayList();
    private List<IDirectiveListener> directiveListeners = new ArrayList<IDirectiveListener>();
    private char quoteChar;
    private BaseDirective[] allDirectives = new BaseDirective[323];
    private boolean[] rwFlags = null;
    private ArrayList<String> rwRemoved = new ArrayList();
    private Boolean commitRwDirectives = false;
    private ArrayList<BaseDirective> rwDirectives = new ArrayList();
    private static final Pattern directiveNamePattern = Pattern.compile("[A-Z0-9\\-]+", 2);

    public Directives() throws InvalidDirectiveException {
        this.clearRwDirectives(true);
        DirectivesFactory.setDefaults(this);
        while (this.defaults.size() > 0) {
            String[] stringArray = this.defaults.toArray(new String[0]);
            this.defaults.clear();
            for (String string : stringArray) {
                this.set(BaseDirective.Phase.AtEnd, string);
            }
        }
    }

    public void addDirectiveListener(IDirectiveListener iDirectiveListener) {
        this.directiveListeners.add(iDirectiveListener);
        for (BaseDirective baseDirective : this.allDirectives) {
            IDirectiveListener.onDirectiveChanged(iDirectiveListener, baseDirective);
        }
    }

    public void removeDirectiveListener(IDirectiveListener iDirectiveListener) {
        this.directiveListeners.remove(iDirectiveListener);
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public <T extends BaseDirective> T getDirective(int n2) {
        return (T)this.allDirectives[n2];
    }

    public BaseDirective setDirective(BaseDirective.Phase phase, BaseDirective baseDirective) {
        int n2;
        if (baseDirective instanceof DIALECT) {
            this.clearRwDirectives(true);
        }
        if (this.allDirectives[n2 = baseDirective.getIndex()] == null || !this.allDirectives[n2].mergeWith(phase, baseDirective)) {
            this.allDirectives[n2] = baseDirective;
        }
        return this.allDirectives[n2];
    }

    public ArrayList<String> getSettingsTexts() {
        SETTINGS sETTINGS = (SETTINGS)this.getDirective(278);
        if (!sETTINGS.isSet()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        block0 : switch (sETTINGS.getFormat()) {
            case Line: {
                LISTWIDTH lISTWIDTH = (LISTWIDTH)this.getDirective(179);
                StringBuilder stringBuilder = new StringBuilder();
                for (BaseDirective baseDirective : this.allDirectives) {
                    if (baseDirective == null) continue;
                    stringBuilder.append(baseDirective.toString()).append(' ');
                }
                Object object = stringBuilder.toString().trim();
                while (true) {
                    if (((String)object).length() <= lISTWIDTH.getWidth()) {
                        arrayList.add((String)object);
                        break block0;
                    }
                    int n2 = ((String)object).substring(0, lISTWIDTH.getWidth() + 1).lastIndexOf(32);
                    if (n2 <= 0) {
                        n2 = lISTWIDTH.getWidth();
                    }
                    arrayList.add(((String)object).substring(0, n2));
                    object = ((String)object).substring(n2).trim();
                }
            }
            case Col: {
                for (BaseDirective baseDirective : this.allDirectives) {
                    if (baseDirective == null) continue;
                    arrayList.add(baseDirective.toString());
                }
                break;
            }
            case Col3: {
                int n3 = 0;
                StringBuilder stringBuilder = new StringBuilder();
                for (BaseDirective baseDirective : this.allDirectives) {
                    if (baseDirective == null) continue;
                    if (n3 >= 3) {
                        arrayList.add(stringBuilder.toString().trim());
                        stringBuilder.setLength(0);
                        n3 = 0;
                    }
                    stringBuilder.append(baseDirective.toString()).append(' ');
                    ++n3;
                }
                if (stringBuilder.length() <= 0) break;
                arrayList.add(stringBuilder.toString().trim());
                break;
            }
        }
        return arrayList;
    }

    private void clearRwDirectives(Boolean bl) {
        if (bl.booleanValue()) {
            this.rwFlags = new boolean[CobolParserConstants.tokenImage.length];
        }
        this.commitRwDirectives = false;
        this.rwDirectives.clear();
    }

    private void updateRw(BaseDirective.Phase phase, BaseDirective baseDirective) {
        if (baseDirective instanceof IReservedWords) {
            for (int i2 = 0; i2 < this.rwDirectives.size(); ++i2) {
                if (this.rwDirectives.get(i2).getIndex() != baseDirective.getIndex()) continue;
                this.rwDirectives.remove(i2);
                this.commitRwDirectives = true;
                break;
            }
            if (baseDirective.isSet()) {
                this.rwDirectives.add(baseDirective);
                this.commitRwDirectives = true;
            }
        }
        if (this.commitRwDirectives.booleanValue() && phase != BaseDirective.Phase.ImmediateSet) {
            for (BaseDirective baseDirective2 : this.rwDirectives) {
                boolean[] blArray = ((IReservedWords)((Object)baseDirective2)).getRWFlags();
                for (int i3 = 0; i3 < blArray.length; ++i3) {
                    int n2 = i3;
                    this.rwFlags[n2] = this.rwFlags[n2] | blArray[i3];
                }
            }
            this.clearRwDirectives(false);
        }
        if (baseDirective instanceof REMOVE) {
            this.rwRemoved = ((REMOVE)baseDirective).getRwList();
        }
    }

    public boolean isRwSuppressed(int n2) {
        return !this.rwFlags[n2];
    }

    public boolean isRwRemoved(String string) {
        if (this.rwRemoved.size() > 0) {
            return this.rwRemoved.contains(ReservedWordsList.normalize(string));
        }
        return false;
    }

    public void setDefault(String string) throws InvalidDirectiveException {
        this.set(BaseDirective.Phase.SetDefaults, string);
    }

    public static InvalidDirectiveException invalidDirectiveException(String string, Object ... objectArray) {
        return new InvalidDirectiveException(string, objectArray);
    }

    public void set(BaseDirective.Phase phase, String string) throws InvalidDirectiveException {
        if (phase == BaseDirective.Phase.CommandLine) {
            this.cmdLine.add(string);
        }
        block77: while (string.length() > 0) {
            Matcher matcher = directiveNamePattern.matcher(string = string.trim());
            if (matcher.find()) {
                String string2 = string.substring(matcher.start(), matcher.end());
                String string3 = string2.replace("-", "").toUpperCase();
                String string4 = "";
                if (string3.startsWith("NO")) {
                    string4 = "NO";
                    string3 = string3.substring(2);
                }
                switch (string3) {
                    case "MFLEVEL": {
                        string3 = "MF";
                        break;
                    }
                    case "COBSTATCONV": {
                        string3 = "COBFSTATCONV";
                        break;
                    }
                    case "DBCSOSSI": {
                        string3 = "DBCSSOSI";
                        break;
                    }
                    case "DIR": 
                    case "USE": {
                        string3 = "DIRECTIVES";
                        break;
                    }
                    case "IBMMS": 
                    case "PC1": {
                        string = matcher.replaceFirst(string4.length() == 0 ? "MS\"1\"" : string4 + "MS");
                        continue block77;
                    }
                    case "JAPANESE": {
                        string3 = "NCHAR";
                        break;
                    }
                    case "OUTPUT": {
                        string3 = "ILOUTPUT";
                        break;
                    }
                    case "P": {
                        string3 = "PREPROCESS";
                        break;
                    }
                    case "PRINT": {
                        string3 = "LIST";
                        break;
                    }
                    case "SETTING": {
                        string3 = "SETTINGS";
                        break;
                    }
                    case "WARNING": {
                        string3 = "WARNINGS";
                        break;
                    }
                    case "WRITETHRU": {
                        string3 = "WRITETHROUGH";
                        break;
                    }
                    case "COMS85": 
                    case "ILARRAYPROPERTY": 
                    case "ILASSEMBLY": 
                    case "ILCLR": 
                    case "ILCOMPANY": 
                    case "ILCOPYRIGHT": 
                    case "ILCULTURE": 
                    case "ILCUTPREFIX": 
                    case "ILDELAYSIGN": 
                    case "ILDESCRIPTION": 
                    case "ILDOC": 
                    case "ILDYNCALL": 
                    case "ILEXPONENTIATION": 
                    case "ILFILEVERSION": 
                    case "ILGEN": 
                    case "ILICON": 
                    case "ILKEYFILE": 
                    case "ILKEYNAME": 
                    case "ILMAIN": 
                    case "ILMANIFEST": 
                    case "ILNAMESPACE": 
                    case "ILNATIVE": 
                    case "ILNATIVERESOURCE": 
                    case "ILNORMALIZENAMES": 
                    case "ILOBJECTIFY": 
                    case "ILPARAMS": 
                    case "ILPINVOKE": 
                    case "ILPRODUCT": 
                    case "ILPRODUCTVERSION": 
                    case "ILREF": 
                    case "ILRESOURCE": 
                    case "ILSHOWPERFORMOVERLAP": 
                    case "ILSOURCE": 
                    case "ILSTACKSIZE": 
                    case "ILSTATIC": 
                    case "ILSTDLIB": 
                    case "ILTARGET": 
                    case "ILTITLE": 
                    case "ILTRADEMARK": 
                    case "ILUSING": 
                    case "ILVERIFY": 
                    case "ILVERSION": 
                    case "TRICKLE": 
                    case "XMLGEN": 
                    case "XMLPARSE": 
                    case "ZWB": {
                        string3 = "DUMMY";
                    }
                }
                string3 = string4 + string3;
                Object object = DirectivesFactory.getDirective(string3);
                if (object == null) {
                    throw Directives.invalidDirectiveException("Directive %s does not exist.", string2);
                }
                if (((BaseDirective)object).isNo() && !((BaseDirective)object).isNoAllowed()) {
                    throw Directives.invalidDirectiveException("Directive %s does not exist.", string2);
                }
                string = string.substring(matcher.end());
                if (phase == BaseDirective.Phase.CommandLine && string.startsWith("=")) {
                    string = "\"" + string.substring(1).trim() + "\"";
                    this.cmdLine.remove(this.cmdLine.size() - 1);
                    this.cmdLine.add(string3 + string);
                }
                string = ((BaseDirective)object).parseTokens(string);
                ((BaseDirective)object).checkSetLegal(phase);
                if (!(object instanceof DUMMY) && !(object instanceof HIDEMESSAGE) && ((BaseDirective)object).isNo() && ((BaseDirective)object).getTokenCount() > 0) {
                    throw Directives.invalidDirectiveException("Directive %s cannot have parameters.", string2);
                }
                ((BaseDirective)object).setValues();
                object = this.setDirective(phase, (BaseDirective)object);
                for (IDirectiveListener iDirectiveListener : this.directiveListeners) {
                    IDirectiveListener.onDirectiveChanged(iDirectiveListener, (BaseDirective)object);
                }
                this.cacheValue((BaseDirective)object);
                if (phase != BaseDirective.Phase.Clone && ((BaseDirective)object).applyOtherDirectives()) {
                    if (phase != BaseDirective.Phase.AtEnd && ((BaseDirective)object).getImmediateSet() != null) {
                        this.set(BaseDirective.Phase.ImmediateSet, ((BaseDirective)object).getImmediateSet());
                    }
                    if (((BaseDirective)object).getAtEndSet() != null) {
                        if (phase.compareTo(BaseDirective.Phase.AtEnd) <= 0) {
                            this.defaults.add(((BaseDirective)object).getAtEndSet());
                        } else {
                            this.set(phase, ((BaseDirective)object).getAtEndSet());
                        }
                    }
                }
                if (phase.compareTo(BaseDirective.Phase.AfterInit) >= 0) {
                    this.checkCompatibility((BaseDirective)object);
                }
                this.updateRw(phase, (BaseDirective)object);
                continue;
            }
            throw Directives.invalidDirectiveException("Directive %s does not exist.", string);
        }
    }

    private void checkCompatibility(BaseDirective baseDirective) throws InvalidDirectiveException {
        BaseDirective baseDirective2 = baseDirective.checkCompatibility(this);
        if (baseDirective2 != null) {
            throw Directives.invalidDirectiveException("Directive %s is not compatible with %s.", baseDirective.toString(), baseDirective2.toString());
        }
    }

    private void cacheValue(BaseDirective baseDirective) {
        switch (baseDirective.getIndex()) {
            case 16: {
                this.quoteChar = (char)39;
                break;
            }
            case 249: {
                this.quoteChar = (char)34;
            }
        }
    }

    public void importAll(BaseDirective.Phase phase, Directives directives) throws InvalidDirectiveException {
        if (phase != BaseDirective.Phase.Clone) {
            throw Directives.invalidDirectiveException("Directive merging not allowed in phase %s.", new Object[]{phase});
        }
        for (String string : directives.cmdLine) {
            this.set(BaseDirective.Phase.CommandLine, string);
        }
        for (BaseDirective baseDirective : this.allDirectives) {
            if (baseDirective == null) continue;
            baseDirective.checkCompatibility(this);
        }
    }

    public void parseOptionsFile(String string) throws InvalidDirectiveException {
        File file = new File(string);
        if (Utils.isValidFile(file)) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0 || string2.charAt(0) == '#') continue;
                    this.set(BaseDirective.Phase.OptionFile, string2.trim());
                }
            }
            catch (IOException iOException) {
                throw new COBOLCompilerException(String.format("Cannot access file: %s", string));
            }
        }
    }
}

