/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import java.nio.ByteBuffer;

public class FileControlDescriptor {
    private final byte[] fcdBytes = new byte[216];

    public byte[] getFcdBytes() {
        return this.fcdBytes;
    }

    public FileControlDescriptor() {
        this.setFcdLengthValue();
        this.setFcdVersionNumberValue();
        this.setFcdFcdDeclBit();
        this.setFcdUsageUnknownBit();
    }

    private void setValue(int n2, short s2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.putShort(s2);
        System.arraycopy(byteBuffer.array(), 0, this.fcdBytes, n2, 2);
    }

    private void setValue(int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n3);
        System.arraycopy(byteBuffer.array(), 0, this.fcdBytes, n2, 4);
    }

    private void setFcdLengthValue() {
        this.setValue(2, (short)this.fcdBytes.length);
    }

    public void setFcdDataCompressValue(byte by) {
        this.fcdBytes[12] = by;
    }

    public void setFcdMinRecLength(int n2) {
        this.setValue(92, n2);
    }

    public void setFcdMaxRecLength(int n2) {
        this.setValue(96, n2);
    }

    public void setFcdVersionNumberValue() {
        this.fcdBytes[4] = 1;
    }

    public void setFcdLineSequentialOrgValue() {
        this.fcdBytes[5] = 0;
    }

    public void setFcdSequentialOrgValue() {
        this.fcdBytes[5] = 1;
    }

    public void setFcdIndexedOrgValue() {
        this.fcdBytes[5] = 2;
    }

    public void setFcdRelativeOrgValue() {
        this.fcdBytes[5] = 3;
    }

    public void setFcdSequentialAccessBit() {
        this.fcdBytes[6] = (byte)(this.fcdBytes[6] | 0);
    }

    public void setFcdDupPrimeAccessBit() {
        this.fcdBytes[6] = (byte)(this.fcdBytes[6] | 1);
    }

    public void setFcdRandomAccessBit() {
        this.fcdBytes[6] = (byte)(this.fcdBytes[6] | 4);
    }

    public void setFcdDynamicAccessBit() {
        this.fcdBytes[6] = (byte)(this.fcdBytes[6] | 8);
    }

    public void setFcdStatusDefinedBit() {
        this.fcdBytes[6] = (byte)(this.fcdBytes[6] | 0xFFFFFF80);
    }

    public void setFcdOpenInputValue() {
        this.fcdBytes[6] = 0;
    }

    public void setFcdOpenOutputValue() {
        this.fcdBytes[7] = 1;
    }

    public void setFcdOpenIOValue() {
        this.fcdBytes[7] = 2;
    }

    public void setFcdOpenExtendValue() {
        this.fcdBytes[7] = 3;
    }

    public void setFcdOpenMaxValue() {
        this.fcdBytes[7] = 3;
    }

    public void setFcdOpenClosedValue() {
        this.fcdBytes[7] = -128;
    }

    public void setFcdRecmodeFixedValue() {
        this.fcdBytes[8] = 0;
    }

    public void setFcdRecmodeVariableValue() {
        this.fcdBytes[8] = 1;
    }

    public void setFcdFormatLiiv1Value() {
        this.fcdBytes[9] = 0;
    }

    public void setFcdFormatCisamValue() {
        this.fcdBytes[9] = 1;
    }

    public void setFcdFormatLiiv2Value() {
        this.fcdBytes[9] = 2;
    }

    public void setFcdFormatCobol2Value() {
        this.fcdBytes[9] = 3;
    }

    public void setFcdFormatIdx4Value() {
        this.fcdBytes[9] = 4;
    }

    public void setFcdFormatBtrieveAnsiValue() {
        this.fcdBytes[9] = 5;
    }

    public void setFcdFormatBtrieveNonAnsiValue() {
        this.fcdBytes[9] = 6;
    }

    public void setFcdFormatBigValue() {
        this.fcdBytes[9] = 8;
    }

    public void setFcdFormatLeafrecValue() {
        this.fcdBytes[9] = 9;
    }

    public void setFcdFormatCstValue() {
        this.fcdBytes[9] = 10;
    }

    public void setFcdFormatMvsPrintValue() {
        this.fcdBytes[9] = 11;
    }

    public void setFcdFormatIdx12Value() {
        this.fcdBytes[9] = 12;
    }

    public void setFcdFormatHeapValue() {
        this.fcdBytes[9] = 14;
    }

    public void setFcdFormatEsdsValue() {
        this.fcdBytes[9] = 15;
    }

    public void setFcdFormatEsdsBigValue() {
        this.fcdBytes[9] = 16;
    }

    public void setFcdFormatVisionValue() {
        this.fcdBytes[9] = 17;
    }

    public void setFcdFormatMssqlValue() {
        this.fcdBytes[9] = 18;
    }

    public void setFcdFormatOracleValue() {
        this.fcdBytes[9] = 19;
    }

    public void setFcdFormatDb2Value() {
        this.fcdBytes[9] = 20;
    }

    public void setFcdFormatRmValue() {
        this.fcdBytes[9] = 21;
    }

    public void setFcdFormatOdbcValue() {
        this.fcdBytes[9] = 22;
    }

    public void setFcdFormatQsamvValue() {
        this.fcdBytes[9] = -1;
    }

    public void setFcdDevNormalValue() {
        this.fcdBytes[10] = 0;
    }

    public void setFcdDevDeviceValue() {
        this.fcdBytes[10] = 1;
    }

    public void setFcdDevStdinValue() {
        this.fcdBytes[10] = 2;
    }

    public void setFcdDevStdoutValue() {
        this.fcdBytes[10] = 3;
    }

    public void setFcdDevStderrValue() {
        this.fcdBytes[10] = 4;
    }

    public void setFcdDevBadnameValue() {
        this.fcdBytes[10] = 5;
    }

    public void setFcdDevInputPipeValue() {
        this.fcdBytes[10] = 6;
    }

    public void setFcdDevOutputPipeValue() {
        this.fcdBytes[10] = 7;
    }

    public void setFcdDevIOPipeValue() {
        this.fcdBytes[10] = 8;
    }

    public void setFcdDevLibraryValue() {
        this.fcdBytes[10] = 9;
    }

    public void setFcdDevDiskFileValue() {
        this.fcdBytes[10] = 10;
    }

    public void setFcdDevNullValue() {
        this.fcdBytes[10] = 11;
    }

    public void setFcdDevDiskRedirValue() {
        this.fcdBytes[10] = 12;
    }

    public void setFcdDevNoMapValue() {
        this.fcdBytes[10] = 13;
    }

    public void setFcdGetlockValue() {
        this.fcdBytes[11] = 1;
    }

    public void setFcdNolockValue() {
        this.fcdBytes[11] = 2;
    }

    public void setFcdIgnorelockValue() {
        this.fcdBytes[11] = 3;
    }

    public void setFcdMainframeCompatBit() {
        this.fcdBytes[17] = (byte)(this.fcdBytes[17] | 0xFFFFFF80);
    }

    public void setFcdAnsiLineAdvBit() {
        this.fcdBytes[17] = (byte)(this.fcdBytes[17] | 0x40);
    }

    public void setFcdReturnKeyOnlyBit() {
        this.fcdBytes[17] = (byte)(this.fcdBytes[17] | 0x20);
    }

    public void setFcdBypassEsdsBit() {
        this.fcdBytes[17] = (byte)(this.fcdBytes[17] | 0x10);
    }

    public void setFcdNoXfhnameMappingBit() {
        this.fcdBytes[17] = (byte)(this.fcdBytes[17] | 8);
    }

    public void setFcdDontCallXfhtraceBit() {
        this.fcdBytes[17] = (byte)(this.fcdBytes[17] | 4);
    }

    public void setFcdCallXfhtraceBit() {
        this.fcdBytes[17] = (byte)(this.fcdBytes[17] | 2);
    }

    public void setFcdFcdDeclBit() {
        this.fcdBytes[17] = (byte)(this.fcdBytes[17] | 1);
    }

    public void setFcdConvertDbspaceBit() {
        this.fcdBytes[18] = (byte)(this.fcdBytes[18] | 1);
    }

    public void setFcdFileIsSyspunchBit() {
        this.fcdBytes[19] = (byte)(this.fcdBytes[19] | 0x10);
    }

    public void setFcdFileIsInddBit() {
        this.fcdBytes[19] = (byte)(this.fcdBytes[19] | 8);
    }

    public void setFcdFileIsOutddBit() {
        this.fcdBytes[19] = (byte)(this.fcdBytes[19] | 4);
    }

    public void setFcdAmode31BitBit() {
        this.fcdBytes[19] = (byte)(this.fcdBytes[19] | 2);
    }

    public void setFcdAmode24BitBit() {
        this.fcdBytes[19] = (byte)(this.fcdBytes[19] | 1);
    }

    public void setFcdAns85StatusBit() {
        this.fcdBytes[20] = (byte)(this.fcdBytes[20] | 0xFFFFFF80);
    }

    public void setFcdNoSpaceFillBit() {
        this.fcdBytes[20] = (byte)(this.fcdBytes[20] | 0x40);
    }

    public void setFcdNoStripSpacesBit() {
        this.fcdBytes[20] = (byte)(this.fcdBytes[20] | 0x20);
    }

    public void setFcdNoExpandTabsBit() {
        this.fcdBytes[20] = (byte)(this.fcdBytes[20] | 0x10);
    }

    public void setFcdRecTermBitBit() {
        this.fcdBytes[20] = (byte)(this.fcdBytes[20] | 8);
    }

    public void setFcdInsertTabsBit() {
        this.fcdBytes[20] = (byte)(this.fcdBytes[20] | 4);
    }

    public void setFcdInsertNullsBit() {
        this.fcdBytes[20] = (byte)(this.fcdBytes[20] | 2);
    }

    public void setFcdCrDelimiterBit() {
        this.fcdBytes[20] = (byte)(this.fcdBytes[20] | 1);
    }

    public void setFcdOptionalFileBit() {
        this.fcdBytes[21] = (byte)(this.fcdBytes[21] | 0xFFFFFF80);
    }

    public void setFcdNodetectlockInputBit() {
        this.fcdBytes[21] = (byte)(this.fcdBytes[21] | 0x40);
    }

    public void setFcdNotOptionalBit() {
        this.fcdBytes[21] = (byte)(this.fcdBytes[21] | 0x20);
    }

    public void setFcdExternalNameBit() {
        this.fcdBytes[21] = (byte)(this.fcdBytes[21] | 0x10);
    }

    public void setFcdGetInfoBit() {
        this.fcdBytes[21] = (byte)(this.fcdBytes[21] | 8);
    }

    public void setFcdNodetectlockBit() {
        this.fcdBytes[21] = (byte)(this.fcdBytes[21] | 4);
    }

    public void setFcdMultipleReelBit() {
        this.fcdBytes[21] = (byte)(this.fcdBytes[21] | 2);
    }

    public void setFcdLineAdvancingBit() {
        this.fcdBytes[21] = (byte)(this.fcdBytes[21] | 1);
    }

    public void setFcdOpenInputSharedBit() {
        this.fcdBytes[22] = (byte)(this.fcdBytes[22] | 0xFFFFFF80);
    }

    public void setFcdAllowInputLocksBit() {
        this.fcdBytes[22] = (byte)(this.fcdBytes[22] | 0x40);
    }

    public void setFcdNoReadSemaBit() {
        this.fcdBytes[22] = (byte)(this.fcdBytes[22] | 0x20);
    }

    public void setFcdExpandPositioningBitBit() {
        this.fcdBytes[22] = (byte)(this.fcdBytes[22] | 0x10);
    }

    public void setFcdNoSeqCheckBit() {
        this.fcdBytes[22] = (byte)(this.fcdBytes[22] | 8);
    }

    public void setFcdDatTermBitBit() {
        this.fcdBytes[22] = (byte)(this.fcdBytes[22] | 4);
    }

    public void setFcdSlowReadBit() {
        this.fcdBytes[22] = (byte)(this.fcdBytes[22] | 2);
    }

    public void setFcdSuppressAdvBit() {
        this.fcdBytes[22] = (byte)(this.fcdBytes[22] | 1);
    }

    public void setFcdInterlangLockingBit() {
        this.fcdBytes[23] = (byte)(this.fcdBytes[23] | 0xFFFFFF80);
    }

    public void setFcdAllowReadersBit() {
        this.fcdBytes[23] = (byte)(this.fcdBytes[23] | 0x40);
    }

    public void setFcdSeparateLockFileBit() {
        this.fcdBytes[23] = (byte)(this.fcdBytes[23] | 0x20);
    }

    public void setFcdSingleOpenBit() {
        this.fcdBytes[23] = (byte)(this.fcdBytes[23] | 0x10);
    }

    public void setFcdNfsFileLockBit() {
        this.fcdBytes[23] = (byte)(this.fcdBytes[23] | 8);
    }

    public void setFcdNfsFileLockHpBit() {
        this.fcdBytes[23] = (byte)(this.fcdBytes[23] | 4);
    }

    public void setFcdTransactionProcessingBitBit() {
        this.fcdBytes[24] = (byte)(this.fcdBytes[24] | 0xFFFFFF80);
    }

    public void setFcdRecoveryRunBBit() {
        this.fcdBytes[24] = (byte)(this.fcdBytes[24] | 4);
    }

    public void setFcdFsServerBitBit() {
        this.fcdBytes[24] = (byte)(this.fcdBytes[24] | 2);
    }

    public void setFcdWritethruBitBit() {
        this.fcdBytes[25] = (byte)(this.fcdBytes[25] | 0xFFFFFF80);
    }

    public void setFcdRelativeBitBit() {
        this.fcdBytes[25] = (byte)(this.fcdBytes[25] | 0x40);
    }

    public void setFcdSetCrpBitBit() {
        this.fcdBytes[25] = (byte)(this.fcdBytes[25] | 0x20);
    }

    public void setFcdBigfileBitBit() {
        this.fcdBytes[25] = (byte)(this.fcdBytes[25] | 0x10);
    }

    public void setFcdCallCobfstatconvBit() {
        this.fcdBytes[25] = (byte)(this.fcdBytes[25] | 2);
    }

    public void setFcdIgnorelockBitBit() {
        this.fcdBytes[25] = (byte)(this.fcdBytes[25] | 1);
    }

    public void setFcdMainframeHostfdBit() {
        this.fcdBytes[26] = (byte)(this.fcdBytes[26] | 0xFFFFFF80);
    }

    public void setFcdSetIdxdatbufBit() {
        this.fcdBytes[26] = (byte)(this.fcdBytes[26] | 0x40);
    }

    public void setFcdLoadOntoHeapBit() {
        this.fcdBytes[26] = (byte)(this.fcdBytes[26] | 0x20);
    }

    public void setFcdUsageUnknownBit() {
        this.fcdBytes[26] = (byte)(this.fcdBytes[26] | 0x10);
    }

    public void setFcdRecmodeSBit() {
        this.fcdBytes[26] = (byte)(this.fcdBytes[26] | 8);
    }

    public void setFcdRecmodeUBit() {
        this.fcdBytes[26] = (byte)(this.fcdBytes[26] | 4);
    }

    public void setFcdExternalFcdBit() {
        this.fcdBytes[26] = (byte)(this.fcdBytes[26] | 2);
    }

    public void setFcdClosedWithLockBit() {
        this.fcdBytes[26] = (byte)(this.fcdBytes[26] | 1);
    }

    public void setFcdFileIsEbcdicBit() {
        this.fcdBytes[27] = (byte)(this.fcdBytes[27] | 0xFFFFFF80);
    }

    public void setFcdFileHasWriteAfterBit() {
        this.fcdBytes[27] = (byte)(this.fcdBytes[27] | 0x40);
    }

    public void setFcdFileHasWriteBeforeBit() {
        this.fcdBytes[27] = (byte)(this.fcdBytes[27] | 0x20);
    }

    public void setFcdFileHasAdvSpecifiedBit() {
        this.fcdBytes[27] = (byte)(this.fcdBytes[27] | 0x10);
    }

    public void setFcdNoMinLenCheckBit() {
        this.fcdBytes[27] = (byte)(this.fcdBytes[27] | 8);
    }

    public void setFcdNoKeyCheckBit() {
        this.fcdBytes[27] = (byte)(this.fcdBytes[27] | 4);
    }

    public void setFcdConvertToAsciiBit() {
        this.fcdBytes[27] = (byte)(this.fcdBytes[27] | 2);
    }

    public void setFcdRmBehaviourBit() {
        this.fcdBytes[27] = (byte)(this.fcdBytes[27] | 1);
    }

    public void setFcdMultilockBitBit() {
        this.fcdBytes[28] = (byte)(this.fcdBytes[28] | 0xFFFFFF80);
    }

    public void setFcdWritelockBitBit() {
        this.fcdBytes[28] = (byte)(this.fcdBytes[28] | 0x40);
    }

    public void setFcdRetryOpenBitBit() {
        this.fcdBytes[28] = (byte)(this.fcdBytes[28] | 0x20);
    }

    public void setFcdSkipLockBitBit() {
        this.fcdBytes[28] = (byte)(this.fcdBytes[28] | 0x10);
    }

    public void setFcdRetryLockBitBit() {
        this.fcdBytes[28] = (byte)(this.fcdBytes[28] | 8);
    }

    public void setFcdFileMaxBitBit() {
        this.fcdBytes[29] = (byte)(this.fcdBytes[29] | 8);
    }

    public void setFcdFilePointerBitBit() {
        this.fcdBytes[29] = (byte)(this.fcdBytes[29] | 4);
    }

    public void setFcdRetryTimeBitBit() {
        this.fcdBytes[29] = (byte)(this.fcdBytes[29] | 2);
    }

    public void setFcdStartUnlockBit() {
        this.fcdBytes[29] = (byte)(this.fcdBytes[29] | 1);
    }

    public void unsetFcdManualLockBitBit() {
        this.fcdBytes[28] = (byte)(this.fcdBytes[28] & 0xFFFFFFFB);
    }

    public void setFcdManualLockBitBit() {
        if (!this.getFcdExclusiveBitBit()) {
            this.unsetFcdAutoLockBitBit();
            this.fcdBytes[28] = (byte)(this.fcdBytes[28] | 4);
        }
    }

    public void unsetFcdAutoLockBitBit() {
        this.fcdBytes[28] = (byte)(this.fcdBytes[28] & 0xFFFFFFFD);
    }

    public void setFcdAutoLockBitBit() {
        if (!this.getFcdExclusiveBitBit()) {
            this.unsetFcdManualLockBitBit();
            this.fcdBytes[28] = (byte)(this.fcdBytes[28] | 2);
        }
    }

    public boolean getFcdExclusiveBitBit() {
        return (this.fcdBytes[28] & 1) == 1;
    }

    public void setFcdExclusiveBitBit() {
        this.unsetFcdAutoLockBitBit();
        this.unsetFcdManualLockBitBit();
        this.fcdBytes[28] = (byte)(this.fcdBytes[28] | 1);
    }
}

