/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

public class Magnitude {
    public static final int FLOAT_DIGITS = -1;
    public static final int DOUBLE_DIGITS = -2;
    public static final Magnitude FLOAT = new Magnitude(true, -1);
    public static final Magnitude DOUBLE = new Magnitude(true, -2);
    public static final Magnitude UNSIGNED_FLOAT = new Magnitude(true, -1);
    public static final Magnitude UNSIGNED_DOUBLE = new Magnitude(true, -2);
    private final boolean signed;
    private final int digits;
    private final int scale;

    public int getIntDigits() {
        return this.digits + this.scale;
    }

    public Magnitude(boolean bl, int n2, int n3) {
        this.signed = bl;
        this.digits = n2;
        this.scale = n3;
    }

    public Magnitude(boolean bl, int n2) {
        this(bl, n2, 0);
    }

    public boolean isInteger() {
        return !this.isFloatingPoint() && this.getScale() >= 0;
    }

    public boolean isFixedPoint() {
        return !this.isFloatingPoint() && this.getScale() < 0;
    }

    public boolean isFloatingPoint() {
        return this.getDigits() < 0;
    }

    public Magnitude removeSign() {
        if (this.signed) {
            return new Magnitude(false, this.digits, this.scale);
        }
        return this;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getDigits() {
        return this.digits;
    }

    public int getScale() {
        return this.scale;
    }
}

