/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.exceptions.COBOLCompilerException;

public enum Operators {
    POS(1),
    NEG(1),
    NOT(1),
    ADD(2),
    DIV(2),
    MUL(2),
    POW(2),
    SUB(2),
    EQ(2),
    NE(2),
    LE(2),
    LT(2),
    GE(2),
    GT(2),
    AND(2),
    OR(2),
    XOR(2),
    LEFT(2),
    RIGHT(2);

    private static final int MAX_SUPPORTED_DIGITS = 38;
    private final int operandsCount;

    private Operators(int n3) {
        this.operandsCount = n3;
    }

    public static Magnitude intermediate(Operators operators, Magnitude ... magnitudeArray) {
        return Operators.intermediate(operators, Integer.MIN_VALUE, magnitudeArray);
    }

    public static Magnitude intermediate(Operators operators, int n2, Magnitude ... magnitudeArray) {
        if (magnitudeArray.length != operators.getOperandsCount()) {
            throw new COBOLCompilerException("Internal error, wrong opcode usage");
        }
        switch (operators) {
            case POS: 
            case NEG: 
            case NOT: {
                return magnitudeArray[0];
            }
        }
        if (magnitudeArray[0].isFloatingPoint() || magnitudeArray[1].isFloatingPoint()) {
            if (magnitudeArray[0].isSigned() || magnitudeArray[1].isSigned()) {
                return Magnitude.DOUBLE;
            }
            return Magnitude.UNSIGNED_DOUBLE;
        }
        switch (operators) {
            case ADD: 
            case SUB: {
                if (n2 == Integer.MIN_VALUE) {
                    n2 = Math.min(magnitudeArray[0].getScale(), magnitudeArray[1].getScale());
                }
                return new Magnitude(magnitudeArray[0].isSigned() || magnitudeArray[1].isSigned(), Math.max(magnitudeArray[0].getIntDigits(), magnitudeArray[1].getIntDigits()) - n2 + 1, n2);
            }
            case MUL: {
                if (n2 == Integer.MIN_VALUE) {
                    n2 = magnitudeArray[0].getScale() + magnitudeArray[1].getScale();
                }
                return new Magnitude(magnitudeArray[0].isSigned() || magnitudeArray[1].isSigned(), magnitudeArray[0].getDigits() + magnitudeArray[1].getDigits(), n2);
            }
            case DIV: {
                int n3 = magnitudeArray[0].getIntDigits() - magnitudeArray[1].getScale();
                if (n2 == Integer.MIN_VALUE) {
                    n2 = -(38 - n3);
                }
                return new Magnitude(magnitudeArray[0].isSigned() || magnitudeArray[1].isSigned(), n3 - n2, n2);
            }
            case POW: {
                return new Magnitude(magnitudeArray[0].isSigned(), 38, 0);
            }
            case EQ: 
            case NE: 
            case LE: 
            case LT: 
            case GE: 
            case GT: {
                int n4 = Math.max(magnitudeArray[0].getIntDigits(), magnitudeArray[1].getIntDigits());
                int n5 = Math.min(magnitudeArray[0].getScale(), magnitudeArray[1].getScale());
                return new Magnitude(magnitudeArray[0].isSigned() || magnitudeArray[1].isSigned(), n4 - n5, n5);
            }
        }
        throw new COBOLCompilerException("Internal error, wrong opcode usage");
    }

    public int getOperandsCount() {
        return this.operandsCount;
    }
}

