/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.BATree;
import com.veryant.cobol.compiler.stmts.CodeBlock;

public class Procedure {
    private static final int MAX_INLINE_CODE_WEIGHT = 20;
    private BATree performs;
    private BATree gotos;
    private final int index;
    private int range = -1;
    private boolean reached;
    private boolean stopFlow;
    private boolean labelNeeded;
    private boolean retNeeded;
    private boolean slideAllowed;
    private final CodeBlock code;

    public boolean isInline() {
        return this.code.getRank() <= 20;
    }

    public boolean isEmpty() {
        return this.code.size() == 0;
    }

    public int getPerformsCount() {
        if (this.performs != null) {
            return this.performs.size();
        }
        return 0;
    }

    public void addPerform(int n2, int n3) {
        if (this.performs == null) {
            this.performs = new BATree();
        }
        this.performs.insert(n2, n3);
    }

    public BATree.Node getPerform(int n2) {
        if (this.performs != null) {
            return this.performs.get(n2);
        }
        return null;
    }

    public int getGotosCount() {
        if (this.gotos != null) {
            return this.gotos.size();
        }
        return 0;
    }

    public void addGoto(int n2) {
        if (this.gotos == null) {
            this.gotos = new BATree();
        }
        this.gotos.insert(this.index, n2);
    }

    public BATree.Node getGoto(int n2) {
        if (this.gotos != null) {
            return this.gotos.get(n2);
        }
        return null;
    }

    public boolean hasGoto() {
        return this.getGotosCount() > 0;
    }

    public boolean isLeafCode() {
        return this.getGotosCount() == 0 && this.getPerformsCount() == 0;
    }

    public Procedure(int n2, CodeBlock codeBlock) {
        this.index = n2;
        this.code = codeBlock;
    }

    public BATree getPerforms() {
        return this.performs;
    }

    public BATree getGotos() {
        return this.gotos;
    }

    public int getIndex() {
        return this.index;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int n2) {
        this.range = n2;
    }

    public boolean isReached() {
        return this.reached;
    }

    public void setReached(boolean bl) {
        this.reached = bl;
    }

    public boolean isStopFlow() {
        return this.stopFlow;
    }

    public void setStopFlow(boolean bl) {
        this.stopFlow = bl;
    }

    public boolean isLabelNeeded() {
        return this.labelNeeded;
    }

    public void setLabelNeeded(boolean bl) {
        this.labelNeeded = bl;
    }

    public boolean isRetNeeded() {
        return this.retNeeded;
    }

    public void setRetNeeded(boolean bl) {
        this.retNeeded = bl;
    }

    public boolean isSlideAllowed() {
        return this.slideAllowed;
    }

    public void setSlideAllowed(boolean bl) {
        this.slideAllowed = bl;
    }

    public CodeBlock getCode() {
        return this.code;
    }
}

