/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.exceptions.COBOLCompilerException;

public class StringFormat {
    private static final String PLACEHOLDER = "\\{\\?}";
    private final String[] pieces;
    private int argumentsCount;

    public int getArgumentsCount() {
        return this.argumentsCount;
    }

    public StringFormat(String string) {
        this.pieces = string.split(PLACEHOLDER, -1);
        this.argumentsCount = this.pieces.length - 1;
    }

    public String format(Object ... objectArray) {
        if (objectArray.length != this.argumentsCount) {
            throw new COBOLCompilerException("Internal error, string mask not matching provided arguments");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (Object object : objectArray) {
            stringBuilder.append(this.pieces[n2++]);
            stringBuilder.append(object.toString());
        }
        stringBuilder.append(this.pieces[n2]);
        return stringBuilder.toString();
    }

    public String toString() {
        return String.join((CharSequence)PLACEHOLDER, this.pieces);
    }
}

