/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Console;
import com.veryant.cobol.compiler.ast.AstCobolProgram;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstOperand;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.util.ArrayList;
import java.util.List;

public class AbstractSyntaxTree {
    private static final boolean AST_TO_CONSOLE = false;
    private Console console;
    private AstNode currentNode;
    private final ArrayList<AstNode> stack = new ArrayList();
    private List<AstCobolProgram> modules = new ArrayList<AstCobolProgram>(3);
    private int indent = 0;

    public Console getConsole() {
        return this.console;
    }

    public AstCobolProgram[] getModules() {
        return this.modules.toArray(new AstCobolProgram[this.modules.size()]);
    }

    public AstNode getCurrentNode() {
        return this.currentNode;
    }

    public AbstractSyntaxTree(Console console) {
        this.console = console;
    }

    public void debugWriteConsole(Object ... objectArray) {
    }

    public <T extends AstNode> T open(T t2) {
        if (t2 instanceof AstOperand) {
            AstOperand astOperand = (AstOperand)t2;
            if (this.currentNode == null) {
                throw new COBOLCompilerException("Internal error, invalid AST structure");
            }
            int n2 = astOperand.getPostfixRank();
            if (n2 > 0) {
                AstNode[] astNodeArray = new AstNode[n2];
                while (n2 > 0) {
                    astNodeArray[--n2] = this.currentNode.pop();
                }
                for (AstNode astNode : astNodeArray) {
                    if (!(astNode instanceof AstOperand)) {
                        throw new COBOLCompilerException("Internal error, invalid expression");
                    }
                    t2.push(astNode);
                }
            }
        }
        if (this.currentNode != null) {
            this.stack.add(this.currentNode);
            this.currentNode.push(t2);
        }
        this.currentNode = t2;
        return t2;
    }

    public <T extends AstNode> T close() {
        AstNode astNode = this.currentNode;
        int n2 = this.stack.size();
        AstNode astNode2 = this.currentNode = n2 > 0 ? this.stack.remove(n2 - 1) : null;
        if (!astNode.isRejected()) {
            astNode.validate();
            if (this.currentNode == null) {
                this.modules.add((AstCobolProgram)astNode);
            }
            return (T)astNode;
        }
        return null;
    }

    public <T extends AstNode> T push(T t2) {
        this.open(t2);
        return this.close();
    }

    public String toString() {
        return "abstract-syntax-tree";
    }
}

