/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.ast.AstNestedModules;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.memory.Literal;
import com.veryant.cobol.compiler.memory.RecordItem;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.scope.FileDeclaration;

public class AstCobolProgram
extends AstNode {
    public AstCobolProgram(Collector collector) {
        super(collector, Token.NULL);
    }

    public boolean isNested() {
        return this.getParent() instanceof AstNestedModules;
    }

    @Override
    public void validate() {
        for (FileDeclaration fileDeclaration : this.getCollector().getFiles(false)) {
            if (fileDeclaration.getIsFDMissing()) {
                this.consoleWrite(68, fileDeclaration, new Object[0]);
            }
            RecordItem recordItem = null;
            for (RecordItem literal : fileDeclaration.getRecords()) {
                ((DynamicChunk)literal.getChunk()).setUsed(true);
                if (recordItem == null) {
                    recordItem = literal;
                    continue;
                }
                ((DynamicChunk)literal.getChunk()).setUnion((DynamicChunk)recordItem.getChunk());
            }
            DataItem object = new DataItem(null, BuiltIn.ALPHA, null, 216);
            this.getCollector().getWorkingStorage().add(object);
            DataItemDeclaration dataItemDeclaration = new DataItemDeclaration((ISourceReference)fileDeclaration, object);
            dataItemDeclaration.markAsUsed();
            fileDeclaration.setFcdDataItem(object);
        }
        this.getCollector().relocateMemory();
        for (FileDeclaration fileDeclaration : this.getCollector().getFiles(false)) {
            int n2;
            boolean bl = true;
            int n22 = Integer.MAX_VALUE;
            int n3 = Integer.MIN_VALUE;
            if (fileDeclaration.getMinRecordLength() < 0) {
                for (RecordItem recordItem : fileDeclaration.getRecords()) {
                    int n4 = ((DynamicChunk)recordItem.getChunk()).getSize();
                    if (n2 > n4) {
                        n2 = n4;
                    }
                    if (n3 >= n4) continue;
                    n3 = n4;
                }
            }
            if (fileDeclaration.getMinRecordLength() < 0) {
                fileDeclaration.setMinRecordLength(n2);
            }
            if (fileDeclaration.getMaxRecordLength() < 0) {
                fileDeclaration.setMaxRecordLength(n3);
            }
            if (fileDeclaration.hasRecordVaryingClause() || fileDeclaration.getRecordingMode() != null) {
                if (fileDeclaration.hasRecordVaryingClause() && fileDeclaration.getRecordingMode() == null) {
                    fileDeclaration.setRecordingMode(FileDeclaration.RecordingMode.V);
                }
            } else {
                switch (fileDeclaration.getRecmodeFormat()) {
                    case F: {
                        fileDeclaration.setRecordingMode(FileDeclaration.RecordingMode.F);
                        break;
                    }
                    case V: {
                        fileDeclaration.setRecordingMode(FileDeclaration.RecordingMode.V);
                        break;
                    }
                    case OSVS: 
                    case VSC21: 
                    case VSC22: {
                        fileDeclaration.setRecordingMode(n2 == n3 && bl ? FileDeclaration.RecordingMode.F : FileDeclaration.RecordingMode.V);
                        break;
                    }
                    case COBOL370: 
                    case ENTCOBOL: 
                    case MVS: 
                    case OS390: 
                    case VSC23: 
                    case VSC24: {
                        if (n2 == n3 && (bl || fileDeclaration.hasRecordContainsFixedClause())) {
                            fileDeclaration.setRecordingMode(FileDeclaration.RecordingMode.F);
                            break;
                        }
                        fileDeclaration.setRecordingMode(FileDeclaration.RecordingMode.V);
                        break;
                    }
                    case RMCOBOL: {
                        if (n2 == n3 && bl && !fileDeclaration.hasRecordContainsRangeClause()) {
                            fileDeclaration.setRecordingMode(FileDeclaration.RecordingMode.F);
                            if (!fileDeclaration.hasRecordContainsFixedClause()) break;
                            fileDeclaration.setMinRecordLength(fileDeclaration.getMaxRecordLength());
                            break;
                        }
                        fileDeclaration.setRecordingMode(FileDeclaration.RecordingMode.V);
                    }
                }
            }
            Literal literal = new Literal(this.getContext().getCodepage(), fileDeclaration.getFileControlDescriptor().getFcdBytes());
            fileDeclaration.setFcdLiteral(this.getContext().getLiterals().add(literal));
            if (fileDeclaration.getOrganization() != FileDeclaration.Organization.Indexed) continue;
            fileDeclaration.updateKeyInfo();
            Literal literal2 = new Literal(this.getContext().getCodepage(), fileDeclaration.getKeyDefinitionBlockBytes());
            fileDeclaration.setKeyBlockLiteral(this.getContext().getLiterals().add(literal2));
        }
    }

    public Collector getCompilationResult() {
        return this.getCollector();
    }

    @Override
    public String toString() {
        return "cobol-program";
    }
}

