/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Section;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstSection;
import com.veryant.cobol.compiler.ast.common.AstFileReference;
import com.veryant.cobol.compiler.ast.statements.AstUseStatement;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import java.util.ArrayList;
import java.util.List;

public class AstDeclaratives
extends AstNode {
    public AstDeclaratives(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void validate() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AstSection astSection : (AstSection[])this.findChildren(AstSection.class)) {
            AstUseStatement astUseStatement = astSection.findChild(AstUseStatement.class);
            if (astUseStatement == null) continue;
            Section section = astSection.getSection();
            int n2 = -1;
            for (AstNode astNode : astUseStatement.getChildren()) {
                switch (astNode.getToken().kind) {
                    case 362: {
                        section.setGlobal(true);
                        break;
                    }
                    case 301: 
                    case 310: {
                        section.setUsage(Section.Usage.ErrorProcedure);
                        break;
                    }
                    case 398: {
                        section.setOpenMode(Section.OpenMode.Input);
                        this.addOpenMode(arrayList, section.getUsage(), section.getOpenMode().toString(), astNode);
                        n2 = 0;
                        break;
                    }
                    case 524: {
                        section.setOpenMode(Section.OpenMode.Output);
                        this.addOpenMode(arrayList, section.getUsage(), section.getOpenMode().toString(), astNode);
                        n2 = 1;
                        break;
                    }
                    case 374: {
                        section.setOpenMode(Section.OpenMode.IO);
                        this.addOpenMode(arrayList, section.getUsage(), section.getOpenMode().toString(), astNode);
                        n2 = 2;
                        break;
                    }
                    case 319: {
                        section.setOpenMode(Section.OpenMode.Extend);
                        this.addOpenMode(arrayList, section.getUsage(), section.getOpenMode().toString(), astNode);
                        n2 = 3;
                        break;
                    }
                    default: {
                        if (!(astNode instanceof AstFileReference)) break;
                        FileDeclaration fileDeclaration = ((AstFileReference)astNode).getFile();
                        fileDeclaration.setDeclarativeSection(section);
                        this.addOpenMode(arrayList, section.getUsage(), fileDeclaration.getName(), astNode);
                    }
                }
                if (n2 < 0) continue;
                this.getCode().getErrorProcedures().set(n2, section);
            }
        }
    }

    private void addOpenMode(List<String> list, Section.Usage usage, String string, AstNode astNode) {
        String string2 = usage.toString() + "+" + this.getScope().normalize(string);
        if (!list.contains(string2)) {
            list.add(string2);
        } else {
            this.consoleWrite(70, astNode.getToken(), new Object[0]);
        }
    }
}

