/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.Code;
import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.CompilerMessage;
import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.DataUsage;
import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.Operators;
import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.ast.AstOperand;
import com.veryant.cobol.compiler.frontend.CobolParserConstants;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.memory.Literal;
import com.veryant.cobol.compiler.scope.Scope;
import com.veryant.cobol.compiler.stmts.CodeBlock;
import com.veryant.cobol.compiler.stmts.Declare;
import com.veryant.cobol.compiler.stmts.Move;
import com.veryant.cobol.compiler.types.AbstractLiteral;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.DataItemReference;
import com.veryant.cobol.compiler.types.IntermediateCondition;
import com.veryant.cobol.compiler.types.IntermediateReference;
import com.veryant.cobol.compiler.types.NumericLiteral;
import com.veryant.cobol.compiler.types.StringLiteral;
import com.veryant.cobol.data.CobolBigDecimal;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class AstNode
implements CobolParserConstants {
    private final Token token;
    private final Collector collector;
    private boolean rejected;
    private AstNode parent;
    private ArrayList<AstNode> children = new ArrayList(2);
    private Map<Class<? extends AstNode>, AstNode> uniqueNodes;

    public Token getToken() {
        return this.token;
    }

    protected Collector getCollector() {
        return this.collector;
    }

    protected Context getContext() {
        return this.collector.getContext();
    }

    protected Scope getScope() {
        return this.collector.getScope();
    }

    protected Code getCode() {
        return this.collector.getCode();
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public AstNode getParent() {
        return this.parent;
    }

    private void setParent(AstNode astNode) {
        this.parent = astNode;
    }

    public <T extends AstNode> T findParent(Class<T> clazz) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getClass().equals(clazz)) {
            return (T)this.parent;
        }
        return this.parent.findParent(clazz);
    }

    public <T extends AstNode> T findParentSubclass(Class<T> clazz) {
        if (this.parent == null) {
            return null;
        }
        try {
            Class<T> clazz2 = this.parent.getClass().asSubclass(clazz);
            if (clazz2 != null) {
                return (T)this.parent;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.parent.findParent(clazz);
    }

    public <T extends AstNode> T findChild(Class<T> clazz) {
        for (AstNode astNode : this.children) {
            if (!astNode.getClass().equals(clazz)) continue;
            return (T)astNode;
        }
        return null;
    }

    public <T extends AstNode> T[] findChildren(Class<T> clazz) {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        for (AstNode astNode : this.children) {
            if (!clazz.isInstance(astNode)) continue;
            arrayList.add(astNode);
        }
        return arrayList.toArray((AstNode[])Array.newInstance(clazz, arrayList.size()));
    }

    public <T extends AstNode> T[] findAllChildren(Class<T> clazz) {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        for (AstNode astNode : this.children) {
            if (clazz.isInstance(astNode)) {
                arrayList.add(astNode);
            }
            for (AstNode astNode2 : astNode.findAllChildren(clazz)) {
                arrayList.add(astNode2);
            }
        }
        return arrayList.toArray((AstNode[])Array.newInstance(clazz, arrayList.size()));
    }

    public <T extends AstNode> T getUniqueChild(Class<T> clazz) {
        if (this.uniqueNodes != null) {
            return (T)this.uniqueNodes.get(clazz);
        }
        return null;
    }

    public <T extends AstNode> T getChild(int n2) {
        return (T)this.children.get(n2);
    }

    public AbstractOperand getChildOperand(int n2) {
        return ((AstOperand)this.children.get(n2)).getOperand();
    }

    protected <T extends AstNode> CodeBlock walkAsBranch(Class<T> clazz) {
        return this.walkAsBranch((AstNode)this.getUniqueChild(clazz));
    }

    protected <T extends AstNode> CodeBlock walkAsBranch(Class<T> clazz, int n2) {
        return this.walkAsBranch((AstNode)this.tryGetChild(clazz, n2));
    }

    protected CodeBlock walkAsBranch(AstNode astNode) {
        if (astNode != null) {
            this.getCode().push(new CodeBlock(astNode.getToken()));
            astNode.walk();
            CodeBlock codeBlock = this.getCode().pop();
            if (codeBlock.getUnreachableStatements() > 0) {
                this.consoleWrite(79, codeBlock.getLastStatement(), new Object[0]);
            }
            return codeBlock;
        }
        return null;
    }

    public <T extends AstNode> T tryGetChild(Class<T> clazz, int n2) {
        return (T)(n2 < this.children.size() ? (AstNode)Utils.as(clazz, this.children.get(n2)) : null);
    }

    public AstNode[] getChildren() {
        return this.children.toArray(new AstNode[this.children.size()]);
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public boolean isUniqueNode() {
        return false;
    }

    public AstNode(Collector collector, Token token) {
        this.collector = collector;
        this.token = token == null ? Token.NULL : token;
    }

    public AstNode(Collector collector) {
        this(collector, null);
    }

    protected void reject() {
        this.rejected = true;
    }

    public boolean push(AstNode astNode) {
        if (astNode.isUniqueNode()) {
            Class<?> clazz;
            if (this.uniqueNodes == null) {
                this.uniqueNodes = new HashMap<Class<? extends AstNode>, AstNode>();
            }
            if (this.uniqueNodes.containsKey(clazz = astNode.getClass())) {
                astNode.reject();
                astNode.consoleWrite(9, astNode.getToken(), new Object[0]);
                return false;
            }
            this.uniqueNodes.put(clazz, astNode);
        }
        if (this.isRejected()) {
            astNode.reject();
        }
        astNode.setParent(this);
        this.children.add(astNode);
        return true;
    }

    public AstNode pop() {
        return this.children.remove(this.children.size() - 1);
    }

    public void validate() {
    }

    public void walk() {
        for (AstNode astNode : this.children) {
            astNode.walk();
        }
    }

    protected AbstractOperand denyPromotion(AbstractOperand abstractOperand) {
        if (abstractOperand instanceof DataItemReference) {
            ((DataItemReference)abstractOperand).getDataItem().denyPromotion();
        }
        return abstractOperand;
    }

    protected AbstractOperand staticCast(AbstractLiteral abstractLiteral, AbstractOperand abstractOperand) {
        if (abstractOperand instanceof DataItemReference && ((DataItemReference)abstractOperand).getDataItem().isPromoted()) {
            if (abstractLiteral instanceof StringLiteral) {
                Literal literal = abstractLiteral.getValue();
                byte[] byArray = literal.getBytes();
                int n2 = 0;
                int n3 = byArray.length;
                if (n3 > 38) {
                    n2 = byArray.length - 38;
                    n3 = 38;
                }
                return new NumericLiteral(abstractLiteral, literal, new Magnitude(false, n3, 0), CobolBigDecimal.from(false, byArray, n2, n3, 0));
            }
            return abstractLiteral;
        }
        if (!abstractOperand.hasStaticSize()) {
            return abstractLiteral;
        }
        Literal literal = abstractLiteral.staticCast(abstractOperand.getBuiltIn(), abstractOperand.getMagnitude(), abstractOperand.getStaticSize());
        if (literal == null) {
            return abstractLiteral;
        }
        if (!literal.isRegistered()) {
            this.getContext().getLiterals().add(literal);
        }
        return new IntermediateReference((ISourceReference)abstractLiteral, abstractOperand.getBuiltIn(), abstractOperand.getMagnitude(), literal);
    }

    protected AbstractOperand dynamicCast(AbstractOperand abstractOperand, BuiltIn builtIn, int n2, Magnitude magnitude) {
        IntermediateReference intermediateReference = new IntermediateReference((ISourceReference)abstractOperand, builtIn, magnitude, n2);
        if (abstractOperand.matches(intermediateReference)) {
            return abstractOperand;
        }
        if (abstractOperand instanceof AbstractLiteral) {
            abstractOperand = this.staticCast((AbstractLiteral)abstractOperand, intermediateReference);
        }
        this.getCode().addStatement(new Declare(abstractOperand, intermediateReference)).addStatement(new Move(abstractOperand, abstractOperand, intermediateReference));
        return intermediateReference;
    }

    protected AbstractOperand dynamicCast(AbstractOperand abstractOperand, BuiltIn builtIn, int n2) {
        return this.dynamicCast(abstractOperand, builtIn, n2, null);
    }

    private boolean isNonNumericDisplay(AbstractOperand abstractOperand) {
        return !IOperand.isNumeric(abstractOperand) && (abstractOperand.getBuiltIn().is(DataUsage.DISPLAY) || abstractOperand.getBuiltIn() == BuiltIn.STRING_LITERAL);
    }

    private boolean isIntegerAny(AbstractOperand abstractOperand) {
        return IOperand.isNumeric(abstractOperand) && !IOperand.isFloatingPoint(abstractOperand);
    }

    private BuiltIn getMatchingType() {
        return this.getContext().isAscii() ? BuiltIn.ALPHA_NUM : BuiltIn.ALPHA_NUM_EBCDIC;
    }

    protected IntermediateCondition createCondition(Operators operators, AbstractOperand abstractOperand, AbstractOperand abstractOperand2) {
        int n2 = 2;
        if (this.isNonNumericDisplay(abstractOperand) && this.isIntegerAny(abstractOperand2)) {
            abstractOperand2 = this.dynamicCast(abstractOperand2, this.getMatchingType(), abstractOperand2.getMagnitude().getDigits());
        } else if (this.isIntegerAny(abstractOperand) && this.isNonNumericDisplay(abstractOperand2)) {
            abstractOperand = this.dynamicCast(abstractOperand, this.getMatchingType(), abstractOperand.getMagnitude().getDigits());
        }
        if (this.isNonNumericDisplay(abstractOperand) && this.isNonNumericDisplay(abstractOperand2)) {
            n2 = 1;
        }
        return new IntermediateCondition((ISourceReference)this.getToken(), operators, n2, abstractOperand, abstractOperand2);
    }

    protected void consoleWrite(String string) {
        this.getContext().getConsole().write(string);
    }

    protected void consoleWrite(CompilerMessage compilerMessage) {
        this.getContext().getConsole().write(compilerMessage);
    }

    protected void consoleWrite(int n2, ISourceReference iSourceReference, Object ... objectArray) {
        this.consoleWrite(new CompilerMessage(n2, iSourceReference, objectArray));
    }

    protected void unsupportedFeature(ISourceReference iSourceReference) {
        this.consoleWrite(6, iSourceReference, new Object[0]);
    }

    protected static COBOLCompilerException unexpectedTokenException(Token token) {
        return new COBOLCompilerException(new CompilerMessage(2, token, token.image));
    }

    protected static COBOLCompilerException userNameNotUniqueException(Token token) {
        return new COBOLCompilerException(new CompilerMessage(36, token, token.image));
    }

    public String toString() {
        Token token = this.getToken();
        if (token == null || token == Token.NULL) {
            return this.toStringNoImage();
        }
        return token.image;
    }

    public String toStringNoImage() {
        return "<" + this.getClass().getSimpleName() + ">";
    }
}

