/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstStringLiteral;
import com.veryant.cobol.compiler.frontend.Token;
import java.util.ArrayList;

public class AstPicture
extends AstNode {
    public static final short NO_TYPE = 0;
    public static final short NUMERIC = 1;
    public static final short NUM_EDIT = 2;
    public static final short ALPHA = 4;
    public static final short ALPHA_NUM = 8;
    public static final short ALPHA_NUM_EDIT = 16;
    public static final short NATIONAL = 32;
    public static final short NATIONAL_EDIT = 64;
    public static final short BIT = 128;
    public static final short TYPE_MASK = 255;
    private char decimalChar = (char)46;
    private char thousandsChar = (char)44;
    private char currencyChar = (char)36;
    private ArrayList<Byte> editMask;
    private int type;
    private int size;
    private boolean signed;
    private int digits;
    private int scale;

    @Override
    public boolean isUniqueNode() {
        return true;
    }

    public boolean isEditedPicture() {
        return this.type == 16 || this.type == 2 || this.type == 64;
    }

    public byte[] getEditMask() {
        byte[] byArray = new byte[this.editMask.size()];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = this.editMask.get(i2);
        }
        return byArray;
    }

    public AstPicture(Collector collector, Token token) {
        super(collector, token);
    }

    private void pushEditChar(int n2) {
        byte by;
        if (this.editMask == null) {
            this.editMask = new ArrayList();
        }
        byte by2 = (byte)(n2 << 4 & 0xF0);
        int n3 = 0;
        if (!this.editMask.isEmpty() && by2 == (byte)((by = this.editMask.get(this.editMask.size() - 1).byteValue()) & 0xF0)) {
            n3 = (by & 0xF) + 1;
            this.editMask.remove(this.editMask.size() - 1);
        }
        do {
            this.editMask.add((byte)(by2 | n3 & 0xF));
        } while ((n3 >>= 4) != 0);
    }

    private boolean parse(byte[] byArray) {
        this.type = 255;
        int n2 = byArray.length;
        block14: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = (char)byArray[i2];
            switch (c2) {
                case '1': {
                    this.type &= 0x80;
                    continue block14;
                }
                case 'N': {
                    this.type &= 0x60;
                    continue block14;
                }
                case 'X': {
                    this.type &= 0x18;
                    continue block14;
                }
                case 'A': {
                    this.type &= 0x1C;
                    continue block14;
                }
                case '/': 
                case '0': 
                case 'B': {
                    this.type &= 0x52;
                    continue block14;
                }
                case '9': {
                    this.type &= 0x1B;
                    continue block14;
                }
                case 'S': {
                    this.type &= 1;
                    continue block14;
                }
                case 'P': 
                case 'V': {
                    this.type &= 3;
                    continue block14;
                }
                case '*': 
                case '+': 
                case '-': 
                case 'Z': {
                    this.type &= 2;
                    continue block14;
                }
                case 'C': {
                    if (i2 < n2 - 1 && byArray[i2 + 1] == 82) {
                        ++i2;
                        this.type &= 2;
                        continue block14;
                    }
                    return false;
                }
                case 'D': {
                    if (i2 < n2 - 1 && byArray[i2 + 1] == 66) {
                        ++i2;
                        this.type &= 2;
                        continue block14;
                    }
                    return false;
                }
                case '(': {
                    do {
                        if (++i2 >= n2) {
                            return false;
                        }
                        c2 = (char)byArray[i2];
                        if (c2 == ')') continue block14;
                    } while (Character.isDigit(c2));
                    return false;
                }
                default: {
                    if (c2 == this.currencyChar || c2 == this.decimalChar || c2 == this.thousandsChar) {
                        this.type &= 2;
                        continue block14;
                    }
                    return false;
                }
            }
        }
        if (this.type == 0) {
            return false;
        }
        this.type = (this.type & 0x80) != 0 ? 128 : ((this.type & 1) != 0 ? 1 : ((this.type & 4) != 0 ? 4 : ((this.type & 0x20) != 0 ? 32 : ((this.type & 8) != 0 ? 8 : ((this.type & 2) != 0 ? 2 : ((this.type & 0x10) != 0 ? 16 : 64))))));
        return this.check(byArray);
    }

    private boolean check(byte[] byArray) {
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        char c2 = ' ';
        this.size = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            if (bl4) {
                return false;
            }
            char c3 = (char)byArray[i2];
            if (bl5 && c3 != 'P') {
                return false;
            }
            if (i2 < n4 - 1 && byArray[i2 + 1] == 40) {
                char c4;
                n5 = 0;
                ++i2;
                while ((c4 = (char)byArray[++i2]) != ')') {
                    if ((n5 = 10 * n5 + (c4 - 48)) >= 0) continue;
                    this.errorNumberTooLarge();
                    while (c4 != ')') {
                        c4 = (char)byArray[++i2];
                    }
                    n5 = 1;
                    break;
                }
            } else {
                n5 = 1;
            }
            while (n5 > 0) {
                if (this.isEditedPicture()) {
                    switch (c3) {
                        case 'B': {
                            this.pushEditChar(0);
                            break;
                        }
                        case '-': {
                            this.pushEditChar(1);
                            break;
                        }
                        case '+': {
                            this.pushEditChar(2);
                            break;
                        }
                        case '0': {
                            this.pushEditChar(3);
                            break;
                        }
                        case '9': {
                            this.pushEditChar(4);
                            break;
                        }
                        case 'Z': {
                            this.pushEditChar(5);
                            break;
                        }
                        case 'A': {
                            this.pushEditChar(5);
                            break;
                        }
                        case 'X': {
                            this.pushEditChar(5);
                            break;
                        }
                        case 'N': {
                            this.pushEditChar(5);
                            break;
                        }
                        case '*': {
                            this.pushEditChar(6);
                            break;
                        }
                        case '/': {
                            this.pushEditChar(7);
                            break;
                        }
                        case 'C': {
                            this.pushEditChar(11);
                            break;
                        }
                        case 'V': {
                            this.pushEditChar(12);
                            break;
                        }
                        case 'D': {
                            this.pushEditChar(13);
                            break;
                        }
                        case 'P': {
                            this.pushEditChar(14);
                            break;
                        }
                        default: {
                            if (c3 == this.decimalChar) {
                                this.pushEditChar(9);
                                break;
                            }
                            if (c3 == this.thousandsChar) {
                                this.pushEditChar(10);
                                break;
                            }
                            this.pushEditChar(8);
                        }
                    }
                }
                switch (c3) {
                    case 'A': 
                    case 'N': 
                    case 'X': {
                        bl2 = false;
                        this.size += n5;
                        n2 += n5;
                        n5 = 0;
                        break;
                    }
                    case '/': 
                    case '0': 
                    case 'B': {
                        bl2 = false;
                        this.size += n5;
                        n5 = 0;
                        break;
                    }
                    case '1': 
                    case '9': {
                        bl2 = false;
                        this.size += n5;
                        n2 += n5;
                        if (bl3) {
                            n3 += n5;
                        }
                        n5 = 0;
                        break;
                    }
                    case 'V': {
                        bl2 = false;
                        if (!bl3) {
                            bl3 = true;
                            break;
                        }
                        return false;
                    }
                    case 'S': {
                        if (bl2 && !bl6 && n3 == 0) {
                            bl6 = true;
                            break;
                        }
                        return false;
                    }
                    case 'P': {
                        if (bl2 && c2 == ' ') {
                            bl3 = true;
                            n3 += n5;
                            n5 = 0;
                            break;
                        }
                        if (!bl2 && !bl3) {
                            bl5 = true;
                            n3 -= n5;
                            n5 = 0;
                            break;
                        }
                        return false;
                    }
                    case '*': 
                    case 'Z': {
                        if (bl2) {
                            bl2 = false;
                            c2 = c3;
                            ++this.size;
                            ++n2;
                            break;
                        }
                        if (c3 == c2) {
                            ++this.size;
                            ++n2;
                            if (!bl3) break;
                            ++n3;
                            break;
                        }
                        return false;
                    }
                    case '+': 
                    case '-': {
                        if (!bl6) {
                            bl6 = true;
                            boolean bl7 = bl4 = !bl2;
                            if (bl2) {
                                c2 = c3;
                            }
                            ++this.size;
                            break;
                        }
                        if (c3 == c2) {
                            bl2 = false;
                            ++this.size;
                            ++n2;
                            if (!bl3) break;
                            ++n3;
                            break;
                        }
                        return false;
                    }
                    case 'C': 
                    case 'D': {
                        if (!bl6) {
                            bl6 = true;
                            bl4 = true;
                            this.size += 2;
                            ++i2;
                            break;
                        }
                        return false;
                    }
                    default: {
                        if (c3 == this.decimalChar) {
                            bl2 = false;
                            if (!bl3) {
                                ++this.size;
                                bl3 = true;
                                break;
                            }
                        } else {
                            if (c3 == this.thousandsChar) {
                                bl2 = false;
                                ++this.size;
                                break;
                            }
                            if (c3 == this.currencyChar) {
                                if (!bl && bl2) {
                                    bl = true;
                                    c2 = c3;
                                    ++this.size;
                                    break;
                                }
                                if (c3 == c2) {
                                    bl2 = false;
                                    ++this.size;
                                    ++n2;
                                    if (!bl3) break;
                                    ++n3;
                                    break;
                                }
                            }
                        }
                        return false;
                    }
                }
                --n5;
            }
        }
        if (n2 == 0) {
            this.errorPicNoSize();
        } else if (this.type == 1 || this.type == 2) {
            this.signed = bl6;
            this.digits = n2;
            this.scale = -n3;
            if (this.digits > this.getContext().getARITH().getArithOption().getDigits()) {
                this.errorPicTooLarge();
            }
        }
        return true;
    }

    @Override
    public void validate() {
        AstStringLiteral astStringLiteral = (AstStringLiteral)this.getChild(0);
        byte[] byArray = astStringLiteral.getOperand().getValue().getBytes();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)Character.toUpperCase(byArray[i2]);
        }
        Context context = this.getContext();
        if (context.isDecimalPointIsComma()) {
            this.decimalChar = (char)44;
            this.thousandsChar = (char)46;
        }
        this.currencyChar = (char)context.getCurrencySymbol();
        if (byArray.length == 0) {
            this.errorEmptyPic();
        } else if (!this.parse(byArray)) {
            this.errorIllegalPic();
        }
    }

    private void errorNumberTooLarge() {
        this.consoleWrite(16, ((AstNode)this.getChild(0)).getToken(), new Object[0]);
    }

    private void errorPicNoSize() {
        this.consoleWrite(17, ((AstNode)this.getChild(0)).getToken(), new Object[0]);
    }

    private void errorPicTooLarge() {
        Token token = ((AstNode)this.getChild(0)).getToken();
        this.consoleWrite(19, token, token.image);
    }

    private void errorEmptyPic() {
        this.consoleWrite(18, ((AstNode)this.getChild(0)).getToken(), new Object[0]);
    }

    private void errorIllegalPic() {
        Token token = ((AstNode)this.getChild(0)).getToken();
        this.consoleWrite(15, token, token.image);
    }

    public int getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getDigits() {
        return this.digits;
    }

    public int getScale() {
        return this.scale;
    }
}

