/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstOf;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.scope.ParagraphDeclaration;
import com.veryant.cobol.compiler.scope.Scope;
import com.veryant.cobol.compiler.scope.SectionDeclaration;

public class AstProcedureName
extends AstNode {
    private final SectionDeclaration container = this.getScope().getCurrentSection();
    private int start = -1;
    private int end = -1;

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public AstProcedureName(Collector collector, Token token) {
        super(collector, token);
    }

    private boolean checkRefCount(int n2, AstNode astNode) {
        if (n2 == 0) {
            this.consoleWrite(66, astNode.getToken(), astNode);
            return false;
        }
        if (n2 > 1) {
            this.consoleWrite(67, astNode.getToken(), astNode);
            return false;
        }
        return true;
    }

    @Override
    public void walk() {
        Scope scope = this.getScope();
        String string = this.getToken().image;
        if (this.getChildrenCount() > 0) {
            ParagraphDeclaration[] paragraphDeclarationArray;
            AstOf astOf = (AstOf)this.getChild(0);
            SectionDeclaration[] sectionDeclarationArray = scope.getSection(astOf.getQualifier());
            if (this.checkRefCount(sectionDeclarationArray.length, astOf) && this.checkRefCount((paragraphDeclarationArray = this.getScope().getParagraph(string, sectionDeclarationArray[0])).length, this)) {
                this.end = this.start = paragraphDeclarationArray[0].getIndex();
            }
        } else {
            SectionDeclaration[] sectionDeclarationArray = scope.getSection(string);
            ParagraphDeclaration[] paragraphDeclarationArray = scope.getParagraph(string, this.container);
            if (paragraphDeclarationArray.length == 0) {
                paragraphDeclarationArray = scope.getParagraph(string);
            }
            if (this.checkRefCount(sectionDeclarationArray.length + paragraphDeclarationArray.length, this)) {
                if (sectionDeclarationArray.length > 0) {
                    this.start = sectionDeclarationArray[0].getSection().getStart();
                    this.end = sectionDeclarationArray[0].getSection().getEnd();
                } else {
                    this.end = this.start = paragraphDeclarationArray[0].getIndex();
                }
            }
        }
    }
}

