/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.EntryPoint;
import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.UsingParameterMode;
import com.veryant.cobol.compiler.ast.AstCallConvention;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.common.AstGiving;
import com.veryant.cobol.compiler.ast.common.AstNotOnException;
import com.veryant.cobol.compiler.ast.common.AstOnException;
import com.veryant.cobol.compiler.ast.common.AstUsing;
import com.veryant.cobol.compiler.ast.common.AstUsingParameter;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import com.veryant.cobol.compiler.stmts.Call;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.StringLiteral;
import com.veryant.cobol.rununit.Environment;

public class AstCallStatement
extends AstNode {
    public AstCallStatement(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void validate() {
        AstUsing astUsing = this.getUniqueChild(AstUsing.class);
        if (astUsing != null) {
            int n2 = astUsing.getChildrenCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                AstUsingParameter astUsingParameter = (AstUsingParameter)astUsing.getChild(i2);
                AbstractOperand abstractOperand = astUsingParameter.getChildOperand(0);
                if (IOperand.isNumeric(abstractOperand) && astUsingParameter.getMode() != UsingParameterMode.Reference) continue;
                this.denyPromotion(abstractOperand);
            }
        }
    }

    @Override
    public void walk() {
        Object object;
        AstCallConvention astCallConvention = this.getUniqueChild(AstCallConvention.class);
        AbstractOperand abstractOperand = this.getChildOperand(astCallConvention == null ? 0 : 1);
        if (IOperand.isNumeric(abstractOperand)) {
            this.consoleWrite(81, abstractOperand, new Object[0]);
        }
        EntryPoint entryPoint = null;
        if (abstractOperand instanceof StringLiteral) {
            entryPoint = Context.retrieveEntryPoint(Environment.translateToValidJavaIdentifier(abstractOperand.toString()));
        }
        AstUsing astUsing = this.getUniqueChild(AstUsing.class);
        AbstractOperand[] abstractOperandArray = null;
        UsingParameterMode[] usingParameterModeArray = null;
        if (astUsing != null) {
            int n2 = astUsing.getChildrenCount();
            abstractOperandArray = new AbstractOperand[n2];
            usingParameterModeArray = new UsingParameterMode[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                object = (AstUsingParameter)astUsing.getChild(i2);
                usingParameterModeArray[i2] = ((AstUsingParameter)object).getMode();
                abstractOperandArray[i2] = ((AstNode)object).getChildOperand(0);
            }
        }
        AstGiving astGiving = this.getUniqueChild(AstGiving.class);
        AbstractOperand abstractOperand2 = null;
        if (astGiving != null) {
            abstractOperand2 = astGiving.getOperands()[0];
        }
        object = new Call(this.getToken(), entryPoint, abstractOperand, usingParameterModeArray, abstractOperandArray, abstractOperand2);
        ((Call)object).setExceptionBlock(this.walkAsBranch(AstOnException.class));
        ((Call)object).setNotExceptionBlock(this.walkAsBranch(AstNotOnException.class));
        this.getCode().addStatement((AbstractStatement)object);
    }
}

