/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Code;
import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ast.AstBlock;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstPerformVarying;
import com.veryant.cobol.compiler.ast.AstProcedureName;
import com.veryant.cobol.compiler.ast.AstTest;
import com.veryant.cobol.compiler.ast.common.AstTimes;
import com.veryant.cobol.compiler.ast.common.AstUntil;
import com.veryant.cobol.compiler.ast.statements.AstExitStatement;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import com.veryant.cobol.compiler.stmts.CodeBlock;
import com.veryant.cobol.compiler.stmts.Perform;
import com.veryant.cobol.compiler.stmts.PerformNTimes;
import com.veryant.cobol.compiler.stmts.PerformUntil;
import com.veryant.cobol.compiler.stmts.PerformVarying;
import com.veryant.cobol.compiler.types.IntermediateCondition;

public class AstPerformStatement
extends AstNode {
    private AbstractStatement inlinePerformStatement = null;

    public AstPerformStatement(Collector collector, Token token) {
        super(collector, token);
    }

    private AbstractStatement resolvePerform() {
        AstBlock astBlock = this.getUniqueChild(AstBlock.class);
        if (astBlock != null) {
            return this.walkAsBranch(astBlock);
        }
        super.walk();
        AstProcedureName astProcedureName = (AstProcedureName)this.getChild(0);
        int n2 = astProcedureName.getStart();
        int n3 = astProcedureName.getEnd();
        AstProcedureName astProcedureName2 = this.tryGetChild(AstProcedureName.class, 1);
        if (astProcedureName2 != null) {
            n3 = astProcedureName2.getEnd();
        }
        return new Perform(this.getToken(), n2, n3);
    }

    private CodeBlock resolvePerformAsBlock() {
        AbstractStatement abstractStatement = this.resolvePerform();
        if (abstractStatement instanceof CodeBlock) {
            return (CodeBlock)abstractStatement;
        }
        this.getCode().push(new CodeBlock());
        this.getCode().addStatement(abstractStatement);
        return this.getCode().pop();
    }

    @Override
    public void walk() {
        Code code = this.getCode();
        if (this.walkPerformNTimes(code) || this.walkPerformUntil(code) || this.walkPerformVarying(code) || this.walkPerformNothing(code)) {
            for (AstExitStatement astExitStatement : (AstExitStatement[])this.findAllChildren(AstExitStatement.class)) {
                astExitStatement.updateInlinePerformStatement(this.inlinePerformStatement);
            }
            return;
        }
        this.unsupportedFeature(this.getToken());
    }

    private boolean walkPerformNTimes(Code code) {
        AstTimes astTimes = this.getUniqueChild(AstTimes.class);
        if (astTimes != null) {
            this.inlinePerformStatement = new PerformNTimes(this.getToken(), astTimes.getTimes(), this.resolvePerformAsBlock());
            code.addStatement(this.inlinePerformStatement);
            return true;
        }
        return false;
    }

    private boolean walkPerformUntil(Code code) {
        AstUntil astUntil = this.getUniqueChild(AstUntil.class);
        if (astUntil != null) {
            if (astUntil.getChildrenCount() == 0) {
                this.inlinePerformStatement = new PerformUntil(this.getToken(), null, this.resolvePerformAsBlock());
                code.addStatement(this.inlinePerformStatement);
                return true;
            }
            PerformUntil performUntil = new PerformUntil(this.getToken(), astUntil.getChildOperand(0), this.resolvePerformAsBlock());
            AstTest astTest = this.getUniqueChild(AstTest.class);
            if (astTest != null) {
                performUntil.setAfter(astTest.isAfter());
                performUntil.setBefore(astTest.isBefore());
            }
            this.inlinePerformStatement = performUntil;
            code.addStatement(this.inlinePerformStatement);
            return true;
        }
        return false;
    }

    private boolean walkPerformVarying(Code code) {
        AstPerformVarying[] astPerformVaryingArray = (AstPerformVarying[])this.findChildren(AstPerformVarying.class);
        if (astPerformVaryingArray.length == 0) {
            return false;
        }
        PerformVarying performVarying = new PerformVarying(this.getToken(), this.resolvePerformAsBlock());
        AstTest astTest = this.getUniqueChild(AstTest.class);
        if (astTest != null) {
            performVarying.setAfter(astTest.isAfter());
            performVarying.setBefore(astTest.isBefore());
        }
        for (AstPerformVarying astPerformVarying : astPerformVaryingArray) {
            performVarying.addData(astPerformVarying.getChildOperand(0), astPerformVarying.getChildOperand(1), astPerformVarying.getChildOperand(2), (IntermediateCondition)astPerformVarying.getChildOperand(3));
        }
        this.inlinePerformStatement = performVarying;
        code.addStatement(this.inlinePerformStatement);
        return true;
    }

    private boolean walkPerformNothing(Code code) {
        this.inlinePerformStatement = this.resolvePerform();
        code.addStatement(this.inlinePerformStatement);
        return true;
    }

    @Override
    public String toString() {
        return this.findChild(AstProcedureName.class) == null ? "inline-perform" : "perform";
    }
}

