/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseDirective {
    private String prevToString = "";
    protected boolean isNo;
    protected String immediateSet = null;
    protected String atEndSet = null;
    protected final ArrayList<String> tokens = new ArrayList();
    protected static final Pattern quotedStringPattern = Pattern.compile("^\"(?<value>[^\"]*)\"");
    protected static final Pattern balancedValuePattern = Pattern.compile("^\\((?<value>[^)]*)\\)");

    public final boolean isNo() {
        return this.isNo;
    }

    public final boolean isSet() {
        return !this.isNo;
    }

    public abstract boolean isNoAllowed();

    public abstract Set getSet();

    public String getImmediateSet() {
        return this.immediateSet;
    }

    public String getAtEndSet() {
        return this.atEndSet;
    }

    public BaseDirective(boolean bl, String string, String string2) {
        this.isNo = bl;
        this.immediateSet = string;
        this.atEndSet = string2;
        this.initialize();
    }

    public abstract int getIndex();

    public abstract String getName();

    public final boolean mergeWith(Phase phase, BaseDirective baseDirective) {
        if (this.merge(phase, baseDirective)) {
            if (!this.toString().equals(baseDirective.toString())) {
                this.prevToString = this.toString() + " ";
            }
            this.tokens.clear();
            this.tokens.addAll(baseDirective.tokens);
            return true;
        }
        return false;
    }

    public final String parseTokens(String string) throws InvalidDirectiveException {
        string = string.trim();
        this.tokens.clear();
        return this.parseTokensImpl(string);
    }

    public void checkSetLegal(Phase phase, Set set) throws InvalidDirectiveException {
        if (phase.compareTo(Phase.Init) >= 0 && set == Set.No) {
            throw Directives.invalidDirectiveException("Directive %s: set not allowed.", this.getName());
        }
        if (phase.compareTo(Phase.AfterInit) >= 0 && set == Set.Init) {
            throw Directives.invalidDirectiveException("Directive %s is init only.", this.getName());
        }
    }

    protected String getDestinationFileName(File file, String string, String string2) throws IOException {
        if (this.isNo()) {
            return null;
        }
        file = file.getCanonicalFile();
        String string3 = Utils.basename(file);
        if (Utils.isValidDirectory(string)) {
            return Utils.pathMerge(string, string3 + string2);
        }
        if (string.length() == 0) {
            return Utils.pathMerge(file.getCanonicalFile().getParent(), string3 + string2);
        }
        return string;
    }

    public String toString() {
        return this.prevToString + (this.isNo() ? "NO" : "") + this.getName() + String.join((CharSequence)" ", this.tokens);
    }

    public final int getTokenCount() {
        return this.tokens.size();
    }

    protected final String parseQuotedTokensWithEqualChar(String string) {
        if (string.length() == 0) {
            return "";
        }
        if (!string.startsWith("\"")) {
            return string;
        }
        String string2 = string;
        Matcher matcher = quotedStringPattern.matcher(string2);
        if (!matcher.find()) {
            return string;
        }
        String string3 = string2.substring(matcher.start(), matcher.end());
        if (!(string2 = string2.substring(matcher.end()).trim()).startsWith("=")) {
            return string;
        }
        if (!(string2 = string2.substring(1).trim()).startsWith("\"")) {
            return string;
        }
        matcher = quotedStringPattern.matcher(string2);
        if (!matcher.find()) {
            return string;
        }
        this.tokens.add(string3);
        this.tokens.add(string2.substring(matcher.start(), matcher.end()));
        string2 = string2.substring(matcher.end()).trim();
        return string2;
    }

    protected void checkMaxParams(int n2) throws InvalidDirectiveException {
        if (this.tokens.size() > n2) {
            throw Directives.invalidDirectiveException("Directive %s: No more than %d parameter(s) allowed.", this.getName(), n2);
        }
    }

    protected void checkParameterCount(int n2, int n3) throws InvalidDirectiveException {
        if (this.tokens.size() < n2 || this.tokens.size() > n3) {
            if (n3 < Integer.MAX_VALUE) {
                throw Directives.invalidDirectiveException("Directive %s: %d to %d parameter(s) required.", this.getName(), n2, n3);
            }
            throw Directives.invalidDirectiveException("Directive %s: At least %d parameter(s) required.", this.getName(), n2);
        }
    }

    protected void checkParameterCount(int n2) throws InvalidDirectiveException {
        if (this.tokens.size() != n2) {
            throw Directives.invalidDirectiveException("Directive %s: %d parameter(s) expected.", this.getName(), n2);
        }
    }

    protected String getTokenValue(int n2) {
        String string = this.tokens.get(n2);
        return string.substring(1, string.length() - 1);
    }

    protected final int getTokenIntegerValue(int n2) throws InvalidDirectiveException {
        return this.getTokenIntegerValue(this.getTokenValue(n2));
    }

    protected final int getTokenIntegerValue(String string) throws InvalidDirectiveException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw Directives.invalidDirectiveException("Directive %s: Invalid parameter %s (not a number).", this.getName(), string);
        }
    }

    protected final int getTokenUnsignedIntegerValue(int n2) throws InvalidDirectiveException {
        return this.getTokenUnsignedIntegerValue(this.getTokenValue(n2));
    }

    protected final int getTokenUnsignedIntegerValue(String string) throws InvalidDirectiveException {
        try {
            return Integer.parseUnsignedInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw Directives.invalidDirectiveException("Directive %s: Invalid parameter %s (not a number).", this.getName(), string);
        }
    }

    protected final int getTokenIntegerValue(int n2, int n3, int n4) throws InvalidDirectiveException {
        return this.getTokenIntegerValue(this.getTokenValue(n2), n3, n4);
    }

    protected final int getTokenIntegerValue(String string, int n2, int n3) throws InvalidDirectiveException {
        int n4 = this.getTokenIntegerValue(string);
        if (n4 < n2 || n4 > n3) {
            throw Directives.invalidDirectiveException("Directive %s: Invalid value %d. Valid range is %d through %d.", this.getName(), n4, n2, n3);
        }
        return n4;
    }

    protected final <T extends Enum<T>> T getEnumValue(int n2, boolean bl, Class<T> clazz) throws InvalidDirectiveException {
        return this.getEnumValue(this.getTokenValue(n2), bl, clazz);
    }

    protected final <T extends Enum<T>> T getEnumValue(String string, boolean bl, Class<T> clazz) throws InvalidDirectiveException {
        Enum[] enumArray;
        String string2;
        block5: {
            string2 = string.replace('-', '_');
            enumArray = (Enum[])clazz.getEnumConstants();
            try {
                if (bl) {
                    for (Enum enum_ : enumArray) {
                        if (!enum_.toString().equalsIgnoreCase(string2)) continue;
                        return (T)enum_;
                    }
                    break block5;
                }
                return Enum.valueOf(clazz, string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Object[] objectArray = new String[enumArray.length];
        for (int i2 = 0; i2 < enumArray.length; ++i2) {
            objectArray[i2] = enumArray[i2].toString();
        }
        throw Directives.invalidDirectiveException("Directive %s: Invalid value %s. Value must be one of the following: \"%s\"", this.getName(), string2, String.join((CharSequence)"\", \"", (CharSequence[])objectArray));
    }

    protected final <T extends Enum<T>, U extends Enum<U>> Enum getEnumValue(int n2, boolean bl, Class<T> clazz, Class<U> clazz2) throws InvalidDirectiveException {
        return this.getEnumValue(this.getTokenValue(n2), bl, clazz, clazz2);
    }

    protected final <T extends Enum<T>, U extends Enum<U>> Enum getEnumValue(String string, boolean bl, Class<T> clazz, Class<U> clazz2) throws InvalidDirectiveException {
        Enum[] enumArray;
        Enum[] enumArray2;
        String string2;
        block9: {
            string2 = string.replace('-', '_');
            enumArray2 = (Enum[])clazz.getEnumConstants();
            enumArray = (Enum[])clazz2.getEnumConstants();
            try {
                if (bl) {
                    for (Enum object : enumArray2) {
                        if (!object.toString().equalsIgnoreCase(string2)) continue;
                        return object;
                    }
                    for (Enum enum_ : enumArray) {
                        if (!enum_.toString().equalsIgnoreCase(string2)) continue;
                        return enum_;
                    }
                    break block9;
                }
                try {
                    return Enum.valueOf(clazz, string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return Enum.valueOf(clazz2, string2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Object[] objectArray = new String[enumArray2.length + enumArray.length];
        int n2 = 0;
        for (Enum enum_ : enumArray2) {
            objectArray[n2++] = enum_.toString();
        }
        for (Enum enum_ : enumArray) {
            objectArray[n2++] = enum_.toString();
        }
        throw Directives.invalidDirectiveException("Directive %s: Invalid value %s. Value must be one of the following: \"%s\"", this.getName(), string2, String.join((CharSequence)"\", \"", (CharSequence[])objectArray));
    }

    protected final void checkTokenValues(int n2, boolean bl, String ... stringArray) throws InvalidDirectiveException {
        this.checkTokenValues(this.getTokenValue(n2), bl, stringArray);
    }

    protected final void checkTokenValues(String string, boolean bl, String ... stringArray) throws InvalidDirectiveException {
        if (bl) {
            for (String string2 : stringArray) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return;
            }
        } else {
            for (String string3 : stringArray) {
                if (!string.equals(string3)) continue;
                return;
            }
        }
        switch (stringArray.length) {
            case 0: {
                throw Directives.invalidDirectiveException("Directive %s: Invalid value %s.", this.getName(), string);
            }
            case 1: {
                throw Directives.invalidDirectiveException("Directive %s: Invalid value %s, \"%s\" expected.", this.getName(), string, stringArray[0]);
            }
        }
        throw Directives.invalidDirectiveException("Directive %s: Invalid value %s. Value must be one of the following: \"%s\"", this.getName(), string, String.join((CharSequence)"\", \"", stringArray));
    }

    public boolean hasParameters() {
        return false;
    }

    protected void initialize() {
    }

    protected boolean merge(Phase phase, BaseDirective baseDirective) {
        return false;
    }

    protected String parseTokensImpl(String string) throws InvalidDirectiveException {
        if (string.length() == 0) {
            return "";
        }
        if (!string.startsWith("\"") && !string.startsWith("(")) {
            return string;
        }
        while (true) {
            Matcher matcher;
            if (string.startsWith("\"")) {
                matcher = quotedStringPattern.matcher(string);
            } else {
                if (!string.startsWith("(")) break;
                matcher = balancedValuePattern.matcher(string);
            }
            if (!matcher.find()) {
                return string;
            }
            this.tokens.add(string.substring(matcher.start(), matcher.end()));
            string = string.substring(matcher.end()).trim();
        }
        if (!this.hasParameters()) {
            this.checkParameterCount(0);
        }
        return string;
    }

    public void checkSetLegal(Phase phase) throws InvalidDirectiveException {
        this.checkSetLegal(phase, this.getSet());
    }

    public BaseDirective checkCompatibility(Directives directives) {
        return null;
    }

    public boolean applyOtherDirectives() {
        return this.isSet();
    }

    public void setValues() throws InvalidDirectiveException {
    }

    public static enum Phase {
        SetDefaults,
        OptionFile,
        CommandLine,
        Clone,
        ImmediateSet,
        AtEnd,
        Init,
        AfterInit;

    }

    public static enum Set {
        Init,
        Any,
        No;

    }
}

