/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.CompilerMessageSeverity;
import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.HashMap;

public final class CHANGEMESSAGE
extends BaseDirective {
    public static final String NAME = "CHANGEMESSAGE";
    private HashMap<String, CompilerMessageSeverity> messageMap;

    @Override
    protected void initialize() {
        this.messageMap = new HashMap();
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        if (this.isNo()) {
            return;
        }
        this.checkParameterCount(1);
        String[] stringArray = this.getTokenValue(0).split(" +");
        if (stringArray.length % 2 != 0) {
            throw Directives.invalidDirectiveException("Directive %s: You must specify an even number of parameters.", NAME);
        }
        CompilerMessageSeverity compilerMessageSeverity = null;
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            this.checkTokenValues(stringArray[i2 + 1], true, "S", "E", "W", "I", "N", "R");
            switch (stringArray[i2 + 1]) {
                case "s": 
                case "S": {
                    compilerMessageSeverity = CompilerMessageSeverity.C;
                    break;
                }
                case "e": 
                case "E": {
                    compilerMessageSeverity = CompilerMessageSeverity.E;
                    break;
                }
                case "w": 
                case "W": {
                    compilerMessageSeverity = CompilerMessageSeverity.W;
                    break;
                }
                case "i": 
                case "I": {
                    compilerMessageSeverity = CompilerMessageSeverity.I;
                    break;
                }
                case "n": 
                case "N": {
                    compilerMessageSeverity = CompilerMessageSeverity.N;
                    break;
                }
                case "r": 
                case "R": {
                    compilerMessageSeverity = null;
                }
            }
            if (compilerMessageSeverity != null) {
                this.messageMap.put(stringArray[i2], compilerMessageSeverity);
                continue;
            }
            this.messageMap.remove(stringArray[i2]);
        }
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return true;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Any;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("NOCHANGE-MESSAGE");
    }

    public HashMap<String, CompilerMessageSeverity> getMessageMap() {
        return this.messageMap;
    }

    public CHANGEMESSAGE(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 38;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

