/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.Arrays;

public final class COPYLIST
extends BaseDirective {
    public static final String NAME = "COPYLIST";
    private boolean[] segments;

    @Override
    protected void initialize() {
        this.segments = new boolean[100];
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        if (this.isNo()) {
            Arrays.fill(this.segments, false);
            return;
        }
        this.checkMaxParams(1);
        if (this.getTokenCount() == 0) {
            Arrays.fill(this.segments, true);
        } else if (this.getTokenValue(0).equalsIgnoreCase("ALL")) {
            Arrays.fill(this.segments, true);
        } else {
            int n2 = this.getTokenIntegerValue(0, 0, 99);
            if (n2 > 0 && n2 < 50) {
                throw Directives.invalidDirectiveException("Directive %s: The segment must be 0 or in the range 50 through 99.", NAME);
            }
            this.segments[n2] = true;
        }
    }

    @Override
    protected boolean merge(BaseDirective.Phase phase, BaseDirective baseDirective) {
        if (baseDirective.isNo()) {
            Arrays.fill(this.segments, false);
        } else {
            COPYLIST cOPYLIST = (COPYLIST)baseDirective;
            for (int i2 = 0; i2 < this.segments.length; ++i2) {
                int n2 = i2;
                this.segments[n2] = this.segments[n2] | cOPYLIST.segments[i2];
            }
        }
        return true;
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return true;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Any;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault(NAME);
    }

    public boolean[] getSegments() {
        return this.segments;
    }

    public COPYLIST(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 65;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

