/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.ArrayList;

public final class HIDEMESSAGE
extends BaseDirective {
    public static final String NAME = "HIDEMESSAGE";
    private ArrayList<String> messages;

    @Override
    protected void initialize() {
        this.messages = new ArrayList();
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        String string;
        if (this.isNo() && this.getTokenCount() == 0) {
            this.messages.clear();
            return;
        }
        this.checkParameterCount(1);
        String string2 = this.getTokenValue(0).toUpperCase().replaceAll("[+ ]", "");
        if (string2.startsWith("CH") || string2.startsWith("DB") || string2.startsWith("EC") || string2.startsWith("ES") || string2.startsWith("SQ")) {
            string = string2.substring(0, 2);
            string2 = string2.substring(2);
        } else {
            string = "CH";
        }
        int n2 = this.getTokenUnsignedIntegerValue(string2);
        this.messages.add(String.format("%s%5d", string, n2));
    }

    @Override
    protected boolean merge(BaseDirective.Phase phase, BaseDirective baseDirective) {
        HIDEMESSAGE hIDEMESSAGE = (HIDEMESSAGE)baseDirective;
        if (hIDEMESSAGE.isNo()) {
            if (hIDEMESSAGE.getMessages().size() == 0) {
                this.messages.clear();
            } else {
                this.messages.remove(hIDEMESSAGE.getMessages().get(0));
            }
        } else {
            this.messages.add(hIDEMESSAGE.getMessages().get(0));
        }
        return true;
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return true;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Any;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("NOHIDE-MESSAGE");
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public HIDEMESSAGE(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 134;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

