/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Codepage;
import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.NativeCodepage;
import com.veryant.cobol.exceptions.InvalidDirectiveException;

public final class SOURCEENCODING
extends BaseDirective {
    public static final String NAME = "SOURCEENCODING";
    private Codepage codepage;

    @Override
    public void setValues() throws InvalidDirectiveException {
        this.checkParameterCount(1);
        SourceEncodings sourceEncodings = this.getEnumValue(0, true, SourceEncodings.class);
        String string = this.getTokenValue(0);
        String string2 = string.replace("-", "").toUpperCase();
        try {
            switch (sourceEncodings) {
                case ANSI: {
                    this.codepage = new Codepage(NativeCodepage.GetACP());
                    break;
                }
                case OEM: {
                    this.codepage = new Codepage(NativeCodepage.GetOEMCP());
                    break;
                }
                case UTF8: {
                    this.codepage = new Codepage(1208);
                    break;
                }
                case UTF16: 
                case UTF16P: {
                    this.codepage = new Codepage(1200);
                }
            }
        }
        catch (Exception exception) {
            throw Directives.invalidDirectiveException("Directive %s: %s", NAME, exception.getMessage());
        }
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.No;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("SOURCE-ENCODING\"ANSI\"");
    }

    public Codepage getCodepage() {
        return this.codepage;
    }

    public SOURCEENCODING(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 286;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static enum SourceEncodings {
        ANSI,
        OEM,
        UTF8,
        UTF16,
        UTF16P;

    }
}

