/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters;

import com.veryant.cobol.compiler.emitters.Payload;
import com.veryant.cobol.compiler.emitters.TargetCodeSnippet;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.util.ArrayList;

public class TargetCode<T extends TargetCodeSnippet>
extends Payload {
    private final StringBuilder codeBuffer = new StringBuilder();
    private final ArrayList<T> evaluationStack = new ArrayList(50);

    public void push(T t2, boolean bl) {
        if (bl) {
            this.evaluationStack.add(t2);
        } else {
            this.codeBuffer.append(t2);
        }
    }

    public T pop() {
        int n2 = this.evaluationStack.size();
        if (n2 == 0) {
            throw new COBOLCompilerException("Internal error, evaluation stack negative");
        }
        return (T)((TargetCodeSnippet)this.evaluationStack.remove(n2 - 1));
    }

    public T peek() {
        return this.peek(0);
    }

    public T peek(int n2) {
        int n3 = this.evaluationStack.size() + n2 - 1;
        if (n3 < 0) {
            throw new COBOLCompilerException("Internal error, evaluation stack negative");
        }
        return (T)((TargetCodeSnippet)this.evaluationStack.get(n3));
    }

    public int size() {
        return this.codeBuffer.length();
    }

    public int evaluationStackSize() {
        return this.evaluationStack.size();
    }

    public String toString() {
        return this.codeBuffer.toString();
    }
}

