/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.builtin;

import com.veryant.cobol.compiler.Operators;
import com.veryant.cobol.compiler.StringFormat;
import com.veryant.cobol.compiler.emitters.jvm.BuiltInEmitter;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Functions;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.core.Errors;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.ConditionNameReference;

public abstract class IntermediateCondition {
    static final BuiltInEmitter LOAD = (jvmCode, abstractOperand) -> {
        if (abstractOperand instanceof ConditionNameReference) {
            ConditionNameReference conditionNameReference = (ConditionNameReference)abstractOperand;
            int n2 = conditionNameReference.getSubscriptsCount();
            if (n2 > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(conditionNameReference.getNamedConditionDeclaration().getInternalName() + '(');
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuilder.append("{?}");
                    Opcodes.LOAD(jvmCode, conditionNameReference.getSubscript(i2));
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.SCALE(jvmCode, 0);
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.CAST(jvmCode, VMType.INT32);
                    com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.DEC(jvmCode);
                    stringBuilder.append(i2 + 1 == n2 ? ")" : ",");
                }
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.INJECT(jvmCode, VMType.BOOLEAN, new StringFormat(stringBuilder.toString()));
            } else {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.INJECT(jvmCode, VMType.BOOLEAN, conditionNameReference.getNamedConditionDeclaration().getInternalName() + "()");
            }
            return;
        }
        com.veryant.cobol.compiler.types.IntermediateCondition intermediateCondition = (com.veryant.cobol.compiler.types.IntermediateCondition)abstractOperand;
        Operators operators = intermediateCondition.getOperator();
        AbstractOperand[] abstractOperandArray = intermediateCondition.getOperands();
        if (intermediateCondition.getComparisonMode() == 1) {
            boolean bl = true;
            for (AbstractOperand abstractOperand2 : abstractOperandArray) {
                if (abstractOperand2.getStaticSize() == 1) continue;
                bl = false;
                break;
            }
            if (bl) {
                for (AbstractOperand abstractOperand2 : abstractOperandArray) {
                    Functions.f_load_single_byte(jvmCode, abstractOperand2);
                }
            } else {
                for (AbstractOperand abstractOperand2 : abstractOperandArray) {
                    Opcodes.LOAD_ADDR(jvmCode, abstractOperand2);
                }
            }
        } else {
            for (AbstractOperand abstractOperand3 : abstractOperandArray) {
                Opcodes.LOAD(jvmCode, abstractOperand3);
            }
        }
        switch (operators) {
            case EQ: {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.EQ(jvmCode);
                break;
            }
            case NE: {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.NE(jvmCode);
                break;
            }
            case LE: {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LE(jvmCode);
                break;
            }
            case LT: {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LT(jvmCode);
                break;
            }
            case GE: {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.GE(jvmCode);
                break;
            }
            case GT: {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.GT(jvmCode);
                break;
            }
            case AND: {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.AND(jvmCode);
                break;
            }
            case OR: {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.OR(jvmCode);
                break;
            }
            case NOT: {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.NOT(jvmCode);
                break;
            }
            default: {
                throw Errors.e_unsupported_feature(intermediateCondition);
            }
        }
    };
}

