/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.core;

import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.JvmCodeSnippet;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Errors;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.core.Templates;
import com.veryant.cobol.compiler.memory.Region;
import com.veryant.cobol.compiler.types.AbstractOperand;

public abstract class Functions {
    public static void f_wrap_as_address(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, VMType.ADDRESS, Templates.T_ADDRESS);
    }

    public static String f_resolve_type_name(JvmCodeSnippet jvmCodeSnippet) {
        return Functions.f_resolve_type_name((VMType)jvmCodeSnippet.getVmType());
    }

    public static String f_resolve_type_name(VMType vMType) {
        return vMType.getCanonicalName();
    }

    public static VMType f_normalize_boxed_types(VMType vMType) {
        if (vMType.isBoxed()) {
            return vMType.unbox();
        }
        return vMType;
    }

    public static String f_resolve_region_name(Region region) {
        if (region == Region.LOCAL_STORAGE) {
            return "$CLD$." + region.getInternalName();
        }
        return region.getInternalName();
    }

    public static String f_resolve_region_name(AbstractOperand abstractOperand) {
        Region region = abstractOperand.getChunk().getRegion();
        if (region == Region.STACK) {
            return Functions.f_resolve_region_name(region) + Utils.intToHex(abstractOperand.hashCode());
        }
        return Functions.f_resolve_region_name(region);
    }

    public static int f_number_of_digits(long l2) {
        if (l2 == 0L) {
            return 1;
        }
        return (int)Math.log10(Math.abs(l2)) + 1;
    }

    protected static void f_type_checking(JvmCode jvmCode, VMType ... vMTypeArray) {
        int n2 = -vMTypeArray.length;
        for (VMType vMType : vMTypeArray) {
            if (((JvmCodeSnippet)jvmCode.peek(++n2)).getVmType() == vMType) continue;
            throw Errors.e_type_clash((JvmCodeSnippet)jvmCode.peek(n2), vMType);
        }
    }

    public static boolean f_type_peeking(JvmCode jvmCode, VMType ... vMTypeArray) {
        int n2 = -vMTypeArray.length;
        for (VMType vMType : vMTypeArray) {
            if (((JvmCodeSnippet)jvmCode.peek(++n2)).getVmType() == vMType) continue;
            return false;
        }
        return true;
    }

    public static void f_is_numeric_check(JvmCode jvmCode, int n2) {
        for (int i2 = 1 - n2; i2 < 0; ++i2) {
            if (((JvmCodeSnippet)jvmCode.peek(i2)).getMagnitude() != null) continue;
            throw Errors.e_should_be_numeric(jvmCode.peek(i2));
        }
    }

    public static boolean f_is_numeric_peek(JvmCode jvmCode, int n2) {
        for (int i2 = 1 - n2; i2 < 0; ++i2) {
            if (((JvmCodeSnippet)jvmCode.peek(i2)).getMagnitude() != null) continue;
            return false;
        }
        return true;
    }
}

