/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.StringFormat;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.Local;
import com.veryant.cobol.compiler.emitters.jvm.LocalReference;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Errors;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.statements.Mapper;
import com.veryant.cobol.compiler.stmts.CodeBlock;
import com.veryant.cobol.compiler.types.AbstractOperand;

public abstract class BaseEmitter {
    private static final StringFormat T_MEMORY_COPY = new StringFormat("IMemory.copy({?},{?},{?},{?},{?});");
    private static final StringFormat T_ALPHA_QUICK_EQ = new StringFormat("Alpha.quickCompare({?},{?},{?},{?},{?})==0");
    private static final StringFormat T_SIZE_ERR = new StringFormat("CobolBigDecimal.sizeError({?})");
    private static final StringFormat T_INT128_SIZE_ERR = new StringFormat("{?}.sizeError({?})");

    protected static void emitBlock(JvmCode jvmCode, CodeBlock codeBlock) {
        BaseEmitter.emitBlock(jvmCode, codeBlock, true);
    }

    protected static void emitBlock(JvmCode jvmCode, CodeBlock codeBlock, boolean bl) {
        if (bl) {
            Opcodes.INJECT(jvmCode, "{");
        }
        for (IStatement iStatement : codeBlock) {
            BaseEmitter.emitStatement(jvmCode, iStatement);
        }
        if (bl) {
            Opcodes.INJECT(jvmCode, "}");
        }
    }

    protected static void emitStatement(JvmCode jvmCode, IStatement iStatement) {
        Mapper.emit(jvmCode, iStatement);
    }

    protected static void emitStoreWithSizeError(JvmCode jvmCode, AbstractOperand abstractOperand, Local local) {
        Local local2 = Opcodes.STORE_LOCAL(jvmCode);
        if (IOperand.isInteger(abstractOperand) || IOperand.isFixedPoint(abstractOperand)) {
            if (local2.getVmType() == VMType.INT128) {
                Opcodes.LOAD_LOCAL(jvmCode, local2);
                Opcodes.LOAD_CONST(jvmCode, abstractOperand.getMagnitude().getIntDigits());
                Opcodes.INJECT(jvmCode, VMType.BOOLEAN, T_INT128_SIZE_ERR);
                Opcodes.IF(jvmCode);
                Opcodes.LOAD_CONST(jvmCode, true);
                Opcodes.STORE_LOCAL(jvmCode, local);
                Opcodes.ELSE(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, local2);
                com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, abstractOperand);
                Opcodes.FI(jvmCode);
            } else {
                Opcodes.LOAD_LOCAL(jvmCode, local2);
                Local local3 = Opcodes.DUP_LOCAL(jvmCode, local2);
                Opcodes.LOAD_CONST(jvmCode, 0);
                Opcodes.LT(jvmCode);
                Opcodes.IF(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, local3);
                Opcodes.NEG(jvmCode);
                Opcodes.STORE_LOCAL(jvmCode, local3);
                Opcodes.FI(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, local3);
                Opcodes.LOAD_SCALER(jvmCode, abstractOperand.getMagnitude().getDigits(), abstractOperand.getMagnitude().getScale());
                Opcodes.GE(jvmCode);
                Opcodes.IF(jvmCode);
                Opcodes.LOAD_CONST(jvmCode, true);
                Opcodes.STORE_LOCAL(jvmCode, local);
                Opcodes.ELSE(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, local2);
                com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, abstractOperand);
                Opcodes.FI(jvmCode);
            }
        } else if (IOperand.isFloatingPoint(abstractOperand)) {
            Opcodes.LOAD_LOCAL(jvmCode, local2);
            Opcodes.INJECT(jvmCode, VMType.BOOLEAN, T_SIZE_ERR);
            Opcodes.IF(jvmCode);
            Opcodes.LOAD_CONST(jvmCode, true);
            Opcodes.STORE_LOCAL(jvmCode, local);
            Opcodes.ELSE(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, local2);
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, abstractOperand);
            Opcodes.FI(jvmCode);
        } else {
            throw Errors.e_unsupported_feature(abstractOperand);
        }
    }

    protected static void emitSizeErrorBranches(JvmCode jvmCode, Local local, CodeBlock codeBlock, CodeBlock codeBlock2) {
        Opcodes.LOAD_LOCAL(jvmCode, local);
        if (codeBlock == null) {
            Opcodes.NOT(jvmCode);
            Opcodes.IF(jvmCode);
            BaseEmitter.emitBlock(jvmCode, codeBlock2);
            Opcodes.FI(jvmCode);
        } else if (codeBlock2 == null) {
            Opcodes.IF(jvmCode);
            BaseEmitter.emitBlock(jvmCode, codeBlock);
            Opcodes.FI(jvmCode);
        } else {
            Opcodes.IF(jvmCode);
            BaseEmitter.emitBlock(jvmCode, codeBlock);
            Opcodes.ELSE(jvmCode);
            BaseEmitter.emitBlock(jvmCode, codeBlock2);
            Opcodes.FI(jvmCode);
        }
    }

    protected static LocalReference emitStoreToLocalReference(JvmCode jvmCode, AbstractOperand abstractOperand) {
        if (abstractOperand != null) {
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD_ADDR(jvmCode, abstractOperand, true);
            return new LocalReference(abstractOperand, Opcodes.STORE_LOCAL(jvmCode), Opcodes.STORE_LOCAL(jvmCode), Opcodes.STORE_LOCAL(jvmCode));
        }
        return null;
    }

    protected static void emitMemoryCopy(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, T_MEMORY_COPY);
    }

    protected static void emitFormattedThrow(JvmCode jvmCode, String string, Object ... objectArray) {
        Opcodes.THROW(jvmCode, String.format(string, objectArray));
    }

    protected static void emitQuickCompareAlpha(JvmCode jvmCode) {
        Opcodes.INJECT(jvmCode, VMType.BOOLEAN, T_ALPHA_QUICK_EQ);
    }

    protected static void emitCompareAlpha(JvmCode jvmCode, LocalReference localReference, Local local, LocalReference localReference2) {
        int n2 = localReference2.operand.getStaticSize();
        if (n2 == 1) {
            Opcodes.LOAD_LOCAL(jvmCode, localReference.offset);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.ADD(jvmCode);
            Opcodes.GET_MEMORY(jvmCode, localReference.memory);
            Opcodes.LOAD_LOCAL(jvmCode, localReference2.offset);
            Opcodes.GET_MEMORY(jvmCode, localReference2.memory);
            Opcodes.EQ(jvmCode);
        } else {
            int n3 = localReference.operand.getStaticSize();
            if (n3 != 0 && n2 != 0) {
                Opcodes.LOAD_LOCAL(jvmCode, local);
                Opcodes.LOAD_CONST(jvmCode, n3 - n2 + 2);
            } else {
                Opcodes.LOAD_LOCAL(jvmCode, local);
                Opcodes.LOAD_LOCAL(jvmCode, localReference2.length);
                Opcodes.ADD(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, localReference.length);
            }
            Opcodes.LT(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, localReference.memory);
            Opcodes.LOAD_LOCAL(jvmCode, localReference.offset);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.ADD(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, localReference2.memory);
            Opcodes.LOAD_LOCAL(jvmCode, localReference2.offset);
            if (n2 != 0) {
                Opcodes.LOAD_CONST(jvmCode, n2);
            } else {
                Opcodes.LOAD_LOCAL(jvmCode, localReference2.length);
            }
            BaseEmitter.emitQuickCompareAlpha(jvmCode);
            Opcodes.AND(jvmCode);
        }
    }
}

