/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.ErrorProcedures;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.Section;
import com.veryant.cobol.compiler.StringFormat;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.JvmCodeSnippet;
import com.veryant.cobol.compiler.emitters.jvm.Local;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.core.Templates;
import com.veryant.cobol.compiler.emitters.jvm.core.VMTypeEx;
import com.veryant.cobol.compiler.emitters.jvm.statements.BaseEmitter;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.IChunk;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.stmts.CodeBlock;
import com.veryant.cobol.compiler.stmts.data.FileBaseData;

public abstract class BaseFileIOEmitter
extends BaseEmitter {
    private static final StringFormat T_STORE_COMP_X = new StringFormat("CompX.store({?},{?},{?},{?});");
    private static final StringFormat T_LOAD_COMP_X_UINT = new StringFormat("CompX.loadUInt({?},{?},{?})");
    private static final StringFormat T_LOAD_COMP_X_ULONG = new StringFormat("CompX.loadULong({?},{?},{?})");
    private static final StringFormat T_FILE_HANDLING_EXCEPTION = new StringFormat("throw new COBOLFileHandlingException({?},{?},{?},{?});");
    private static final StringFormat ERR = new StringFormat("$IO_MODE_ERR$({?})");

    private static void pushRegionName(JvmCode jvmCode, IChunk iChunk) {
        jvmCode.push(VMTypeEx.IMEMORY, iChunk.getRegion().getInternalName());
    }

    protected static void emitFullCallToHandler(JvmCode jvmCode, FileBaseData fileBaseData) {
        Local local = BaseFileIOEmitter.emitCallToHandler(jvmCode, fileBaseData);
        BaseFileIOEmitter.emitErrorHandling(jvmCode, fileBaseData, local);
    }

    protected static Local emitCallToHandler(JvmCode jvmCode, FileBaseData fileBaseData) {
        FileDeclaration fileDeclaration = fileBaseData.getFile();
        DataItem dataItem = fileDeclaration.getFcdDataItem();
        Opcodes.INJECT(jvmCode, fileDeclaration.getMethodName("file") + "(" + fileBaseData.getStandardOpcode() + ");");
        BaseFileIOEmitter.emitSimpleLoadUByte(jvmCode, dataItem.getChunk(), 0);
        return Opcodes.STORE_LOCAL(jvmCode);
    }

    protected static void emitErrorHandling(JvmCode jvmCode, FileBaseData fileBaseData, Local local) {
        boolean bl;
        FileDeclaration fileDeclaration = fileBaseData.getFile();
        DataItem dataItem = fileDeclaration.getFcdDataItem();
        Section section = fileDeclaration.getDeclarativeSection();
        ErrorProcedures errorProcedures = jvmCode.getErrorProcedures();
        boolean bl2 = section != null;
        boolean bl3 = fileDeclaration.getFileStatuses().length > 0;
        boolean bl4 = fileBaseData.getSuccessBody() != null;
        boolean bl5 = bl = fileBaseData.getFailBody() != null;
        if (!bl2 && errorProcedures.isEmpty() && bl3 && !bl4 && !bl) {
            return;
        }
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.LOAD_CONST(jvmCode, 48);
        Opcodes.EQ(jvmCode);
        Opcodes.IF(jvmCode);
        if (bl4) {
            BaseFileIOEmitter.emitBlock(jvmCode, fileBaseData.getSuccessBody());
        }
        FileBaseData.ExpectedFailure expectedFailure = fileBaseData.getExpectedFailure();
        switch (expectedFailure) {
            case AtEnd: 
            case InvalidKey: {
                CodeBlock codeBlock = fileBaseData.getFailBody();
                if (codeBlock == null) break;
                Opcodes.LOAD_LOCAL(jvmCode, local);
                Opcodes.LOAD_CONST(jvmCode, expectedFailure == FileBaseData.ExpectedFailure.AtEnd ? 49 : 50);
                Opcodes.EQ(jvmCode);
                Opcodes.ELIF(jvmCode);
                BaseFileIOEmitter.emitBlock(jvmCode, codeBlock);
            }
        }
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.LOAD_CONST(jvmCode, bl2 ? 48 : 50);
        Opcodes.GT(jvmCode);
        Opcodes.ELIF(jvmCode);
        if (bl2) {
            Opcodes.JMP_RET_PROC(jvmCode, section.getStart(), section.getEnd());
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Invoke DECLARATIVE method");
        } else if (!errorProcedures.isEmpty()) {
            BaseFileIOEmitter.emitSimpleLoadUByte(jvmCode, dataItem.getChunk(), 7);
            Opcodes.INJECT(jvmCode, VMType.BOOLEAN, ERR);
            Opcodes.NOT(jvmCode);
            Opcodes.IF(jvmCode);
            if (!bl3) {
                BaseFileIOEmitter.emitSimpleLoadUByte(jvmCode, dataItem.getChunk(), 0);
                BaseFileIOEmitter.emitSimpleLoadUByte(jvmCode, dataItem.getChunk(), 1);
                Opcodes.LOAD_CONST(jvmCode, fileDeclaration.getName());
                com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, fileDeclaration.getFileName());
                BaseFileIOEmitter.emitFHThrow(jvmCode);
            }
            Opcodes.FI(jvmCode);
        } else if (!bl3) {
            BaseFileIOEmitter.emitSimpleLoadUByte(jvmCode, dataItem.getChunk(), 0);
            BaseFileIOEmitter.emitSimpleLoadUByte(jvmCode, dataItem.getChunk(), 1);
            Opcodes.LOAD_CONST(jvmCode, fileDeclaration.getName());
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, fileDeclaration.getFileName());
            BaseFileIOEmitter.emitFHThrow(jvmCode);
        }
        Opcodes.FI(jvmCode);
    }

    protected static void emitSimpleStoreCompX(JvmCode jvmCode, IChunk iChunk, int n2, int n3) {
        BaseFileIOEmitter.pushRegionName(jvmCode, iChunk);
        Opcodes.LOAD_CONST(jvmCode, iChunk.getOffset() + n2);
        Opcodes.LOAD_CONST(jvmCode, n3);
        Opcodes.INJECT(jvmCode, VMType.VOID, T_STORE_COMP_X);
    }

    protected static void emitSimpleLoadCompX(JvmCode jvmCode, IChunk iChunk, int n2, int n3) {
        BaseFileIOEmitter.pushRegionName(jvmCode, iChunk);
        Opcodes.LOAD_CONST(jvmCode, iChunk.getOffset() + n2);
        Opcodes.LOAD_CONST(jvmCode, n3);
        if (n3 <= 4) {
            Opcodes.INJECT(jvmCode, VMType.INT32, T_LOAD_COMP_X_UINT, new Magnitude(false, 10));
        } else {
            Opcodes.INJECT(jvmCode, VMType.INT64, T_LOAD_COMP_X_ULONG, new Magnitude(false, 19));
        }
    }

    protected static void emitSimpleLoadUByte(JvmCode jvmCode, IChunk iChunk, int n2) {
        BaseFileIOEmitter.pushRegionName(jvmCode, iChunk);
        Opcodes.LOAD_CONST(jvmCode, iChunk.getOffset() + n2);
        Opcodes.INJECT(jvmCode, VMType.INT32, Templates.T_MEM_GET_UNSIGNED_BYTE);
    }

    protected static void emitSimpleLoadByte(JvmCode jvmCode, IChunk iChunk, int n2) {
        BaseFileIOEmitter.pushRegionName(jvmCode, iChunk);
        Opcodes.LOAD_CONST(jvmCode, iChunk.getOffset() + n2);
        Opcodes.INJECT(jvmCode, VMType.INT32, Templates.T_MEM_GET_SIGNED_BYTE);
    }

    protected static void emitSimpleStoreByte(JvmCode jvmCode, IChunk iChunk, int n2) {
        JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
        BaseFileIOEmitter.pushRegionName(jvmCode, iChunk);
        Opcodes.LOAD_CONST(jvmCode, iChunk.getOffset() + n2);
        jvmCode.push(jvmCodeSnippet);
        Opcodes.INJECT(jvmCode, VMType.VOID, Templates.T_MEM_PUT_BYTE);
    }

    protected static void emitFHThrow(JvmCode jvmCode) {
        JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
        String string = jvmCodeSnippet.getCode();
        JvmCodeSnippet jvmCodeSnippet2 = (JvmCodeSnippet)jvmCode.pop();
        JvmCodeSnippet jvmCodeSnippet3 = (JvmCodeSnippet)jvmCode.pop();
        JvmCodeSnippet jvmCodeSnippet4 = (JvmCodeSnippet)jvmCode.pop();
        Opcodes.INJECT(jvmCode, T_FILE_HANDLING_EXCEPTION.format(jvmCodeSnippet4, jvmCodeSnippet3, jvmCodeSnippet2.getCode(), jvmCodeSnippet.getCode()));
    }
}

