/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.StringFormat;
import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.core.VMTypeEx;
import com.veryant.cobol.compiler.emitters.jvm.statements.BaseEmitter;
import com.veryant.cobol.compiler.stmts.Display;
import com.veryant.cobol.compiler.types.AbstractLiteral;
import com.veryant.cobol.compiler.types.AbstractOperand;
import com.veryant.cobol.compiler.types.DataItemReference;

public abstract class ConsoleWriteEmitter
extends BaseEmitter {
    private static final String NEW_LINE = "Console.newLine();";
    private static final StringFormat WRITE_TEMPLATE = new StringFormat("Console.write({?});");
    private static final StringFormat NF_TEMPLATE = new StringFormat("NumberFormatter.format({?},{?},{?},{?})");

    public static void emit(JvmCode jvmCode, IStatement iStatement) {
        Display display = (Display)iStatement;
        for (AbstractOperand abstractOperand : display.getArgs()) {
            if (abstractOperand instanceof AbstractLiteral) {
                ConsoleWriteEmitter.pushLiteral(jvmCode, (AbstractLiteral)abstractOperand);
            } else {
                boolean bl = false;
                if (abstractOperand instanceof DataItemReference) {
                    boolean bl2 = bl = ((DataItemReference)abstractOperand).getDataItemDeclaration().getMask() != null;
                }
                if (abstractOperand.getMagnitude() != null && !bl) {
                    ConsoleWriteEmitter.loadAndFormat(jvmCode, abstractOperand);
                } else {
                    com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD_ADDR(jvmCode, abstractOperand);
                }
                Opcodes.CAST(jvmCode, VMType.STRING);
            }
            Opcodes.INJECT(jvmCode, WRITE_TEMPLATE);
        }
        if (!display.isDisplayFollows()) {
            Opcodes.INJECT(jvmCode, NEW_LINE);
        }
    }

    private static void pushLiteral(JvmCode jvmCode, AbstractLiteral abstractLiteral) {
        jvmCode.push(abstractLiteral, VMType.STRING, Utils.quoteString(abstractLiteral.toString()));
    }

    private static void loadAndFormat(JvmCode jvmCode, AbstractOperand abstractOperand) {
        Magnitude magnitude = abstractOperand.getMagnitude();
        int n2 = 0;
        int n3 = magnitude.getDigits();
        switch (abstractOperand.getBuiltIn().getUsage()) {
            case BINARY_CHAR_SIGNED: 
            case BINARY_CHAR_UNSIGNED: 
            case BINARY_SHORT_SIGNED: 
            case BINARY_SHORT_UNSIGNED: 
            case BINARY_LONG_SIGNED: 
            case BINARY_LONG_UNSIGNED: 
            case BINARY_DOUBLE_SIGNED: 
            case BINARY_DOUBLE_UNSIGNED: 
            case COMP_4: 
            case COMP_5: 
            case COMP_X: 
            case INDEX: 
            case POINTER: 
            case POINTER_32: {
                n3 = BuiltIn.getDigitsBySize(BuiltIn.getSizeByDigits(n3));
            }
        }
        int n4 = magnitude.getScale();
        switch (abstractOperand.getBuiltIn()) {
            case UNSIGNED: 
            case COMP_2_UNSIGNED_DECIMAL: 
            case COMP_3_UNSIGNED: 
            case COMP_3_UNSIGNED_VAX: 
            case COMP_4_UNSIGNED: 
            case COMP_4_UNSIGNED_SIGN_DROP: 
            case COMP_5_UNSIGNED: 
            case COMP_X_UNSIGNED: 
            case COMP_5_UNSIGNED_SIGN_DROP: 
            case COMP_6: {
                break;
            }
            case UNSIGNED_EBCDIC: {
                n2 |= 0x8000;
                break;
            }
            case TRAILING_EBCDIC: 
            case TRAILING_EBCDIC_SIGN_ASCII: 
            case TRAILING_SEP_EBCDIC: {
                n2 |= 0x8000;
            }
            case TRAILING: 
            case TRAILING_SIGN_EBCDIC: 
            case TRAILING_ACU: 
            case TRAILING_SEP: {
                n2 |= 1;
                ++n3;
                break;
            }
            case LEADING_EBCDIC: 
            case LEADING_EBCDIC_SIGN_ASCII: 
            case LEADING_SEP_EBCDIC: {
                n2 |= 0x8000;
            }
            case TRAILING_MBP: {
                break;
            }
            default: {
                n2 |= 2;
                ++n3;
            }
        }
        com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, abstractOperand);
        Opcodes.LOAD_CONST(jvmCode, n3);
        Opcodes.LOAD_CONST(jvmCode, n4);
        Opcodes.LOAD_CONST(jvmCode, n2);
        Opcodes.INJECT(jvmCode, VMTypeEx.BYTE_ARRAY, NF_TEMPLATE);
    }
}

