/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.Local;
import com.veryant.cobol.compiler.emitters.jvm.LocalReference;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.statements.BaseEmitter;
import com.veryant.cobol.compiler.stmts.Inspect;
import com.veryant.cobol.compiler.types.AbstractOperand;

public abstract class InspectEmitter
extends BaseEmitter {
    public static void emit(JvmCode jvmCode, IStatement iStatement) {
        InspectData inspectData = new InspectData(jvmCode, (Inspect)iStatement);
        if (inspectData.tallyingItems != null) {
            InspectEmitter.emitFindIndexes(jvmCode, inspectData, inspectData.tallyingItems);
            InspectEmitter.emitTallyingReplacingLogic(jvmCode, inspectData, inspectData.tallyingItems);
        }
        if (inspectData.replacingItems != null) {
            InspectEmitter.emitFindIndexes(jvmCode, inspectData, inspectData.replacingItems);
            InspectEmitter.emitTallyingReplacingLogic(jvmCode, inspectData, inspectData.replacingItems);
        }
        if (inspectData.convertingItem != null) {
            InspectEmitter.emitFindIndexes(jvmCode, inspectData, new ConvertingItem[]{inspectData.convertingItem});
            InspectEmitter.emitConvertingLogic(jvmCode, inspectData);
        }
    }

    private static void emitFindIndexes(JvmCode jvmCode, InspectData inspectData, InspectItem[] inspectItemArray) {
        Opcodes.INJECT_COMMENT(jvmCode, "Computing indexes");
        Opcodes.LOAD_CONST(jvmCode, Integer.MAX_VALUE);
        Opcodes.STORE_LOCAL(jvmCode, inspectData.minAfter);
        Opcodes.LOAD_CONST(jvmCode, Integer.MIN_VALUE);
        Opcodes.STORE_LOCAL(jvmCode, inspectData.maxBefore);
        for (InspectItem inspectItem : inspectItemArray) {
            InspectItemClause inspectItemClause = inspectItem.clause;
            while (inspectItemClause != null) {
                if (inspectItemClause.after != null) {
                    InspectEmitter.emitFindAfterIndex(jvmCode, inspectData, inspectItemClause.after, inspectItemClause.internalAfterIndex);
                } else {
                    Opcodes.LOAD_CONST(jvmCode, 0);
                    Opcodes.STORE_LOCAL(jvmCode, inspectData.minAfter);
                }
                if (inspectItemClause.before != null) {
                    InspectEmitter.emitFindBeforeIndex(jvmCode, inspectData, inspectItemClause.before, inspectItemClause.internalBeforeIndex, inspectItemClause.internalAfterIndex);
                } else {
                    Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.length);
                    Opcodes.STORE_LOCAL(jvmCode, inspectData.maxBefore);
                }
                inspectItemClause = inspectItemClause.nextClause;
            }
        }
    }

    private static void emitFindAfterIndex(JvmCode jvmCode, InspectData inspectData, LocalReference localReference, Local local) {
        InspectEmitter.emitFindBeforeOrAfterIndex(jvmCode, inspectData, localReference, local, null, true);
    }

    private static void emitFindBeforeIndex(JvmCode jvmCode, InspectData inspectData, LocalReference localReference, Local local, Local local2) {
        InspectEmitter.emitFindBeforeOrAfterIndex(jvmCode, inspectData, localReference, local, local2, false);
    }

    private static void emitFindBeforeOrAfterIndex(JvmCode jvmCode, InspectData inspectData, LocalReference localReference, Local local, Local local2, boolean bl) {
        Local local3;
        if (local2 != null) {
            Opcodes.LOAD_LOCAL(jvmCode, local2);
        } else {
            Opcodes.LOAD_CONST(jvmCode, 0);
        }
        Opcodes.STORE_LOCAL(jvmCode, local);
        Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.length);
        Opcodes.LOAD_LOCAL(jvmCode, localReference.length);
        Opcodes.SUB(jvmCode);
        Local local4 = Opcodes.STORE_LOCAL(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.LOAD_LOCAL(jvmCode, local4);
        Opcodes.LE(jvmCode);
        Opcodes.DO_WHILE(jvmCode);
        InspectEmitter.emitCompareAlpha(jvmCode, inspectData.source, local, localReference);
        Opcodes.IF(jvmCode);
        if (bl) {
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.LOAD_LOCAL(jvmCode, localReference.length);
            Opcodes.ADD(jvmCode);
            Opcodes.DEC(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, local);
        }
        Opcodes.BREAK(jvmCode);
        Opcodes.FI(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.INC(jvmCode);
        Opcodes.STORE_LOCAL(jvmCode, local);
        Opcodes.DONE(jvmCode);
        if (bl) {
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.INC(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, local);
        }
        Opcodes.LOAD_LOCAL(jvmCode, local);
        if (bl) {
            local3 = inspectData.minAfter;
            Opcodes.LOAD_LOCAL(jvmCode, local3);
            Opcodes.LT(jvmCode);
        } else {
            local3 = inspectData.maxBefore;
            Opcodes.LOAD_LOCAL(jvmCode, local3);
            Opcodes.GT(jvmCode);
        }
        Opcodes.IF(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.STORE_LOCAL(jvmCode, local3);
        Opcodes.FI(jvmCode);
    }

    private static void emitTallyingReplacingLogic(JvmCode jvmCode, InspectData inspectData, InspectItem[] inspectItemArray) {
        InspectItemClause inspectItemClause;
        Object object;
        Object object2;
        Opcodes.INJECT_COMMENT(jvmCode, "Actual tallying/replacing logic");
        int n2 = inspectData.countClauses(inspectItemArray);
        if (n2 == 1) {
            object2 = inspectItemArray[0];
            object = object2.clause;
            switch (object.kind) {
                case Characters: {
                    if (!(inspectItemArray instanceof TallyingItem[])) break;
                    InspectEmitter.emitIsolatedTallyingForCharacters(jvmCode, inspectData, (TallyingItem)object2, (InspectItemClause)object);
                    return;
                }
                case All: {
                    break;
                }
                case Leading: {
                    break;
                }
                case Trailing: {
                    InspectEmitter.emitIsolatedInspectTrailing(jvmCode, inspectData, (InspectItem)object2, (InspectItemClause)object);
                    return;
                }
            }
        }
        object2 = new Local[n2];
        object = new Local[n2];
        int[] nArray = new int[n2];
        int n3 = 0;
        for (InspectItem inspectItem : inspectItemArray) {
            InspectItemClause inspectItemClause2 = inspectItem.clause;
            while (inspectItemClause2 != null) {
                if (inspectItem instanceof TallyingItem) {
                    Opcodes.LOAD_CONST(jvmCode, 0);
                    object2[n3] = Opcodes.STORE_LOCAL(jvmCode);
                }
                switch (inspectItemClause2.kind) {
                    case Leading: 
                    case First: {
                        Opcodes.LOAD_CONST(jvmCode, 0);
                        object[n3] = Opcodes.STORE_LOCAL(jvmCode);
                    }
                }
                nArray[n3] = inspectItemClause2.operand != null ? inspectItemClause2.operand.operand.getStaticSize() : 1;
                if (inspectItem instanceof ReplacingItem && (inspectItemClause2.by.operand.getStaticSize() == 0 || inspectItemClause2.by.operand.getStaticSize() == 0)) {
                    if (inspectItemClause2.operand != null) {
                        Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause2.operand.length);
                    } else {
                        Opcodes.LOAD_CONST(jvmCode, 1);
                    }
                    Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause2.by.length);
                    Opcodes.NE(jvmCode);
                    Opcodes.IF(jvmCode);
                    InspectEmitter.emitFormattedThrow(jvmCode, "Inspect replacing size mismatch", new Object[0]);
                    Opcodes.FI(jvmCode);
                }
                ++n3;
                inspectItemClause2 = inspectItemClause2.nextClause;
            }
        }
        Opcodes.LOAD_LOCAL(jvmCode, inspectData.minAfter);
        Local local = Opcodes.STORE_LOCAL(jvmCode);
        n3 = 0;
        int n4 = 0;
        int n5 = 1;
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.LOAD_LOCAL(jvmCode, inspectData.maxBefore);
        Opcodes.LT(jvmCode);
        Opcodes.DO_WHILE(jvmCode);
        for (InspectItem inspectItem : inspectItemArray) {
            inspectItemClause = inspectItem.clause;
            while (inspectItemClause != null) {
                if (n2 > 1) {
                    if (inspectItemClause.after != null) {
                        Opcodes.LOAD_LOCAL(jvmCode, local);
                        Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.internalAfterIndex);
                        Opcodes.GE(jvmCode);
                    }
                    if (inspectItemClause.before != null) {
                        Opcodes.LOAD_LOCAL(jvmCode, local);
                        Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.internalBeforeIndex);
                        Opcodes.LT(jvmCode);
                        if (inspectItemClause.after != null) {
                            Opcodes.AND(jvmCode);
                        }
                    }
                }
                if (inspectItemClause.kind == InspectItemClauseKind.Characters) {
                    Opcodes.LOAD_CONST(jvmCode, true);
                } else {
                    switch (inspectItemClause.kind) {
                        case All: {
                            InspectEmitter.emitCompareAlpha(jvmCode, inspectData.source, local, inspectItemClause.operand);
                            break;
                        }
                        case Leading: {
                            Opcodes.LOAD_LOCAL(jvmCode, object[n3]);
                            Opcodes.LOAD_LOCAL(jvmCode, local);
                            Opcodes.EQ(jvmCode);
                            InspectEmitter.emitCompareAlpha(jvmCode, inspectData.source, local, inspectItemClause.operand);
                            Opcodes.AND(jvmCode);
                            break;
                        }
                        case First: {
                            Opcodes.LOAD_LOCAL(jvmCode, object[n3]);
                            Opcodes.LOAD_CONST(jvmCode, 0);
                            Opcodes.EQ(jvmCode);
                            InspectEmitter.emitCompareAlpha(jvmCode, inspectData.source, local, inspectItemClause.operand);
                            Opcodes.AND(jvmCode);
                            break;
                        }
                        default: {
                            Opcodes.LOAD_CONST(jvmCode, true);
                        }
                    }
                }
                if (n2 > 1 && (inspectItemClause.before != null || inspectItemClause.after != null)) {
                    Opcodes.AND(jvmCode);
                }
                if (n4 != 0) {
                    Opcodes.ELIF(jvmCode);
                } else {
                    Opcodes.IF(jvmCode);
                    n4 = 1;
                }
                InspectEmitter.emitTallyReplaceConditionMatched(jvmCode, inspectData, object2[n3], local, inspectItem, inspectItemClause);
                Opcodes.LOAD_LOCAL(jvmCode, local);
                if (inspectItemClause.operand != null) {
                    Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.operand.length);
                } else {
                    Opcodes.LOAD_CONST(jvmCode, 1);
                }
                Opcodes.ADD(jvmCode);
                Opcodes.STORE_LOCAL(jvmCode, local);
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Increment main counter");
                switch (inspectItemClause.kind) {
                    case Leading: 
                    case First: {
                        Opcodes.LOAD_LOCAL(jvmCode, object[n3]);
                        if (inspectItemClause.operand != null) {
                            Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.operand.length);
                        } else {
                            Opcodes.LOAD_CONST(jvmCode, 1);
                        }
                        Opcodes.ADD(jvmCode);
                        Opcodes.STORE_LOCAL(jvmCode, object[n3]);
                        Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Increment kind counter");
                    }
                }
                if (n2 == 1) {
                    switch (inspectItemClause.kind) {
                        case Leading: {
                            n5 = 0;
                            Opcodes.ELSE(jvmCode);
                            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "No more characters to inspect");
                            Opcodes.BREAK(jvmCode);
                            break;
                        }
                        case First: {
                            Opcodes.BREAK(jvmCode);
                        }
                    }
                }
                ++n3;
                inspectItemClause = inspectItemClause.nextClause;
            }
        }
        if (n5 != 0) {
            Opcodes.ELSE(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.INC(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, local);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Increment main counter");
        }
        Opcodes.FI(jvmCode);
        Opcodes.DONE(jvmCode);
        n3 = 0;
        if (inspectItemArray instanceof TallyingItem[]) {
            for (TallyingItem tallyingItem : (TallyingItem[])inspectItemArray) {
                inspectItemClause = tallyingItem.clause;
                while (inspectItemClause != null) {
                    Opcodes.LOAD_LOCAL(jvmCode, object2[n3]);
                    InspectEmitter.storeTallyingResult(jvmCode, tallyingItem.tally);
                    ++n3;
                    inspectItemClause = inspectItemClause.nextClause;
                }
            }
        }
    }

    private static void emitTallyReplaceConditionMatched(JvmCode jvmCode, InspectData inspectData, Local local, Local local2, InspectItem inspectItem, InspectItemClause inspectItemClause) {
        if (inspectItem instanceof TallyingItem) {
            InspectEmitter.emitTallyingCounter(jvmCode, local);
        } else if (inspectItem instanceof ReplacingItem) {
            InspectEmitter.emitReplaceBytes(jvmCode, inspectData, local2, inspectItemClause);
        }
    }

    private static void emitTallyingCounter(JvmCode jvmCode, Local local) {
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.INC(jvmCode);
        Opcodes.STORE_LOCAL(jvmCode, local);
        Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Increment tallying counter");
    }

    private static void emitIsolatedTallyingForCharacters(JvmCode jvmCode, InspectData inspectData, TallyingItem tallyingItem, InspectItemClause inspectItemClause) {
        if (inspectItemClause.before == null && inspectItemClause.after == null) {
            Opcodes.INJECT_COMMENT(jvmCode, "Tallying logic optimized for TALLYING FOR CHARACTERS");
            Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.length);
            InspectEmitter.storeTallyingResult(jvmCode, tallyingItem.tally);
        } else if (inspectItemClause.before == null) {
            Opcodes.INJECT_COMMENT(jvmCode, "Tallying logic optimized for TALLYING FOR CHARACTERS AFTER");
            Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.length);
            Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.internalAfterIndex);
            Opcodes.SUB(jvmCode);
            InspectEmitter.storeTallyingResult(jvmCode, tallyingItem.tally);
        } else if (inspectItemClause.after == null) {
            Opcodes.INJECT_COMMENT(jvmCode, "Tallying logic optimized for TALLYING FOR CHARACTERS BEFORE");
            Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.internalBeforeIndex);
            InspectEmitter.storeTallyingResult(jvmCode, tallyingItem.tally);
        } else {
            Opcodes.INJECT_COMMENT(jvmCode, "Tallying logic optimized for TALLYING FOR CHARACTERS BEFORE AFTER");
            Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.internalBeforeIndex);
            Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.internalAfterIndex);
            Opcodes.GT(jvmCode);
            Opcodes.IF(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.internalBeforeIndex);
            Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.internalAfterIndex);
            Opcodes.SUB(jvmCode);
            InspectEmitter.storeTallyingResult(jvmCode, tallyingItem.tally);
            Opcodes.FI(jvmCode);
        }
    }

    private static void emitIsolatedInspectTrailing(JvmCode jvmCode, InspectData inspectData, InspectItem inspectItem, InspectItemClause inspectItemClause) {
        Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.length);
        Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.operand.length);
        Opcodes.SUB(jvmCode);
        Local local = Opcodes.STORE_LOCAL(jvmCode);
        Local local2 = null;
        if (inspectItem instanceof TallyingItem) {
            Opcodes.LOAD_CONST(jvmCode, 0);
            local2 = Opcodes.STORE_LOCAL(jvmCode);
        }
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.LOAD_CONST(jvmCode, 0);
        Opcodes.GE(jvmCode);
        Opcodes.DO_WHILE(jvmCode);
        InspectEmitter.emitCompareAlpha(jvmCode, inspectData.source, local, inspectItemClause.operand);
        Opcodes.IF(jvmCode);
        InspectEmitter.emitTallyReplaceConditionMatched(jvmCode, inspectData, local2, local, inspectItem, inspectItemClause);
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.operand.length);
        Opcodes.SUB(jvmCode);
        Opcodes.STORE_LOCAL(jvmCode, local);
        Opcodes.ELSE(jvmCode);
        Opcodes.BREAK(jvmCode);
        Opcodes.FI(jvmCode);
        Opcodes.DONE(jvmCode);
        if (inspectItem instanceof TallyingItem) {
            Opcodes.LOAD_LOCAL(jvmCode, local2);
            InspectEmitter.storeTallyingResult(jvmCode, ((TallyingItem)inspectItem).tally);
        }
    }

    private static void storeTallyingResult(JvmCode jvmCode, AbstractOperand abstractOperand) {
        com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, abstractOperand);
        Opcodes.ADD(jvmCode);
        com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, abstractOperand);
        Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Store result into tallying operand");
    }

    private static void emitConvertingLogic(JvmCode jvmCode, InspectData inspectData) {
        Opcodes.INJECT_COMMENT(jvmCode, "Actual converting logic");
        ConvertingItem convertingItem = inspectData.convertingItem;
        InspectItemClause inspectItemClause = convertingItem.clause;
        if (convertingItem.from.operand.getStaticSize() == 0 || convertingItem.to.operand.getStaticSize() == 0) {
            Opcodes.LOAD_LOCAL(jvmCode, convertingItem.from.length);
            Opcodes.LOAD_LOCAL(jvmCode, convertingItem.to.length);
            Opcodes.NE(jvmCode);
            Opcodes.IF(jvmCode);
            InspectEmitter.emitFormattedThrow(jvmCode, "Inspect converting size mismatch", new Object[0]);
            Opcodes.FI(jvmCode);
        }
        Opcodes.LOAD_LOCAL(jvmCode, inspectData.minAfter);
        Local local = Opcodes.STORE_LOCAL(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.LOAD_LOCAL(jvmCode, inspectData.maxBefore);
        Opcodes.LT(jvmCode);
        Opcodes.DO_WHILE(jvmCode);
        Opcodes.LOAD_CONST(jvmCode, 0);
        Local local2 = Opcodes.STORE_LOCAL(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, local2);
        Opcodes.LOAD_LOCAL(jvmCode, convertingItem.from.length);
        Opcodes.LT(jvmCode);
        Opcodes.DO_WHILE(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.memory);
        Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.offset);
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.ADD(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, convertingItem.from.memory);
        Opcodes.LOAD_LOCAL(jvmCode, convertingItem.from.offset);
        Opcodes.LOAD_LOCAL(jvmCode, local2);
        Opcodes.ADD(jvmCode);
        Opcodes.LOAD_CONST(jvmCode, 1);
        InspectEmitter.emitQuickCompareAlpha(jvmCode);
        Opcodes.IF(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, convertingItem.to.memory);
        Opcodes.LOAD_LOCAL(jvmCode, convertingItem.to.offset);
        Opcodes.LOAD_LOCAL(jvmCode, local2);
        Opcodes.ADD(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.memory);
        Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.offset);
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.ADD(jvmCode);
        Opcodes.LOAD_CONST(jvmCode, 1);
        InspectEmitter.emitMemoryCopy(jvmCode);
        Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Replace bytes");
        Opcodes.BREAK(jvmCode);
        Opcodes.FI(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, local2);
        Opcodes.INC(jvmCode);
        Opcodes.STORE_LOCAL(jvmCode, local2);
        Opcodes.DONE(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.INC(jvmCode);
        Opcodes.STORE_LOCAL(jvmCode, local);
        Opcodes.DONE(jvmCode);
    }

    private static void emitReplaceBytes(JvmCode jvmCode, InspectData inspectData, Local local, InspectItemClause inspectItemClause) {
        if (inspectItemClause.operand == null || inspectItemClause.operand.operand.getStaticSize() == 1) {
            Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.by.offset);
            Opcodes.GET_MEMORY(jvmCode, inspectItemClause.by.memory);
            Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.offset);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.ADD(jvmCode);
            Opcodes.PUT_MEMORY(jvmCode, inspectData.source.memory);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Replace one byte");
        } else {
            Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.by.memory);
            Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.by.offset);
            Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.memory);
            Opcodes.LOAD_LOCAL(jvmCode, inspectData.source.offset);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.ADD(jvmCode);
            if (inspectItemClause.by.operand.getStaticSize() != 0) {
                Opcodes.LOAD_CONST(jvmCode, inspectItemClause.by.operand.getStaticSize());
            } else {
                Opcodes.LOAD_LOCAL(jvmCode, inspectItemClause.by.length);
            }
            InspectEmitter.emitMemoryCopy(jvmCode);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Replace bytes");
        }
    }

    private static enum InspectItemClauseKind {
        Characters,
        All,
        Leading,
        Trailing,
        First;

    }

    private static class InspectItemClause {
        protected final InspectItemClause nextClause;
        protected final InspectItemClauseKind kind;
        protected final LocalReference operand;
        protected final LocalReference by;
        protected final Local internalAfterIndex;
        protected final LocalReference after;
        protected final Local internalBeforeIndex;
        protected final LocalReference before;

        protected InspectItemClause(JvmCode jvmCode, Inspect.InspectItemClause inspectItemClause) {
            if (inspectItemClause.getKind() != null) {
                switch (inspectItemClause.getKind()) {
                    case Characters: {
                        this.kind = InspectItemClauseKind.Characters;
                        break;
                    }
                    case All: {
                        this.kind = InspectItemClauseKind.All;
                        break;
                    }
                    case Leading: {
                        this.kind = InspectItemClauseKind.Leading;
                        break;
                    }
                    case Trailing: {
                        this.kind = InspectItemClauseKind.Trailing;
                        break;
                    }
                    case First: {
                        this.kind = InspectItemClauseKind.First;
                        break;
                    }
                    default: {
                        this.kind = null;
                        break;
                    }
                }
            } else {
                this.kind = null;
            }
            this.operand = inspectItemClause.getOperand() != null ? BaseEmitter.emitStoreToLocalReference(jvmCode, inspectItemClause.getOperand()) : null;
            LocalReference localReference = this.by = inspectItemClause.getBy() != null ? BaseEmitter.emitStoreToLocalReference(jvmCode, inspectItemClause.getBy()) : null;
            if (inspectItemClause.getBeforeDelimiter() != null) {
                Opcodes.LOAD_CONST(jvmCode, 0);
                this.internalBeforeIndex = Opcodes.STORE_LOCAL(jvmCode);
                this.before = BaseEmitter.emitStoreToLocalReference(jvmCode, inspectItemClause.getBeforeDelimiter());
            } else {
                this.internalBeforeIndex = null;
                this.before = null;
            }
            if (inspectItemClause.getAfterDelimiter() != null) {
                Opcodes.LOAD_CONST(jvmCode, 0);
                this.internalAfterIndex = Opcodes.STORE_LOCAL(jvmCode);
                this.after = BaseEmitter.emitStoreToLocalReference(jvmCode, inspectItemClause.getAfterDelimiter());
            } else {
                this.internalAfterIndex = null;
                this.after = null;
            }
            this.nextClause = inspectItemClause.getNextClause() != null ? new InspectItemClause(jvmCode, inspectItemClause.getNextClause()) : null;
        }
    }

    private static abstract class InspectItem {
        protected InspectItemClause clause = null;

        private InspectItem() {
        }

        protected void addClause(JvmCode jvmCode, Inspect.InspectItemClause inspectItemClause) {
            if (inspectItemClause != null) {
                this.clause = new InspectItemClause(jvmCode, inspectItemClause);
            }
        }
    }

    private static class ReplacingItem
    extends InspectItem {
        protected ReplacingItem(JvmCode jvmCode, Inspect.ReplacingItem replacingItem) {
            if (replacingItem != null) {
                this.addClause(jvmCode, replacingItem.getClause());
            }
        }

        protected static ReplacingItem[] getItemArray(JvmCode jvmCode, Inspect inspect) {
            int n2 = inspect.getReplacingItemCount();
            if (n2 == 0) {
                return null;
            }
            ReplacingItem[] replacingItemArray = new ReplacingItem[n2];
            int n3 = 0;
            Inspect.ReplacingItem replacingItem = inspect.getReplacingItem();
            while (true) {
                replacingItemArray[n3] = new ReplacingItem(jvmCode, replacingItem);
                if (replacingItem.getNextItem() == null) break;
                replacingItem = (Inspect.ReplacingItem)replacingItem.getNextItem();
                ++n3;
            }
            return replacingItemArray;
        }
    }

    private static class ConvertingItem
    extends InspectItem {
        protected final LocalReference from;
        protected final LocalReference to;

        protected ConvertingItem(JvmCode jvmCode, Inspect.ConvertingItem convertingItem) {
            if (convertingItem != null) {
                this.from = BaseEmitter.emitStoreToLocalReference(jvmCode, convertingItem.getFrom());
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Converting from");
                this.to = BaseEmitter.emitStoreToLocalReference(jvmCode, convertingItem.getTo());
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Converting to");
                this.addClause(jvmCode, convertingItem.getClause());
            } else {
                this.to = null;
                this.from = null;
            }
        }

        protected static ConvertingItem getItem(JvmCode jvmCode, Inspect inspect) {
            if (inspect.getConvertingItem() == null) {
                return null;
            }
            return new ConvertingItem(jvmCode, inspect.getConvertingItem());
        }
    }

    private static class TallyingItem
    extends InspectItem {
        protected final Local internalTally;
        protected final AbstractOperand tally;

        protected TallyingItem(JvmCode jvmCode, Inspect.TallyingItem tallyingItem) {
            if (tallyingItem != null) {
                Opcodes.LOAD_CONST(jvmCode, 0);
                this.internalTally = Opcodes.STORE_LOCAL(jvmCode);
                this.tally = tallyingItem.getTally();
                this.addClause(jvmCode, tallyingItem.getClause());
            } else {
                this.internalTally = null;
                this.tally = null;
            }
        }

        protected static TallyingItem[] getItemArray(JvmCode jvmCode, Inspect inspect) {
            int n2 = inspect.getTallyingItemCount();
            if (n2 == 0) {
                return null;
            }
            TallyingItem[] tallyingItemArray = new TallyingItem[n2];
            int n3 = 0;
            Inspect.TallyingItem tallyingItem = inspect.getTallyingItem();
            while (true) {
                tallyingItemArray[n3] = new TallyingItem(jvmCode, tallyingItem);
                if (tallyingItem.getNextItem() == null) break;
                tallyingItem = (Inspect.TallyingItem)tallyingItem.getNextItem();
                ++n3;
            }
            return tallyingItemArray;
        }
    }

    private static class InspectData {
        protected final LocalReference source;
        protected final Local minAfter;
        protected final Local maxBefore;
        protected final TallyingItem[] tallyingItems;
        protected final ReplacingItem[] replacingItems;
        protected final ConvertingItem convertingItem;

        protected InspectData(JvmCode jvmCode, Inspect inspect) {
            Opcodes.INJECT_COMMENT(jvmCode, "Creating a new instance of InspectData");
            this.source = BaseEmitter.emitStoreToLocalReference(jvmCode, inspect.getSource());
            Opcodes.LOAD_CONST(jvmCode, 0);
            this.minAfter = Opcodes.STORE_LOCAL(jvmCode);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "minAfter");
            Opcodes.LOAD_CONST(jvmCode, 0);
            this.maxBefore = Opcodes.STORE_LOCAL(jvmCode);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "maxBefore");
            this.tallyingItems = TallyingItem.getItemArray(jvmCode, inspect);
            this.replacingItems = ReplacingItem.getItemArray(jvmCode, inspect);
            this.convertingItem = ConvertingItem.getItem(jvmCode, inspect);
        }

        protected int countClauses(InspectItem[] inspectItemArray) {
            int n2 = 0;
            for (InspectItem inspectItem : inspectItemArray) {
                InspectItemClause inspectItemClause = inspectItem.clause;
                while (inspectItemClause != null) {
                    ++n2;
                    inspectItemClause = inspectItemClause.nextClause;
                }
            }
            return n2;
        }

        protected InspectItemClause findFirstClause(InspectItemClauseKind inspectItemClauseKind, InspectItem[] inspectItemArray) {
            for (InspectItem inspectItem : inspectItemArray) {
                InspectItemClause inspectItemClause = inspectItem.clause;
                while (inspectItemClause != null) {
                    if (inspectItemClause.kind == inspectItemClauseKind) {
                        return inspectItemClause;
                    }
                    inspectItemClause = inspectItemClause.nextClause;
                }
            }
            return null;
        }
    }
}

