/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.statements.BaseFileIOEmitter;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.stmts.Open;

public abstract class OpenEmitter
extends BaseFileIOEmitter {
    public static void emit(JvmCode jvmCode, IStatement iStatement) {
        Open.OpenData openData = ((Open)iStatement).getData();
        FileDeclaration fileDeclaration = openData.getFile();
        Object t2 = fileDeclaration.getFcdDataItem().getChunk();
        FileDeclaration.LockMode lockMode = fileDeclaration.getLockMode();
        Open.SharingMode sharingMode = openData.getSharingMode();
        int n2 = 0;
        if (openData.getWithLock() | lockMode == FileDeclaration.LockMode.Exclusive) {
            n2 |= 1;
        } else {
            if (sharingMode == Open.SharingMode.WithNoOther) {
                n2 |= 1;
            } else if (lockMode != null) {
                switch (lockMode) {
                    case Manual: {
                        n2 |= 4;
                        break;
                    }
                    case Automatic: {
                        n2 |= 2;
                    }
                }
            }
            if (fileDeclaration.isMultipleRecordLock()) {
                n2 |= 0x80;
            }
            if (sharingMode == Open.SharingMode.WithReadOnly) {
                Opcodes.LOAD_CONST(jvmCode, 64);
                OpenEmitter.emitSimpleStoreByte(jvmCode, t2, 23);
            }
        }
        Opcodes.LOAD_CONST(jvmCode, n2);
        OpenEmitter.emitSimpleStoreByte(jvmCode, t2, 28);
        OpenEmitter.emitFullCallToHandler(jvmCode, openData);
    }
}

