/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.statements;

import com.veryant.cobol.compiler.IStatement;
import com.veryant.cobol.compiler.emitters.jvm.JvmCode;
import com.veryant.cobol.compiler.emitters.jvm.Label;
import com.veryant.cobol.compiler.emitters.jvm.Local;
import com.veryant.cobol.compiler.emitters.jvm.LocalReference;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.core.Functions;
import com.veryant.cobol.compiler.emitters.jvm.core.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.statements.BaseEmitter;
import com.veryant.cobol.compiler.emitters.jvm.statements.Mapper;
import com.veryant.cobol.compiler.stmts.Unstring;
import com.veryant.cobol.compiler.types.AbstractOperand;

public abstract class UnstringEmitter
extends BaseEmitter {
    public static void emit(JvmCode jvmCode, IStatement iStatement) {
        Unstring unstring = (Unstring)iStatement;
        UnstringData unstringData = new UnstringData(jvmCode, unstring);
        Opcodes.INJECT_COMMENT(jvmCode, "Main loop");
        Opcodes.LOAD_CONST(jvmCode, 0);
        Local local = Opcodes.STORE_LOCAL(jvmCode);
        Local local2 = null;
        if (unstring.getOnOverflow() != null || unstring.getNotOnOverflow() != null) {
            Opcodes.LOAD_CONST(jvmCode, false);
            local2 = Opcodes.STORE_LOCAL(jvmCode);
        }
        Label label = Opcodes.DECLARE_LABEL(jvmCode);
        if (unstringData.pointer != null) {
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, unstringData.pointer);
            Opcodes.CAST(jvmCode, VMType.INT32);
            Opcodes.DEC(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, local);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.LOAD_CONST(jvmCode, 0);
            Opcodes.LT(jvmCode);
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.length);
            Opcodes.GE(jvmCode);
            Opcodes.OR(jvmCode);
            Opcodes.IF(jvmCode);
            if (local2 != null) {
                Opcodes.LOAD_CONST(jvmCode, true);
                Opcodes.STORE_LOCAL(jvmCode, local2);
            }
            Opcodes.JUMP_TO_LABEL(jvmCode, label);
            Opcodes.FI(jvmCode);
        }
        Opcodes.LOAD_CONST(jvmCode, 0);
        Local local3 = Opcodes.STORE_LOCAL(jvmCode);
        Local local4 = null;
        if (unstringData.delimiters != null) {
            Opcodes.LOAD_LOCAL(jvmCode, local);
            local4 = Opcodes.STORE_LOCAL(jvmCode);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "mainIndex = mainCounter;");
        }
        for (int i2 = 0; i2 < unstringData.intos.length; ++i2) {
            UnstringInto unstringInto = unstringData.intos[i2];
            if (unstringData.delimiters == null) {
                Opcodes.LOAD_LOCAL(jvmCode, local);
                Opcodes.LOAD_LOCAL(jvmCode, unstringInto.operand.length);
                Opcodes.ADD(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.length);
                Opcodes.GT(jvmCode);
                Opcodes.IF(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.length);
                Opcodes.LOAD_LOCAL(jvmCode, local);
                Opcodes.SUB(jvmCode);
                Opcodes.STORE_LOCAL(jvmCode, local3);
                Opcodes.LOAD_LOCAL(jvmCode, local3);
                Opcodes.LOAD_CONST(jvmCode, 0);
                Opcodes.GT(jvmCode);
                Opcodes.IF(jvmCode);
                UnstringEmitter.moveDataToTarget(jvmCode, unstringData, local, local3, unstringInto);
                Opcodes.FI(jvmCode);
                Opcodes.JUMP_TO_LABEL(jvmCode, label);
                Opcodes.FI(jvmCode);
                Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.length);
                Opcodes.STORE_LOCAL(jvmCode, local3);
                UnstringEmitter.moveDataToTarget(jvmCode, unstringData, local, local3, unstringInto);
                Opcodes.LOAD_LOCAL(jvmCode, local);
                Opcodes.LOAD_LOCAL(jvmCode, unstringInto.operand.length);
                Opcodes.ADD(jvmCode);
                Opcodes.STORE_LOCAL(jvmCode, local);
                continue;
            }
            if (i2 > 0) {
                Opcodes.LOAD_LOCAL(jvmCode, local);
                Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.length);
                Opcodes.GE(jvmCode);
                Opcodes.IF(jvmCode);
                Opcodes.JUMP_TO_LABEL(jvmCode, label);
                Opcodes.FI(jvmCode);
                Opcodes.LOAD_CONST(jvmCode, 0);
                Opcodes.STORE_LOCAL(jvmCode, local3);
                Opcodes.LOAD_LOCAL(jvmCode, local);
                Opcodes.STORE_LOCAL(jvmCode, local4);
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "mainIndex = mainCounter;");
            }
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.length);
            Opcodes.LT(jvmCode);
            Opcodes.DO_WHILE(jvmCode);
            for (UnstringDelimiter unstringDelimiter : unstringData.delimiters) {
                UnstringEmitter.emitCompareAlpha(jvmCode, unstringData.source, local, unstringDelimiter.delimiter);
                Opcodes.IF(jvmCode);
                if (unstringInto.delimiter != null) {
                    com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD_ADDR(jvmCode, unstringDelimiter.delimiter.operand);
                    com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, unstringInto.delimiter.operand);
                    Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Store the delimiter");
                }
                Opcodes.LOAD_LOCAL(jvmCode, local);
                Opcodes.LOAD_LOCAL(jvmCode, local4);
                Opcodes.SUB(jvmCode);
                Opcodes.STORE_LOCAL(jvmCode, local3);
                Opcodes.LOAD_LOCAL(jvmCode, unstringDelimiter.delimiter.length);
                Opcodes.LOAD_LOCAL(jvmCode, local);
                Opcodes.ADD(jvmCode);
                Opcodes.STORE_LOCAL(jvmCode, local);
                if (unstringDelimiter.isAll) {
                    Opcodes.LOAD_LOCAL(jvmCode, local);
                    Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.length);
                    Opcodes.LT(jvmCode);
                    UnstringEmitter.emitCompareAlpha(jvmCode, unstringData.source, local, unstringDelimiter.delimiter);
                    Opcodes.AND(jvmCode);
                    Opcodes.DO_WHILE(jvmCode);
                    Opcodes.LOAD_LOCAL(jvmCode, unstringDelimiter.delimiter.length);
                    Opcodes.LOAD_LOCAL(jvmCode, local);
                    Opcodes.ADD(jvmCode);
                    Opcodes.STORE_LOCAL(jvmCode, local);
                    Opcodes.DONE(jvmCode);
                }
                Opcodes.BREAK(jvmCode);
                Opcodes.FI(jvmCode);
            }
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.INC(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, local);
            Opcodes.DONE(jvmCode);
            if (unstringInto.count != null) {
                Opcodes.LOAD_LOCAL(jvmCode, local3);
                com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, unstringInto.count);
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Update COBOL COUNT");
            }
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.length);
            Opcodes.GE(jvmCode);
            Opcodes.IF(jvmCode);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Delimiter not found");
            Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.length);
            Opcodes.LOAD_LOCAL(jvmCode, local4);
            Opcodes.SUB(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, local3);
            Opcodes.FI(jvmCode);
            UnstringEmitter.moveDataToTarget(jvmCode, unstringData, local4, local3, unstringInto);
        }
        if (local2 != null) {
            Opcodes.LOAD_CONST(jvmCode, true);
            Opcodes.STORE_LOCAL(jvmCode, local2);
        }
        Opcodes.PLACE_LABEL(jvmCode, label);
        if (unstringData.pointer != null) {
            Opcodes.LOAD_LOCAL(jvmCode, local);
            Opcodes.INC(jvmCode);
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, unstringData.pointer);
        }
        if (unstringData.internalTallying != null) {
            Opcodes.LOAD_LOCAL(jvmCode, unstringData.internalTallying);
            com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, unstringData.tallying);
        }
        if (local2 != null) {
            Opcodes.LOAD_LOCAL(jvmCode, local2);
            Opcodes.IF(jvmCode);
            if (unstring.getOnOverflow() != null) {
                Mapper.emit(jvmCode, unstring.getOnOverflow());
            }
            Opcodes.ELSE(jvmCode);
            if (unstring.getNotOnOverflow() != null) {
                Mapper.emit(jvmCode, unstring.getNotOnOverflow());
            }
            Opcodes.FI(jvmCode);
        }
    }

    private static void moveDataToTarget(JvmCode jvmCode, UnstringData unstringData, Local local, Local local2, UnstringInto unstringInto) {
        Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.memory);
        Opcodes.LOAD_LOCAL(jvmCode, local);
        Opcodes.LOAD_LOCAL(jvmCode, unstringData.source.offset);
        Opcodes.ADD(jvmCode);
        Opcodes.LOAD_LOCAL(jvmCode, local2);
        Functions.f_wrap_as_address(jvmCode);
        com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.STORE(jvmCode, unstringInto.operand.operand);
        if (unstringData.internalTallying != null) {
            Opcodes.LOAD_LOCAL(jvmCode, unstringData.internalTallying);
            Opcodes.INC(jvmCode);
            Opcodes.STORE_LOCAL(jvmCode, unstringData.internalTallying);
        }
    }

    private static class UnstringInto {
        protected final LocalReference operand;
        protected final LocalReference delimiter;
        protected final AbstractOperand count;

        private UnstringInto(JvmCode jvmCode, Unstring.IntoItem intoItem) {
            this.operand = BaseEmitter.emitStoreToLocalReference(jvmCode, intoItem.operand);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Into");
            if (intoItem.delimiter != null) {
                this.delimiter = BaseEmitter.emitStoreToLocalReference(jvmCode, intoItem.delimiter);
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Delimiter");
            } else {
                this.delimiter = null;
            }
            if (intoItem.count != null) {
                this.count = intoItem.count;
                Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Count");
            } else {
                this.count = null;
            }
        }

        public static UnstringInto[] getItemArray(JvmCode jvmCode, Unstring unstring) {
            int n2 = unstring.getIntoItemCount();
            if (n2 == 0) {
                return null;
            }
            UnstringInto[] unstringIntoArray = new UnstringInto[n2];
            int n3 = 0;
            Unstring.IntoItem intoItem = unstring.getIntoItem();
            while (true) {
                unstringIntoArray[n3] = new UnstringInto(jvmCode, intoItem);
                if (intoItem.getNextItem() == null) break;
                intoItem = (Unstring.IntoItem)intoItem.getNextItem();
                ++n3;
            }
            return unstringIntoArray;
        }
    }

    private static class UnstringDelimiter {
        protected final LocalReference delimiter;
        protected final boolean isAll;

        private UnstringDelimiter(JvmCode jvmCode, Unstring.DelimiterItem delimiterItem) {
            this.delimiter = BaseEmitter.emitStoreToLocalReference(jvmCode, delimiterItem.delimiter);
            Opcodes.INJECT_INLINE_COMMENT(jvmCode, "Delimiter");
            this.isAll = delimiterItem.isAll;
        }

        public static UnstringDelimiter[] getItemArray(JvmCode jvmCode, Unstring unstring) {
            int n2 = unstring.getDelimiterItemCount();
            if (n2 == 0) {
                return null;
            }
            UnstringDelimiter[] unstringDelimiterArray = new UnstringDelimiter[n2];
            int n3 = 0;
            Unstring.DelimiterItem delimiterItem = unstring.getDelimiterItem();
            while (true) {
                unstringDelimiterArray[n3] = new UnstringDelimiter(jvmCode, delimiterItem);
                if (delimiterItem.getNextItem() == null) break;
                delimiterItem = (Unstring.DelimiterItem)delimiterItem.getNextItem();
                ++n3;
            }
            return unstringDelimiterArray;
        }
    }

    private static class UnstringData {
        protected final LocalReference source;
        protected final UnstringDelimiter[] delimiters;
        protected final UnstringInto[] intos;
        protected final AbstractOperand pointer;
        protected final AbstractOperand tallying;
        protected final Local internalTallying;

        private UnstringData(JvmCode jvmCode, Unstring unstring) {
            this.source = BaseEmitter.emitStoreToLocalReference(jvmCode, unstring.getSource());
            this.delimiters = UnstringDelimiter.getItemArray(jvmCode, unstring);
            this.intos = UnstringInto.getItemArray(jvmCode, unstring);
            this.pointer = unstring.getPointer() != null ? unstring.getPointer() : null;
            if (unstring.getTallying() != null) {
                this.tallying = unstring.getTallying();
                com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes.LOAD(jvmCode, this.tallying);
                this.internalTallying = Opcodes.STORE_LOCAL(jvmCode);
            } else {
                this.tallying = null;
                this.internalTallying = null;
            }
        }
    }
}

