/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.memory;

import com.veryant.cobol.compiler.memory.Chunk;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.util.LinkedList;
import java.util.List;

public class DynamicChunk
extends Chunk {
    public static final int MAX_NATURAL_BOUNDARY = 16;
    private final int index;
    private List<DynamicChunk> cluster;
    private int multiplier;
    private boolean sized;
    private DynamicChunk union;

    private static int checkMemoryLimit(long l2) {
        if (l2 < 0L || l2 > 0x7FFFFFFAL) {
            throw new COBOLCompilerException("Requested memory size exceeds Target limit");
        }
        return (int)l2;
    }

    private void checkMemoryLimit() {
        if (this.multiplier > 0) {
            DynamicChunk.checkMemoryLimit((long)this.getOffset() + (long)DynamicChunk.checkMemoryLimit((long)this.getSize() * (long)this.multiplier));
        } else {
            DynamicChunk.checkMemoryLimit((long)this.getOffset() + (long)this.getSize());
        }
    }

    public boolean hasUnion() {
        return this.union != null;
    }

    public final int getPhysicalSize() {
        if (this.multiplier > 0) {
            return this.getSize() * this.multiplier;
        }
        return this.getSize();
    }

    public DynamicChunk(int n2, int n3) {
        super(n3);
        this.index = n2;
        this.sized = n3 > 0;
    }

    public DynamicChunk(int n2, int n3, int n4) {
        this(n2, n3);
        this.multiplier = n4;
        this.checkMemoryLimit();
    }

    protected void add(DynamicChunk dynamicChunk) {
        if (this.cluster == null) {
            this.cluster = new LinkedList<DynamicChunk>();
            this.sized = dynamicChunk.sized;
        }
        this.cluster.add(dynamicChunk);
        this.sized &= dynamicChunk.sized;
    }

    private boolean relocate(int n2, boolean bl) {
        if (this.union != null) {
            n2 = this.union.getOffset();
        }
        if (this.cluster == null) {
            return this.relocateChunk(n2, bl);
        }
        return this.relocateCluster(n2, bl);
    }

    public boolean relocate(int n2) {
        return this.relocate(n2, false);
    }

    private boolean relocateCluster(int n2, boolean bl) {
        for (DynamicChunk dynamicChunk : this.cluster) {
            if (!dynamicChunk.relocate(n2, bl || this.isUsed())) continue;
            int n3 = this.getPhysicalSize();
            if (n3 == 0) {
                this.setOffset(dynamicChunk.getOffset());
            }
            int n4 = this.getOffset();
            int n5 = dynamicChunk.getOffset() + dynamicChunk.getPhysicalSize() - n4;
            if (n5 < n3) {
                n5 = n3;
            }
            n2 = n4 + n5;
            this.setSize(n5);
        }
        return this.getPhysicalSize() > 0;
    }

    private boolean relocateChunk(int n2, boolean bl) {
        if (!bl && !this.isUsed()) {
            return false;
        }
        if (this.isAligned()) {
            int n3;
            int n4 = 16;
            while (n4 > 2) {
                int n5 = n4 / 2;
                if (this.getSize() > n5) break;
                n4 = n5;
            }
            if ((n3 = n2 % n4) > 0) {
                n2 += n4 - n3;
            }
        }
        this.setOffset(n2);
        this.checkMemoryLimit();
        return true;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSized() {
        return this.sized;
    }

    public void setUnion(DynamicChunk dynamicChunk) {
        this.union = dynamicChunk;
    }
}

