/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.scope;

import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.IDirectiveListener;
import com.veryant.cobol.compiler.memory.DataItem;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.memory.RecordItem;
import com.veryant.cobol.compiler.scope.AbstractDeclaration;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.scope.MultiMap;
import com.veryant.cobol.compiler.scope.NamedConditionDeclaration;
import com.veryant.cobol.compiler.scope.NamedConstantDeclaration;
import com.veryant.cobol.compiler.scope.ParagraphDeclaration;
import com.veryant.cobol.compiler.scope.SectionDeclaration;
import com.veryant.cobol.compiler.scope.SplitKeyDeclaration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class Scope
implements IDirectiveListener {
    private static final DataItemDeclaration[] NO_DATAITEM = new DataItemDeclaration[0];
    private static final NamedConditionDeclaration[] NO_CONDITION = new NamedConditionDeclaration[0];
    private static final SectionDeclaration[] NO_SECTION = new SectionDeclaration[0];
    private static final ParagraphDeclaration[] NO_PARAGRAPH = new ParagraphDeclaration[0];
    private final HashMap<String, Class<? extends AbstractDeclaration>> uniquenessMap = new HashMap();
    private MultiMap<String, DataItemDeclaration> dataItems = new MultiMap();
    private MultiMap<String, NamedConditionDeclaration> namedConditions = new MultiMap();
    private MultiMap<String, NamedConstantDeclaration> namedConstants = new MultiMap();
    private HashMap<String, FileDeclaration> files = new HashMap();
    private MultiMap<String, SplitKeyDeclaration> splitKeys = new MultiMap();
    private MultiMap<String, SectionDeclaration> sections = new MultiMap();
    private MultiMap<String, ParagraphDeclaration> paragraphs = new MultiMap();
    private boolean underscoreAsHyphen = false;
    private SectionDeclaration currentSection = new SectionDeclaration();
    private Directives directives;
    private boolean[] _subscribedDirectivesFlags = null;

    public String normalize(String string) {
        if (this.underscoreAsHyphen) {
            return string.toUpperCase().replace('_', '-');
        }
        return string.toUpperCase();
    }

    public boolean add(SectionDeclaration sectionDeclaration) {
        this.currentSection = sectionDeclaration;
        if (this.isUnique(this.currentSection.getName(), SectionDeclaration.class)) {
            this.sections.put(this.normalize(this.currentSection.getName()), sectionDeclaration);
            return true;
        }
        return false;
    }

    public SectionDeclaration[] getSectionDeclarations() {
        return this.sections.values().toArray(new SectionDeclaration[this.sections.values().size()]);
    }

    public boolean add(ParagraphDeclaration paragraphDeclaration) {
        this.currentSection.add(paragraphDeclaration);
        if (this.isUnique(paragraphDeclaration.getName(), ParagraphDeclaration.class)) {
            this.paragraphs.put(this.normalize(paragraphDeclaration.getName()), paragraphDeclaration);
            return true;
        }
        return false;
    }

    public boolean add(DataItemDeclaration dataItemDeclaration) {
        if (this.isUnique(dataItemDeclaration.getName(), DataItemDeclaration.class)) {
            this.dataItems.put(this.normalize(dataItemDeclaration.getName()), dataItemDeclaration);
            return true;
        }
        return false;
    }

    public boolean add(NamedConditionDeclaration namedConditionDeclaration) {
        if (this.isUnique(namedConditionDeclaration.getName(), DataItemDeclaration.class)) {
            this.namedConditions.put(this.normalize(namedConditionDeclaration.getName()), namedConditionDeclaration);
            return true;
        }
        return false;
    }

    public boolean add(NamedConstantDeclaration namedConstantDeclaration) {
        if (this.isUnique(namedConstantDeclaration.getName(), NamedConstantDeclaration.class)) {
            this.namedConstants.put(this.normalize(namedConstantDeclaration.getName()), namedConstantDeclaration);
            return true;
        }
        return false;
    }

    public boolean add(FileDeclaration fileDeclaration) {
        String string = this.normalize(fileDeclaration.getName());
        if (!this.files.containsKey(string)) {
            this.files.put(string, fileDeclaration);
            return true;
        }
        return false;
    }

    public boolean add(SplitKeyDeclaration splitKeyDeclaration) {
        if (this.isUnique(splitKeyDeclaration.getName(), SplitKeyDeclaration.class)) {
            this.splitKeys.put(this.normalize(splitKeyDeclaration.getName()), splitKeyDeclaration);
            return true;
        }
        return false;
    }

    private boolean match(DataItem dataItem, String[] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (dataItem == null) {
                return false;
            }
            if (this.normalize(stringArray[n2]).equals(this.normalize(dataItem.getName()))) {
                ++n2;
            } else if (n2 == stringArray.length - 1 && dataItem instanceof RecordItem) {
                RecordItem recordItem = (RecordItem)dataItem;
                if (this.normalize(stringArray[n2]).equals(this.normalize(recordItem.getFile().getName()))) {
                    ++n2;
                }
            }
            dataItem = dataItem.getParent();
        }
        return true;
    }

    public DataItemDeclaration[] getDataItem(String string, String[] stringArray) {
        ArrayList<DataItemDeclaration> arrayList = this.dataItems.get(string = this.normalize(string));
        if (arrayList == null || arrayList.size() == 0) {
            return NO_DATAITEM;
        }
        if (stringArray == null) {
            return arrayList.toArray(new DataItemDeclaration[arrayList.size()]);
        }
        ArrayList<DataItemDeclaration> arrayList2 = new ArrayList<DataItemDeclaration>(2);
        for (DataItemDeclaration dataItemDeclaration : arrayList) {
            if (!this.match(dataItemDeclaration.getDataItem().getParent(), stringArray)) continue;
            arrayList2.add(dataItemDeclaration);
        }
        if (arrayList2.size() != 0) {
            return arrayList2.toArray(new DataItemDeclaration[arrayList2.size()]);
        }
        return NO_DATAITEM;
    }

    public NamedConditionDeclaration[] getNamedCondition(String string, String[] stringArray) {
        ArrayList<NamedConditionDeclaration> arrayList = this.namedConditions.get(string = this.normalize(string));
        if (arrayList == null || arrayList.size() == 0) {
            return NO_CONDITION;
        }
        if (stringArray == null) {
            return arrayList.toArray(new NamedConditionDeclaration[arrayList.size()]);
        }
        ArrayList<NamedConditionDeclaration> arrayList2 = new ArrayList<NamedConditionDeclaration>(2);
        for (NamedConditionDeclaration namedConditionDeclaration : arrayList) {
            if (!this.match(namedConditionDeclaration.getParent().getDataItem(), stringArray)) continue;
            arrayList2.add(namedConditionDeclaration);
        }
        if (arrayList2.size() != 0) {
            return arrayList2.toArray(new NamedConditionDeclaration[arrayList2.size()]);
        }
        return NO_CONDITION;
    }

    public NamedConditionDeclaration[] getNamedConditions() {
        return this.namedConditions.values().toArray(new NamedConditionDeclaration[0]);
    }

    public NamedConstantDeclaration getNamedConstant(String string) {
        ArrayList<NamedConstantDeclaration> arrayList = this.namedConstants.get(string = this.normalize(string));
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return arrayList.get(0);
    }

    public SectionDeclaration[] getSection(String string) {
        ArrayList<SectionDeclaration> arrayList = this.sections.get(string = this.normalize(string));
        if (arrayList == null || arrayList.size() == 0) {
            return NO_SECTION;
        }
        return arrayList.toArray(new SectionDeclaration[arrayList.size()]);
    }

    public SectionDeclaration[] getSections() {
        ArrayList<SectionDeclaration> arrayList = this.sections.values();
        return arrayList.toArray(new SectionDeclaration[arrayList.size()]);
    }

    public ParagraphDeclaration[] getParagraph(String string) {
        ArrayList<ParagraphDeclaration> arrayList = this.paragraphs.get(string = this.normalize(string));
        if (arrayList == null || arrayList.size() == 0) {
            return NO_PARAGRAPH;
        }
        return arrayList.toArray(new ParagraphDeclaration[arrayList.size()]);
    }

    public ParagraphDeclaration[] getParagraph(String string, SectionDeclaration sectionDeclaration) {
        ParagraphDeclaration[] paragraphDeclarationArray;
        ArrayList<ParagraphDeclaration> arrayList = new ArrayList<ParagraphDeclaration>();
        for (ParagraphDeclaration paragraphDeclaration : paragraphDeclarationArray = this.getParagraph(string)) {
            if (paragraphDeclaration.getParent() != sectionDeclaration) continue;
            arrayList.add(paragraphDeclaration);
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new ParagraphDeclaration[arrayList.size()]);
        }
        return NO_PARAGRAPH;
    }

    public FileDeclaration.Key getKey(FileDeclaration fileDeclaration, String string, String[] stringArray) {
        if (fileDeclaration.getKeys().size() == 0 || fileDeclaration.getPrimeKey() == null) {
            return null;
        }
        string = this.normalize(string);
        if (fileDeclaration.getOrganization() == FileDeclaration.Organization.Indexed && this.splitKeys.containsKey(string)) {
            if (stringArray == null || stringArray.length == 0) {
                for (SplitKeyDeclaration splitKeyDeclaration : this.splitKeys.get(string)) {
                    if (splitKeyDeclaration.getKey().getFile() != fileDeclaration) continue;
                    return splitKeyDeclaration.getKey();
                }
            }
            return null;
        }
        FileDeclaration.Key key = null;
        block5: for (DataItemDeclaration dataItemDeclaration : this.getDataItem(string, stringArray)) {
            switch (fileDeclaration.getOrganization()) {
                case Relative: {
                    if (dataItemDeclaration != fileDeclaration.getKeys().get(0).getDataItemReference().getDataItemDeclaration()) continue block5;
                    return fileDeclaration.getKeys().get(0);
                }
                case Indexed: {
                    RecordItem recordItem = dataItemDeclaration.getDataItem().getRecordItem();
                    if (recordItem == null || !this.normalize(recordItem.getFile().getName()).equals(this.normalize(fileDeclaration.getName()))) continue block5;
                    int n2 = ((DynamicChunk)dataItemDeclaration.getDataItem().getChunk()).getOffset();
                    int n3 = ((DynamicChunk)dataItemDeclaration.getDataItem().getChunk()).getSize();
                    for (FileDeclaration.Key key2 : fileDeclaration.getKeys()) {
                        if (key2.getOffset() != n2) continue;
                        int n4 = key2.getMatchLength();
                        if (n4 == n3) {
                            return key2;
                        }
                        if (n3 >= n4 || key != null && n4 <= key.getMatchLength()) continue;
                        key = key2;
                    }
                    continue block5;
                }
            }
        }
        return key;
    }

    private boolean isUnique(String string, Class<? extends AbstractDeclaration> clazz) {
        Class<? extends AbstractDeclaration> clazz2 = this.uniquenessMap.get(string = this.normalize(string));
        if (clazz2 == null) {
            this.uniquenessMap.put(string, clazz);
            return true;
        }
        return clazz2.equals(clazz);
    }

    public FileDeclaration declareFileSelect(Context context, ISourceReference iSourceReference, String string) {
        FileDeclaration fileDeclaration;
        String string2 = this.normalize(string);
        if (!this.files.containsKey(string2)) {
            fileDeclaration = new FileDeclaration(context, iSourceReference, string, this.files.size());
            fileDeclaration.setIsSelectDuplicate(false);
            fileDeclaration.setIsFDMissing(true);
            this.add(fileDeclaration);
        } else {
            fileDeclaration = this.files.get(string2);
            fileDeclaration.setIsSelectDuplicate(true);
        }
        fileDeclaration.setIsSelectMissing(false);
        return fileDeclaration;
    }

    public FileDeclaration declareFileDescription(Context context, ISourceReference iSourceReference, String string) {
        FileDeclaration fileDeclaration = this.getExistingFile(context, iSourceReference, string);
        fileDeclaration.setIsFDMissing(false);
        return fileDeclaration;
    }

    public FileDeclaration getExistingFile(Context context, ISourceReference iSourceReference, String string) {
        String string2 = this.normalize(string);
        if (this.files.containsKey(string2)) {
            return this.files.get(string2);
        }
        FileDeclaration fileDeclaration = new FileDeclaration(context, iSourceReference, string, this.files.size());
        this.files.put(string2, fileDeclaration);
        fileDeclaration.setIsSelectMissing(true);
        fileDeclaration.setIsSelectDuplicate(false);
        fileDeclaration.setIsFDMissing(true);
        return fileDeclaration;
    }

    public FileDeclaration[] getFiles(boolean bl) {
        if (bl) {
            return this.files.values().toArray(new FileDeclaration[this.files.size()]);
        }
        ArrayList<FileDeclaration> arrayList = new ArrayList<FileDeclaration>();
        for (FileDeclaration fileDeclaration : this.files.values()) {
            if (fileDeclaration.isDeclaredOnly()) continue;
            arrayList.add(fileDeclaration);
        }
        return arrayList.toArray(new FileDeclaration[arrayList.size()]);
    }

    @Override
    public Directives getDirectives() {
        return this.directives;
    }

    @Override
    public void setDirectives(Directives directives) {
        this.directives = directives;
    }

    @Override
    public boolean[] getSubscribedDirectivesFlags() {
        if (this._subscribedDirectivesFlags == null) {
            this._subscribedDirectivesFlags = new boolean[323];
            this._subscribedDirectivesFlags[179] = true;
        }
        return this._subscribedDirectivesFlags;
    }

    @Override
    public void onDirectiveChanged(BaseDirective baseDirective) {
        switch (baseDirective.getIndex()) {
            case 6: {
                this.underscoreAsHyphen = baseDirective.isSet();
            }
        }
    }

    @Override
    public void close() throws IOException {
        IDirectiveListener.super.close();
    }

    public SectionDeclaration getCurrentSection() {
        return this.currentSection;
    }
}

