/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.emitters.jvm.MathPrecision;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import com.veryant.cobol.compiler.stmts.CodeBlock;

public abstract class AbstractArithmeticStatement
extends AbstractStatement {
    private CodeBlock sizeError;
    private CodeBlock notSizeError;

    public boolean hasSizeError() {
        return this.notSizeError != null || this.sizeError != null;
    }

    public abstract MathPrecision getPrecision();

    @Override
    public int getRank() {
        int n2 = super.getRank();
        if (this.sizeError != null) {
            n2 += this.sizeError.getRank();
        }
        if (this.notSizeError != null) {
            n2 += this.notSizeError.getRank();
        }
        return n2;
    }

    public AbstractArithmeticStatement(ISourceReference iSourceReference) {
        super(iSourceReference);
    }

    public CodeBlock getSizeError() {
        return this.sizeError;
    }

    public void setSizeError(CodeBlock codeBlock) {
        this.sizeError = codeBlock;
    }

    public CodeBlock getNotSizeError() {
        return this.notSizeError;
    }

    public void setNotSizeError(CodeBlock codeBlock) {
        this.notSizeError = codeBlock;
    }
}

