/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.EntryPoint;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.UsingParameterMode;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import com.veryant.cobol.compiler.stmts.CodeBlock;
import com.veryant.cobol.compiler.types.AbstractOperand;

public class Call
extends AbstractStatement {
    private CodeBlock exceptionBlock;
    private CodeBlock notExceptionBlock;
    private final AbstractOperand module;
    private final EntryPoint entryPoint;
    private final UsingParameterMode[] modes;
    private final AbstractOperand[] parameters;
    private final AbstractOperand returnValue;

    @Override
    public Statements getStatement() {
        return Statements.CALL;
    }

    public boolean hasExceptionBlocks() {
        return this.notExceptionBlock != null || this.exceptionBlock != null;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.length > 0;
    }

    @Override
    public int getRank() {
        int n2 = super.getRank();
        if (this.exceptionBlock != null) {
            n2 += this.exceptionBlock.getRank();
        }
        if (this.notExceptionBlock != null) {
            n2 += this.notExceptionBlock.getRank();
        }
        return n2;
    }

    public Call(ISourceReference iSourceReference, EntryPoint entryPoint, AbstractOperand abstractOperand, UsingParameterMode[] usingParameterModeArray, AbstractOperand[] abstractOperandArray, AbstractOperand abstractOperand2) {
        super(iSourceReference);
        this.entryPoint = entryPoint;
        this.module = abstractOperand;
        this.modes = usingParameterModeArray;
        this.parameters = abstractOperandArray;
        this.returnValue = abstractOperand2;
    }

    public CodeBlock getExceptionBlock() {
        return this.exceptionBlock;
    }

    public void setExceptionBlock(CodeBlock codeBlock) {
        this.exceptionBlock = codeBlock;
    }

    public CodeBlock getNotExceptionBlock() {
        return this.notExceptionBlock;
    }

    public void setNotExceptionBlock(CodeBlock codeBlock) {
        this.notExceptionBlock = codeBlock;
    }

    public AbstractOperand getModule() {
        return this.module;
    }

    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public UsingParameterMode[] getModes() {
        return this.modes;
    }

    public AbstractOperand[] getParameters() {
        return this.parameters;
    }

    public AbstractOperand getReturnValue() {
        return this.returnValue;
    }
}

