/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.ArithmeticType;
import com.veryant.cobol.compiler.IOperand;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.emitters.jvm.MathPrecision;
import com.veryant.cobol.compiler.stmts.AbstractArithmeticStatement;
import com.veryant.cobol.compiler.types.AbstractOperand;

public class ComputeArith
extends AbstractArithmeticStatement {
    private final AbstractOperand[] receivers;
    private final AbstractOperand expr;
    private final ArithmeticType arithmeticType;

    @Override
    public Statements getStatement() {
        return Statements.COMPUTE;
    }

    @Override
    public MathPrecision getPrecision() {
        return IOperand.isFloatingPoint(this.expr) ? MathPrecision.FLOATING_POINT_PRECISION : MathPrecision.FIXED_POINT_PRECISION;
    }

    public ComputeArith(ISourceReference iSourceReference, ArithmeticType arithmeticType, AbstractOperand[] abstractOperandArray, AbstractOperand abstractOperand) {
        super(iSourceReference);
        this.arithmeticType = arithmeticType;
        this.receivers = abstractOperandArray;
        this.expr = abstractOperand;
    }

    public AbstractOperand[] getReceivers() {
        return this.receivers;
    }

    public AbstractOperand getExpr() {
        return this.expr;
    }

    public ArithmeticType getArithmeticType() {
        return this.arithmeticType;
    }
}

