/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import com.veryant.cobol.compiler.stmts.data.FileBaseData;

public class Open
extends AbstractStatement {
    private final OpenData data = new OpenData();

    @Override
    public Statements getStatement() {
        return Statements.OPEN;
    }

    public OpenData getData() {
        return this.data;
    }

    public Open(ISourceReference iSourceReference) {
        super(iSourceReference);
    }

    public static enum SharingMode {
        None,
        WithAllOther,
        WithNoOther,
        WithReadOnly;

    }

    public static enum OpenMode {
        Input,
        Output,
        IO,
        Extend;

    }

    public class OpenData
    extends FileBaseData {
        private OpenMode openMode;
        private SharingMode sharingMode = SharingMode.None;
        private boolean reversed = false;
        private boolean withNoRewind = false;
        private boolean withLock = false;

        public OpenMode getOpenMode() {
            return this.openMode;
        }

        public void setOpenMode(OpenMode openMode) {
            this.openMode = openMode;
        }

        public SharingMode getSharingMode() {
            return this.sharingMode;
        }

        public void setSharingMode(SharingMode sharingMode) {
            this.sharingMode = sharingMode;
        }

        public void setReversed(boolean bl) {
            this.reversed = bl;
        }

        public boolean getReversed() {
            return this.reversed;
        }

        public void setWithNoRewind(boolean bl) {
            this.withNoRewind = bl;
        }

        public boolean getWithNoRewind() {
            return this.withNoRewind;
        }

        public void setWithLock(boolean bl) {
            this.withLock = bl;
        }

        public boolean getWithLock() {
            return this.withLock;
        }

        @Override
        public int getStandardOpcode() {
            switch (this.getOpenMode()) {
                case Input: {
                    if (this.getWithNoRewind()) {
                        return 4;
                    }
                    if (this.getReversed()) {
                        return 8;
                    }
                    return 0;
                }
                case Output: {
                    if (this.getWithNoRewind()) {
                        return 5;
                    }
                    return 1;
                }
                case IO: {
                    return 2;
                }
                case Extend: {
                    return 3;
                }
            }
            return 127;
        }
    }
}

