/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.types;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.IStaticCast;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.memory.Literal;
import com.veryant.cobol.compiler.types.AbstractLiteral;
import com.veryant.cobol.data.CobolBigDecimal;
import com.veryant.cobol.data.LocalMemory;

public class NumericLiteral
extends AbstractLiteral {
    private final Magnitude magnitude;
    private final CobolBigDecimal cobolBigDecimal;

    public CobolBigDecimal getCobolBigDecimal() {
        return this.cobolBigDecimal;
    }

    public NumericLiteral(ISourceReference iSourceReference, Literal literal, Magnitude magnitude, CobolBigDecimal cobolBigDecimal) {
        super(iSourceReference, literal);
        this.magnitude = magnitude;
        this.cobolBigDecimal = cobolBigDecimal;
    }

    @Override
    public Magnitude getMagnitude() {
        return this.magnitude;
    }

    @Override
    public BuiltIn getBuiltIn() {
        return BuiltIn.NUMERIC_LITERAL;
    }

    @Override
    public Literal staticCast(BuiltIn builtIn, Magnitude magnitude, int n2) {
        if (magnitude == null) {
            magnitude = this.magnitude;
            n2 = this.magnitude.getDigits();
            if (this.magnitude.getScale() > 0) {
                n2 += this.magnitude.getScale();
            }
        }
        byte[] byArray = new byte[n2];
        IStaticCast iStaticCast = builtIn.getStaticCastFunction();
        if (iStaticCast == null) {
            return null;
        }
        iStaticCast.cast(this.cobolBigDecimal, new LocalMemory(byArray), 0, n2, magnitude);
        return new Literal(this.getValue().getCodepage(), byArray);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.magnitude.isSigned()) {
            stringBuilder.append(this.cobolBigDecimal.isNegative() ? (char)'-' : '+');
        }
        byte[] byArray = this.getValue().getBytes();
        int n2 = byArray.length + this.magnitude.getScale();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 == n2) {
                stringBuilder.append('.');
            }
            stringBuilder.append((char)byArray[i2]);
        }
        return stringBuilder.toString();
    }
}

