/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.types;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.memory.Literal;
import com.veryant.cobol.compiler.memory.SimpleChunk;
import com.veryant.cobol.compiler.types.AbstractLiteral;

public class StringLiteral
extends AbstractLiteral {
    public StringLiteral(ISourceReference iSourceReference, Literal literal) {
        super(iSourceReference, literal);
    }

    @Override
    public BuiltIn getBuiltIn() {
        return BuiltIn.STRING_LITERAL;
    }

    @Override
    public Magnitude getMagnitude() {
        return null;
    }

    @Override
    public Literal staticCast(BuiltIn builtIn, Magnitude magnitude, int n2) {
        Literal literal = this.getValue();
        int n3 = ((SimpleChunk)literal.getChunk()).getSize();
        if (magnitude != null) {
            int n4 = 38;
            if (!magnitude.isFloatingPoint()) {
                n4 = magnitude.getDigits();
            }
            if (n3 > n4) {
                return literal.substring(n3 - n4, n3);
            }
        } else if (n3 > n2) {
            return literal.substring(0, n2);
        }
        return literal;
    }
}

