/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.converters;

import com.veryant.cobol.converters.Endianness;
import com.veryant.cobol.data.IMemory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Bytes {
    public static final ByteOrder byteOrder = Endianness.getByteOrder();

    private static ByteBuffer newBuffer(int n2) {
        return ByteBuffer.wrap(new byte[n2]).order(byteOrder);
    }

    private static ByteBuffer newBuffer(IMemory iMemory, int n2, int n3) {
        byte[] byArray = new byte[n3];
        iMemory.copy(byArray, n2, 0, n3);
        return ByteBuffer.wrap(byArray).order(byteOrder);
    }

    public static byte[] get(float f2) {
        return Bytes.newBuffer(4).putFloat(0, f2).array();
    }

    public static byte[] get(double d2) {
        return Bytes.newBuffer(8).putDouble(0, d2).array();
    }

    public static byte[] get(byte by) {
        return new byte[]{by};
    }

    public static byte[] get(char c2) {
        return Bytes.newBuffer(2).putChar(0, c2).array();
    }

    public static byte[] get(short s2) {
        return Bytes.newBuffer(2).putShort(0, s2).array();
    }

    public static byte[] get(int n2) {
        return Bytes.newBuffer(4).putInt(0, n2).array();
    }

    public static byte[] get(long l2) {
        return Bytes.newBuffer(8).putLong(0, l2).array();
    }

    public static float toFloat(IMemory iMemory, int n2) {
        return Bytes.newBuffer(iMemory, n2, 4).getFloat(0);
    }

    public static double toDouble(IMemory iMemory, int n2) {
        return Bytes.newBuffer(iMemory, n2, 8).getDouble(0);
    }

    public static byte toByte(IMemory iMemory, int n2) {
        return iMemory.get(n2);
    }

    public static char toChar(IMemory iMemory, int n2) {
        return Bytes.newBuffer(iMemory, n2, 2).getChar(0);
    }

    public static short toShort(IMemory iMemory, int n2) {
        return Bytes.newBuffer(iMemory, n2, 2).getShort(0);
    }

    public static int toInt(IMemory iMemory, int n2) {
        return Bytes.newBuffer(iMemory, n2, 4).getInt(0);
    }

    public static long toLong(IMemory iMemory, int n2) {
        return Bytes.newBuffer(iMemory, n2, 8).getLong(0);
    }
}

