/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.converters;

import com.veryant.cobol.converters.Binary;
import com.veryant.cobol.converters.CMPXS;
import com.veryant.cobol.converters.Endianness;
import com.veryant.cobol.data.CobolBigDecimal;
import com.veryant.cobol.data.IMemory;

public class CMP5S
extends Binary {
    private static final boolean BIG_ENDIAN = Endianness.isBigEndian();

    public static int loadInt(IMemory iMemory, int n2, int n3) {
        if (BIG_ENDIAN) {
            return CMPXS.loadInt(iMemory, n2, n3);
        }
        int n4 = iMemory.get(n2 += --n3);
        while (n3 > 0) {
            n4 = n4 << 8 | iMemory.get(--n2) & 0xFF;
            --n3;
        }
        return n4;
    }

    public static long loadLong(IMemory iMemory, int n2, int n3) {
        if (BIG_ENDIAN) {
            return CMPXS.loadLong(iMemory, n2, n3);
        }
        long l2 = iMemory.get(n2 += --n3);
        while (n3 > 0) {
            l2 = l2 << 8 | (long)(iMemory.get(--n2) & 0xFF);
            --n3;
        }
        return l2;
    }

    public static CobolBigDecimal loadBigDecimal(IMemory iMemory, int n2, int n3, int n4) {
        return CMP5S.loadBigDecimal(iMemory, n2, n3, n4, true, BIG_ENDIAN);
    }

    public static void store(int n2, IMemory iMemory, int n3, int n4) {
        if (BIG_ENDIAN) {
            CMPXS.store(n2, iMemory, n3, n4);
            return;
        }
        while (n4 > 0) {
            iMemory.put(n3++, (byte)(n2 & 0xFF));
            n2 >>= 8;
            --n4;
        }
    }

    public static void store(long l2, IMemory iMemory, int n2, int n3) {
        if (BIG_ENDIAN) {
            CMPXS.store(l2, iMemory, n2, n3);
            return;
        }
        while (n3 > 0) {
            iMemory.put(n2++, (byte)(l2 & 0xFFL));
            l2 >>= 8;
            --n3;
        }
    }

    public static void store(CobolBigDecimal cobolBigDecimal, IMemory iMemory, int n2, int n3, int n4, int n5) {
        CMP5S.store(cobolBigDecimal, iMemory, n2, n3, n4, n5, true, BIG_ENDIAN);
    }
}

