/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.converters;

import com.veryant.cobol.converters.NumericDisplay;
import com.veryant.cobol.data.CobolBigDecimal;
import com.veryant.cobol.data.IMemory;

public class LAE
extends NumericDisplay {
    public static int loadInt(IMemory iMemory, int n2, int n3) {
        int n4 = n2 + n3;
        int n5 = iMemory.get(n2++) & 0xFF;
        int n6 = DIGITS[n5];
        while (n2 < n4) {
            n6 = n6 * 10 + (iMemory.get(n2++) & 0xF);
        }
        if (NEGATIVELY_SIGNED_TABLE[n5]) {
            return -n6;
        }
        return n6;
    }

    public static long loadLong(IMemory iMemory, int n2, int n3) {
        int n4 = n2 + n3;
        int n5 = iMemory.get(n2++) & 0xFF;
        long l2 = DIGITS[n5];
        while (n2 < n4) {
            l2 = l2 * 10L + (long)(iMemory.get(n2++) & 0xF);
        }
        if (NEGATIVELY_SIGNED_TABLE[n5]) {
            return -l2;
        }
        return l2;
    }

    public static CobolBigDecimal loadBigDecimal(IMemory iMemory, int n2, int n3, int n4) {
        byte[] byArray = new byte[n3];
        while (n3 > 1) {
            byArray[--n3] = (byte)(iMemory.get(n2 + n3) & 0xF);
        }
        int n5 = iMemory.get(n2) & 0xFF;
        byArray[0] = DIGITS[n5];
        return CobolBigDecimal.from(NEGATIVELY_SIGNED_TABLE[n5], byArray, n4);
    }

    public static void store(int n2, IMemory iMemory, int n3, int n4) {
        LAE.store((byte)48, n2, iMemory, n3, n4);
        if (n2 < 0) {
            iMemory.put(n3, NEG_EBCDIC_ASCII[iMemory.get(n3) - 48]);
        } else {
            iMemory.put(n3, POS_EBCDIC_ASCII[iMemory.get(n3) - 48]);
        }
    }

    public static void store(long l2, IMemory iMemory, int n2, int n3) {
        LAE.store((byte)48, l2, iMemory, n2, n3);
        if (l2 < 0L) {
            iMemory.put(n2, NEG_EBCDIC_ASCII[iMemory.get(n2) - 48]);
        } else {
            iMemory.put(n2, POS_EBCDIC_ASCII[iMemory.get(n2) - 48]);
        }
    }

    public static void store(CobolBigDecimal cobolBigDecimal, IMemory iMemory, int n2, int n3, int n4) {
        LAE.store((byte)48, cobolBigDecimal, iMemory, n2, n3, n4);
        if (cobolBigDecimal.isNegative()) {
            iMemory.put(n2, NEG_EBCDIC_ASCII[iMemory.get(n2) - 48]);
        } else {
            iMemory.put(n2, POS_EBCDIC_ASCII[iMemory.get(n2) - 48]);
        }
    }
}

