/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.converters;

import com.veryant.cobol.converters.Raw;
import com.veryant.cobol.data.CobolBigDecimal;
import com.veryant.cobol.data.IMemory;

public class PackedDecimal {
    protected static final int UNSIGNED_ANSI = 0;
    protected static final int SIGNED_ANSI = 1;
    protected static final int UNSIGNED_COMP6 = 2;
    protected static final int SIGNED_ACU = 3;
    protected static final int SIGNED_NCR = 4;
    private static final byte[] ENCODED_BYTES_COUNT;
    private static final byte[] ENCODED_BYTES_NO_SIGN_COUNT;
    protected static final byte PACKED_NO_SIGN = 15;
    protected static final byte PACKED_POS_SIGN = 12;
    protected static final byte PACKED_NEG_SIGN = 13;
    protected static final byte PACKED_NCR_POS_SIGN = 11;
    private static final int[] BYTES_MAP;
    private static final int CACHE_SIGN_SIZE = 100000;
    private static final int CACHE_SIGN_BYTES = 3;
    private static final byte[][] CACHE_SIGN;
    private static final int CACHE_NO_SIGN_SIZE = 10000;
    private static final int CACHE_NO_SIGN_BYTES = 2;
    private static final byte[][] CACHE_NO_SIGN;

    protected static int loadInt(IMemory iMemory, int n2, int n3, int n4) {
        if (n4 == 2) {
            int n5;
            int n6 = n2;
            int n7 = n2 + ENCODED_BYTES_NO_SIGN_COUNT[n3];
            do {
                n5 = iMemory.get(n6++) & 0xFF;
                if (n6 != n7) continue;
                return BYTES_MAP[n5];
            } while (n5 == 0);
            n5 = BYTES_MAP[n5];
            do {
                n5 *= 100;
                n5 += BYTES_MAP[iMemory.get(n6++) & 0xFF];
            } while (n6 != n7);
            return n5;
        }
        int n8 = 0;
        int n9 = ENCODED_BYTES_COUNT[n3];
        int n10 = 0;
        while (--n9 > 0 && (n8 = iMemory.get(n2++) & 0xFF) == 0) {
        }
        if (n9 > 0) {
            while (true) {
                n10 += BYTES_MAP[n8];
                if (--n9 == 0) {
                    n10 *= 10;
                    break;
                }
                n10 *= 100;
                n8 = iMemory.get(n2++) & 0xFF;
            }
        }
        n8 = iMemory.get(n2) & 0xFF;
        return n4 != 0 && (n8 & 0xF) == 13 ? -n10 : (n10 += n8 >> 4);
    }

    protected static long loadLong(IMemory iMemory, int n2, int n3, int n4) {
        if (n4 == 2) {
            long l2;
            int n5 = n2;
            int n6 = n2 + ENCODED_BYTES_NO_SIGN_COUNT[n3];
            do {
                l2 = iMemory.get(n5++) & 0xFF;
                if (n5 != n6) continue;
                return BYTES_MAP[(int)l2];
            } while (l2 == 0L);
            l2 = BYTES_MAP[(int)l2];
            do {
                l2 *= 100L;
                l2 += (long)BYTES_MAP[iMemory.get(n5++) & 0xFF];
            } while (n5 != n6);
            return l2;
        }
        int n7 = 0;
        int n8 = ENCODED_BYTES_COUNT[n3];
        long l3 = 0L;
        while (--n8 > 0 && (n7 = iMemory.get(n2++) & 0xFF) == 0) {
        }
        if (n8 > 0) {
            while (true) {
                l3 += (long)BYTES_MAP[n7];
                if (--n8 == 0) {
                    l3 *= 10L;
                    break;
                }
                l3 *= 100L;
                n7 = iMemory.get(n2++) & 0xFF;
            }
        }
        n7 = iMemory.get(n2) & 0xFF;
        return n4 != 0 && (n7 & 0xF) == 13 ? -l3 : (l3 += (long)(n7 >> 4));
    }

    protected static CobolBigDecimal loadBigDecimal(IMemory iMemory, int n2, int n3, int n4, int n5) {
        int n6 = n2;
        boolean bl = false;
        int n7 = n3 & 1;
        if (n5 == 2) {
            n6 += ENCODED_BYTES_NO_SIGN_COUNT[n3] - 1;
        } else {
            bl = n5 != 0 && (iMemory.get(n6 += ENCODED_BYTES_COUNT[n3] - 1) & 0xF) == 13;
            n7 ^= 1;
            if ((iMemory.get(n6) & 0xF0) == 0) {
                --n3;
                ++n4;
                --n6;
            }
        }
        while (n3 >= 2 && iMemory.get(n6) == 0) {
            n3 -= 2;
            n4 += 2;
            --n6;
        }
        if (n3 != 0 && (iMemory.get(n6) & 0xF) == 0) {
            --n3;
            ++n4;
        }
        if (n3 == 0) {
            return CobolBigDecimal.ZERO;
        }
        if (n7 != 0 && (iMemory.get(n2) & 0xF) == 0) {
            n7 = 0;
            ++n2;
            --n3;
        }
        if (n7 == 0) {
            while (iMemory.get(n2) == 0) {
                n3 -= 2;
                ++n2;
            }
            if ((iMemory.get(n2) & 0xF0) == 0) {
                n7 = 1;
                --n3;
            }
        }
        byte[] byArray = new byte[n3];
        n6 = 0;
        if (n7 != 0) {
            byArray[n6++] = (byte)(iMemory.get(n2) & 0xF);
            --n3;
            ++n2;
        }
        while (n3 >= 2) {
            byArray[n6++] = (byte)((iMemory.get(n2) & 0xF0) >>> 4);
            byArray[n6++] = (byte)(iMemory.get(n2) & 0xF);
            n3 -= 2;
            ++n2;
        }
        if (n3 != 0) {
            byArray[n6] = (byte)((iMemory.get(n2) & 0xF0) >>> 4);
        }
        return new CobolBigDecimal(bl, byArray, n4 + byArray.length);
    }

    protected static void store(int n2, IMemory iMemory, int n3, int n4, int n5) {
        int n6;
        byte[] byArray;
        boolean bl;
        int n7;
        byte by;
        byte by2;
        boolean bl2;
        boolean bl3 = bl2 = n2 < 0;
        if (bl2) {
            n2 = -n2;
        }
        switch (n5) {
            case 0: {
                by2 = ENCODED_BYTES_COUNT[n4];
                by = 15;
                break;
            }
            case 1: {
                by2 = ENCODED_BYTES_COUNT[n4];
                by = bl2 ? (byte)13 : 12;
                break;
            }
            case 2: {
                by2 = ENCODED_BYTES_NO_SIGN_COUNT[n4];
                by = 0;
                break;
            }
            case 3: {
                by2 = ENCODED_BYTES_COUNT[n4];
                by = bl2 ? (byte)13 : 15;
                break;
            }
            default: {
                by2 = ENCODED_BYTES_COUNT[n4];
                by = bl2 ? (byte)13 : 11;
            }
        }
        int n8 = n7 = n3 + by2;
        if (n5 == 2) {
            bl = n2 > 9999;
            byArray = CACHE_NO_SIGN[bl ? n2 % 10000 : n2];
            for (n6 = 0; n6 < 2 && n4 > 0; n4 -= 2, ++n6) {
                iMemory.put(--n8, byArray[n6]);
            }
        } else {
            ++n4;
            bl = n2 > 99999;
            byArray = CACHE_SIGN[bl ? n2 % 100000 : n2];
            for (n6 = 0; n6 < 3 && n4 > 0; n4 -= 2, ++n6) {
                iMemory.put(--n8, byArray[n6]);
            }
        }
        if (bl && n4 > 0) {
            n2 /= n5 == 2 ? 10000 : 100000;
            while (n2 > 0 && n4 > 0) {
                bl = n2 > 9999;
                byArray = CACHE_NO_SIGN[bl ? n2 % 10000 : n2];
                for (n6 = 0; n6 < 2 && n4 > 0; n4 -= 2, ++n6) {
                    iMemory.put(--n8, byArray[n6]);
                }
                n2 /= 10000;
            }
        }
        if (n4 == -1) {
            iMemory.and(n8, (byte)15);
        } else {
            while (n8 > n3) {
                iMemory.put(--n8, (byte)0);
            }
        }
        iMemory.or(n7 - 1, by);
    }

    protected static void store(long l2, IMemory iMemory, int n2, int n3, int n4) {
        int n5;
        byte[] byArray;
        boolean bl;
        int n6;
        byte by;
        byte by2;
        boolean bl2;
        boolean bl3 = bl2 = l2 < 0L;
        if (bl2) {
            l2 = -l2;
        }
        switch (n4) {
            case 0: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = 15;
                break;
            }
            case 1: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = bl2 ? (byte)13 : 12;
                break;
            }
            case 2: {
                by2 = ENCODED_BYTES_NO_SIGN_COUNT[n3];
                by = 0;
                break;
            }
            case 3: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = bl2 ? (byte)13 : 15;
                break;
            }
            default: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = bl2 ? (byte)13 : 11;
            }
        }
        int n7 = n6 = n2 + by2;
        if (n4 == 2) {
            bl = l2 > 9999L;
            byArray = CACHE_NO_SIGN[(int)(bl ? l2 % 10000L : l2)];
            for (n5 = 0; n5 < 2 && n3 > 0; n3 -= 2, ++n5) {
                iMemory.put(--n7, byArray[n5]);
            }
        } else {
            ++n3;
            bl = l2 > 99999L;
            byArray = CACHE_SIGN[(int)(bl ? l2 % 100000L : l2)];
            for (n5 = 0; n5 < 3 && n3 > 0; n3 -= 2, ++n5) {
                iMemory.put(--n7, byArray[n5]);
            }
        }
        if (bl && n3 > 0) {
            l2 /= n4 == 2 ? 10000L : 100000L;
            while (l2 > 0L && n3 > 0) {
                bl = l2 > 9999L;
                byArray = CACHE_NO_SIGN[(int)(bl ? l2 % 10000L : l2)];
                for (n5 = 0; n5 < 2 && n3 > 0; n3 -= 2, ++n5) {
                    iMemory.put(--n7, byArray[n5]);
                }
                l2 /= 10000L;
            }
        }
        if (n3 == -1) {
            iMemory.and(n7, (byte)15);
        } else {
            while (n7 > n2) {
                iMemory.put(--n7, (byte)0);
            }
        }
        iMemory.or(n6 - 1, by);
    }

    protected static void store(CobolBigDecimal cobolBigDecimal, IMemory iMemory, int n2, int n3, int n4, int n5) {
        byte by;
        byte by2;
        switch (n5) {
            case 0: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = 15;
                break;
            }
            case 1: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = cobolBigDecimal.isNegative() ? (byte)13 : 12;
                break;
            }
            case 2: {
                by2 = ENCODED_BYTES_NO_SIGN_COUNT[n3];
                by = 0;
                break;
            }
            case 3: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = cobolBigDecimal.isNegative() ? (byte)13 : 15;
                break;
            }
            default: {
                by2 = ENCODED_BYTES_COUNT[n3];
                by = cobolBigDecimal.isNegative() ? (byte)13 : 11;
            }
        }
        Raw.initMemory(iMemory, n2, by2, (byte)0);
        int n6 = n2 + by2 - 1;
        byte[] byArray = cobolBigDecimal.getMantissa();
        int n7 = cobolBigDecimal.getDigits();
        int n8 = cobolBigDecimal.getExp();
        if (!cobolBigDecimal.isZero() && n8 > n4 && n8 - n7 < n4 + n3) {
            int n9;
            int n10 = n3 & 1;
            if (n5 != 2) {
                n10 ^= 1;
            }
            if (n4 + n3 > n8) {
                n9 = n4 + n3 - n8;
                n3 -= n9;
                n2 += (n9 + n10) / 2;
                n10 = n9 + n10 & 1;
            }
            n9 = n4 + n3 - Math.max(n8 - n7, n4);
            int n11 = n8 - (n4 + n3);
            if (n10 != 0) {
                iMemory.put(n2++, byArray[n11++]);
                --n9;
            }
            while (n9 > 1) {
                iMemory.put(n2++, (byte)((byArray[n11] << 4) + byArray[n11 + 1]));
                n11 += 2;
                n9 -= 2;
            }
            if (n9 != 0) {
                iMemory.put(n2, (byte)(byArray[n11] << 4));
            }
        }
        iMemory.or(n6, by);
    }

    public static int digitsToBytes(int n2) {
        return ENCODED_BYTES_COUNT[n2];
    }

    public static int digitsToBytesNoSign(int n2) {
        return ENCODED_BYTES_NO_SIGN_COUNT[n2];
    }

    static {
        byte by;
        int n2;
        int n3;
        int n4;
        ENCODED_BYTES_COUNT = new byte[]{0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20};
        ENCODED_BYTES_NO_SIGN_COUNT = new byte[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19};
        BYTES_MAP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 0, 0, 0, 0, 0, 0, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 0, 0, 0, 0, 0, 0, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 0, 0, 0, 0, 0, 0, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 0, 0, 0, 0, 0, 0, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 0, 0, 0, 0, 0, 0, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 0, 0, 0, 0, 0, 0, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 0, 0, 0, 0, 0, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 0, 0, 0, 0, 0, 0, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        CACHE_SIGN = new byte[100000][3];
        CACHE_NO_SIGN = new byte[10000][2];
        for (n4 = 0; n4 < 100000; ++n4) {
            n3 = n4 * 10;
            for (n2 = 0; n2 < 3; ++n2) {
                by = (byte)(n3 % 10);
                by = (byte)(by | (n3 /= 10) % 10 << 4);
                n3 /= 10;
                PackedDecimal.CACHE_SIGN[n4][n2] = by;
            }
        }
        for (n4 = 0; n4 < 10000; ++n4) {
            n3 = n4;
            for (n2 = 0; n2 < 2; ++n2) {
                by = (byte)(n3 % 10);
                by = (byte)(by | (n3 /= 10) % 10 << 4);
                n3 /= 10;
                PackedDecimal.CACHE_NO_SIGN[n4][n2] = by;
            }
        }
    }
}

