/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.converters;

import com.veryant.cobol.converters.CharsetConstants;
import com.veryant.cobol.data.IMemory;
import com.veryant.cobol.exceptions.COBOLRuntimeException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;

public class Raw
extends CharsetConstants {
    private static final int PREALLOCATED_SIZE = 1024;
    private static final byte[] NULLS = new byte[1024];
    private static final byte[] ASCII_SPACES = Raw.allocMemory(1024, (byte)32);
    private static final byte[] EBCDIC_SPACES = Raw.allocMemory(1024, (byte)64);

    public static byte[] allocMemory(int n2, byte by) {
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, by);
        return byArray;
    }

    public static void copyMemory(IMemory iMemory, int n2, IMemory iMemory2, int n3, int n4) {
        iMemory2.copy(iMemory, n2, n3, n4);
    }

    public static void copyMemory(IMemory iMemory, int n2, int n3, IMemory iMemory2, int n4, int n5) {
        iMemory2.copy(iMemory, n2, n4, n5);
    }

    public static void initMemory(IMemory iMemory, int n2, int n3, byte by) {
        byte[] byArray;
        switch (by) {
            case 32: {
                byArray = ASCII_SPACES;
                break;
            }
            case 64: {
                byArray = EBCDIC_SPACES;
                break;
            }
            case 0: {
                byArray = NULLS;
                break;
            }
            default: {
                while (n2 < n3) {
                    iMemory.put(n2++, by);
                }
                return;
            }
        }
        while (n3 > 0) {
            int n4 = n3;
            if (n4 > 1024) {
                n4 = 1024;
            }
            iMemory.copy(byArray, 0, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public static void initMemory(Class<?> clazz, IMemory iMemory, String string) {
        String string2 = clazz.getName();
        int n2 = string2.lastIndexOf(46);
        if (n2 > 0) {
            string2 = string2.substring(n2 + 1);
        }
        string2 = string2 + "." + string;
        try {
            URL uRL = clazz.getResource(string2);
            if (uRL == null) {
                throw new COBOLRuntimeException(String.format("Can't read resource file: %s", string2));
            }
            byte[] byArray = Files.readAllBytes(Paths.get(uRL.toURI()));
            if (byArray.length != iMemory.getSize()) {
                throw new COBOLRuntimeException(String.format("Resource file size mismatch: %s", string2));
            }
            iMemory.copy(byArray, 0, 0, byArray.length);
        }
        catch (IOException | URISyntaxException exception) {
            throw new COBOLRuntimeException(String.format("Can't read resource file: %s", exception.getMessage()));
        }
    }
}

