/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.data;

import com.veryant.cobol.data.IMemory;
import java.util.Arrays;

public class CobolBigDecimal {
    public static final int MAX_DIGITS = 38;
    public static final int MAX_REGISTER_SIZE = 40;
    public static final int HALF_REGISTER_SIZE = 20;
    public static final int MAX_ULONG_DIGITS = 20;
    public static final int MAX_UINT_DIGITS = 10;
    public static final int MAX_LONG_DIGITS = 18;
    private static final int WORD_DIGITS = 8;
    private static final int WORD_ROUNDER = 7;
    private static final int WORD_DIV = 3;
    private static final long WORD_SHIFTER = 100000000L;
    private static final int[] WORD_ALIGNER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000};
    private static final int NO_ALIGN = -1;
    public static final CobolBigDecimal ZERO = new CobolBigDecimal(null, 0);
    private static final CobolBigDecimal OVERFLOW = new CobolBigDecimal(null, 0);
    private static final byte[] ONE_DIGIT = new byte[]{1};
    public static final CobolBigDecimal POSITIVE_ONE = new CobolBigDecimal(false, ONE_DIGIT, 1);
    public static final CobolBigDecimal NEGATIVE_ONE = new CobolBigDecimal(true, ONE_DIGIT, 1);
    private static final byte[] TWO_DIGIT = new byte[]{2};
    private static final CobolBigDecimal POSITIVE_TWO = new CobolBigDecimal(false, TWO_DIGIT, 1);
    private static final CobolBigDecimal TWO_THIRDS = new CobolBigDecimal(false, new byte[]{6, 6, 6}, 0);
    private static final byte[] LOGN_TEN_DIGITS = new byte[]{2, 3, 0, 2, 5, 8, 5, 0, 9, 2, 9, 9, 4, 0, 4, 5, 6, 8, 4, 0, 1, 7, 9, 9, 1, 4, 5, 4, 6, 8, 4, 3, 6, 4, 2, 0, 7, 6, 0, 1, 1};
    private static final CobolBigDecimal LOGN_TEN = new CobolBigDecimal(false, LOGN_TEN_DIGITS, 1);
    private static final byte[] LOGN_HALF_DIGITS = new byte[]{6, 9, 3, 1, 4, 7, 1, 8, 0, 5, 5, 9, 9, 4, 5, 3, 0, 9, 4, 1, 7, 2, 3, 2, 1, 2, 1, 4, 5, 8, 1, 7, 6, 5, 6, 8, 0, 7, 5, 5};
    private static final CobolBigDecimal LOGN_HALF = new CobolBigDecimal(true, LOGN_HALF_DIGITS, 0);
    private static final byte[] E_DIGITS = new byte[]{2, 7, 1, 8, 2, 8, 1, 8, 2, 8, 4, 5, 9, 0, 4, 5, 2, 3, 5, 3, 6, 0, 2, 8, 7, 4, 7, 1, 3, 5, 2, 6, 6, 2, 4, 9, 7, 7, 5, 7, 2, 5};
    private static final CobolBigDecimal E = new CobolBigDecimal(false, E_DIGITS, 1);
    private boolean negative;
    private byte[] mantissa;
    private int digits;
    private int exp;

    public CobolBigDecimal(byte[] byArray, int n2) {
        this(false, byArray, n2);
    }

    public CobolBigDecimal(boolean bl, byte[] byArray, int n2) {
        if (byArray != null && byArray.length > 0) {
            this.negative = bl;
            this.mantissa = byArray;
            this.digits = byArray.length;
            this.exp = n2;
        }
    }

    public byte[] getMantissa() {
        if (this.isZero()) {
            return new byte[]{0};
        }
        byte[] byArray = new byte[this.digits];
        System.arraycopy(this.mantissa, 0, byArray, 0, this.digits);
        return byArray;
    }

    public int getDigits() {
        return this.digits;
    }

    public int getExp() {
        return this.exp;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public boolean isZero() {
        return this.digits == 0;
    }

    public boolean isOne() {
        return this.exp == 1 && this.digits == 1 && this.mantissa[0] == 1;
    }

    public boolean isPositiveOne() {
        return !this.negative && this.isOne();
    }

    public boolean isPowerOfTen() {
        return this.digits == 1 && this.mantissa[0] == 1;
    }

    public boolean sizeError() {
        return this == OVERFLOW;
    }

    public boolean sizeError(int n2) {
        return this.sizeError() || this.exp > n2;
    }

    public static boolean sizeError(float f2) {
        return (double)f2 == Double.NEGATIVE_INFINITY || (double)f2 == Double.POSITIVE_INFINITY || Float.isNaN(f2);
    }

    public static boolean sizeError(double d2) {
        return d2 == Double.NEGATIVE_INFINITY || d2 == Double.POSITIVE_INFINITY || Double.isNaN(d2);
    }

    public CobolBigDecimal negate() {
        return this.isZero() ? this : new CobolBigDecimal(!this.negative, this.mantissa, this.exp);
    }

    public CobolBigDecimal abs() {
        return this.negative ? this.negate() : this;
    }

    public CobolBigDecimal add(CobolBigDecimal cobolBigDecimal) {
        if (cobolBigDecimal.sizeError()) {
            return cobolBigDecimal;
        }
        if (cobolBigDecimal.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return cobolBigDecimal;
        }
        if (this.negative == cobolBigDecimal.isNegative()) {
            return this.absAdd(cobolBigDecimal);
        }
        return this.absSubtract(cobolBigDecimal);
    }

    public CobolBigDecimal subtract(CobolBigDecimal cobolBigDecimal) {
        if (cobolBigDecimal.sizeError()) {
            return cobolBigDecimal;
        }
        if (cobolBigDecimal.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return cobolBigDecimal.negate();
        }
        if (this.negative == cobolBigDecimal.isNegative()) {
            return this.absSubtract(cobolBigDecimal);
        }
        return this.absAdd(cobolBigDecimal);
    }

    public CobolBigDecimal multiply(CobolBigDecimal cobolBigDecimal, int n2) {
        if (cobolBigDecimal.sizeError()) {
            return cobolBigDecimal;
        }
        if (cobolBigDecimal.isZero() || this.isZero()) {
            return ZERO;
        }
        return this.alignedMultiply(cobolBigDecimal, n2);
    }

    public CobolBigDecimal divide(CobolBigDecimal cobolBigDecimal, int n2, boolean bl) {
        return this.divideWithReminder(cobolBigDecimal, n2, bl).getQuotient();
    }

    public DivResult divideWithReminder(CobolBigDecimal cobolBigDecimal, int n2, boolean bl) {
        if (cobolBigDecimal.sizeError()) {
            return new DivResult(cobolBigDecimal, cobolBigDecimal);
        }
        if (cobolBigDecimal.isZero()) {
            return new DivResult(OVERFLOW, OVERFLOW);
        }
        if (this.isZero()) {
            return new DivResult(ZERO, ZERO);
        }
        return this.alignedDivide(cobolBigDecimal, n2, bl);
    }

    public CobolBigDecimal power(CobolBigDecimal cobolBigDecimal) {
        if (cobolBigDecimal.sizeError()) {
            return cobolBigDecimal;
        }
        if (cobolBigDecimal.exp > 20) {
            return this.exp <= 0 ? ZERO : OVERFLOW;
        }
        if (this.isPositiveOne() || cobolBigDecimal.isPositiveOne()) {
            return this;
        }
        if (this.isZero()) {
            if (cobolBigDecimal.negative || cobolBigDecimal.isZero()) {
                return OVERFLOW;
            }
            return ZERO;
        }
        if (cobolBigDecimal.isZero()) {
            return POSITIVE_ONE;
        }
        if (cobolBigDecimal.exp - cobolBigDecimal.digits >= 0) {
            CobolBigDecimal cobolBigDecimal2 = this.power(cobolBigDecimal.getLong(0, 0, true));
            return cobolBigDecimal2.round(cobolBigDecimal2.exp - 38);
        }
        if (this.negative) {
            return OVERFLOW;
        }
        CobolBigDecimal cobolBigDecimal3 = this.power(cobolBigDecimal.integer().getLong(0, 0, true)).multiply(cobolBigDecimal.decimals().multiply(this.log(), Integer.MIN_VALUE).antilog(), Integer.MIN_VALUE);
        return cobolBigDecimal3.round(cobolBigDecimal3.exp - 38);
    }

    private CobolBigDecimal power(long l2) {
        if (l2 == 0L) {
            return POSITIVE_ONE;
        }
        boolean bl = l2 < 0L;
        l2 = Math.abs(l2);
        CobolBigDecimal cobolBigDecimal = POSITIVE_ONE;
        CobolBigDecimal cobolBigDecimal2 = this;
        while (true) {
            int n2 = (int)l2 & 1;
            l2 /= 2L;
            if (n2 != 0) {
                cobolBigDecimal = cobolBigDecimal.multiply(cobolBigDecimal2, Integer.MIN_VALUE);
                if (l2 == 0L) {
                    if (bl) {
                        cobolBigDecimal = POSITIVE_ONE.divide(cobolBigDecimal, Integer.MIN_VALUE, false);
                    }
                    return cobolBigDecimal;
                }
            }
            cobolBigDecimal2 = cobolBigDecimal2.multiply(cobolBigDecimal2, Integer.MIN_VALUE);
        }
    }

    private CobolBigDecimal integer() {
        if (!this.isZero() && this.exp - this.digits < 0) {
            if (this.exp <= 0) {
                return ZERO;
            }
            int n2 = this.exp;
            while (this.mantissa[n2 - 1] == 0) {
                --n2;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.mantissa, 0, byArray, 0, n2);
            return new CobolBigDecimal(this.negative, byArray, this.exp);
        }
        return this;
    }

    private CobolBigDecimal decimals() {
        if (!this.isZero() && this.exp > 0) {
            if (this.exp - this.digits >= 0) {
                return ZERO;
            }
            int n2 = 0;
            while (this.mantissa[this.exp - n2] == 0) {
                --n2;
            }
            int n3 = this.exp - n2;
            int n4 = this.digits - n3;
            byte[] byArray = new byte[n4];
            System.arraycopy(this.mantissa, n3, byArray, 0, n4);
            return new CobolBigDecimal(this.negative, byArray, n2);
        }
        return this;
    }

    private CobolBigDecimal log() {
        if (this.isPowerOfTen()) {
            return LOGN_TEN.multiply(CobolBigDecimal.from(this.exp - 1, 0), Integer.MIN_VALUE);
        }
        CobolBigDecimal cobolBigDecimal = new CobolBigDecimal(this.negative, this.mantissa, 0);
        CobolBigDecimal cobolBigDecimal2 = LOGN_TEN.multiply(CobolBigDecimal.from(this.exp, 0), Integer.MIN_VALUE);
        while (cobolBigDecimal.compare(TWO_THIRDS) < 0) {
            cobolBigDecimal = cobolBigDecimal.multiply(POSITIVE_TWO, Integer.MIN_VALUE);
            cobolBigDecimal2 = cobolBigDecimal2.add(LOGN_HALF);
        }
        if (cobolBigDecimal.compare(POSITIVE_ONE) == 0) {
            return cobolBigDecimal2;
        }
        CobolBigDecimal cobolBigDecimal3 = cobolBigDecimal.subtract(POSITIVE_ONE);
        CobolBigDecimal cobolBigDecimal4 = cobolBigDecimal.add(POSITIVE_ONE);
        CobolBigDecimal cobolBigDecimal5 = cobolBigDecimal3.multiply(cobolBigDecimal3, Integer.MIN_VALUE);
        CobolBigDecimal cobolBigDecimal6 = cobolBigDecimal4.multiply(cobolBigDecimal4, Integer.MIN_VALUE);
        CobolBigDecimal cobolBigDecimal7 = ZERO;
        int n2 = 0;
        while (true) {
            CobolBigDecimal cobolBigDecimal8 = cobolBigDecimal3.divide(cobolBigDecimal4.multiply(CobolBigDecimal.from(2 * n2 + 1, 0), Integer.MIN_VALUE), Integer.MIN_VALUE, true);
            cobolBigDecimal7 = cobolBigDecimal7.add(cobolBigDecimal8);
            if (cobolBigDecimal8.exp <= -44) {
                cobolBigDecimal7 = cobolBigDecimal7.multiply(POSITIVE_TWO, Integer.MIN_VALUE);
                cobolBigDecimal7 = cobolBigDecimal7.add(cobolBigDecimal2);
                return cobolBigDecimal7;
            }
            cobolBigDecimal3 = cobolBigDecimal3.multiply(cobolBigDecimal5, Integer.MIN_VALUE);
            cobolBigDecimal4 = cobolBigDecimal4.multiply(cobolBigDecimal6, Integer.MIN_VALUE);
            ++n2;
        }
    }

    private CobolBigDecimal antilog() {
        CobolBigDecimal cobolBigDecimal = this.round(0);
        CobolBigDecimal cobolBigDecimal2 = this.subtract(cobolBigDecimal);
        CobolBigDecimal cobolBigDecimal3 = cobolBigDecimal2.multiply(cobolBigDecimal2, Integer.MIN_VALUE);
        CobolBigDecimal cobolBigDecimal4 = POSITIVE_ONE;
        CobolBigDecimal cobolBigDecimal5 = cobolBigDecimal2.add(POSITIVE_ONE);
        CobolBigDecimal cobolBigDecimal6 = POSITIVE_ONE;
        CobolBigDecimal cobolBigDecimal7 = cobolBigDecimal5;
        CobolBigDecimal cobolBigDecimal8 = cobolBigDecimal5;
        int n2 = 2;
        while (cobolBigDecimal7.digits != 0 && cobolBigDecimal8.exp - cobolBigDecimal7.exp <= 42) {
            cobolBigDecimal4 = cobolBigDecimal4.multiply(cobolBigDecimal3, Integer.MIN_VALUE);
            cobolBigDecimal5 = cobolBigDecimal5.add(POSITIVE_TWO);
            cobolBigDecimal6 = cobolBigDecimal6.multiply(CobolBigDecimal.from(n2 * (n2 + 1), 0), Integer.MIN_VALUE);
            cobolBigDecimal7 = cobolBigDecimal4.multiply(cobolBigDecimal5, Integer.MIN_VALUE).divide(cobolBigDecimal6, Integer.MIN_VALUE, true);
            cobolBigDecimal8 = cobolBigDecimal8.add(cobolBigDecimal7);
            n2 += 2;
        }
        return cobolBigDecimal8.multiply(E.power(cobolBigDecimal.getLong(0, 0, true)), Integer.MIN_VALUE);
    }

    public CobolBigDecimal round(int n2) {
        if (!this.isZero() && this.exp - this.digits < n2) {
            if (this.exp < n2) {
                return ZERO;
            }
            CobolBigDecimal cobolBigDecimal = this.add(CobolBigDecimal.from(5, n2 - 1));
            int n3 = cobolBigDecimal.exp - n2;
            if (cobolBigDecimal.exp <= n2) {
                return ZERO;
            }
            while (cobolBigDecimal.mantissa[n3 - 1] == 0) {
                --n3;
            }
            return new CobolBigDecimal(cobolBigDecimal.isNegative(), Arrays.copyOf(cobolBigDecimal.mantissa, n3), cobolBigDecimal.exp);
        }
        return this;
    }

    private CobolBigDecimal absAdd(CobolBigDecimal cobolBigDecimal) {
        int n2;
        CobolBigDecimal cobolBigDecimal2;
        CobolBigDecimal cobolBigDecimal3;
        int n3 = cobolBigDecimal.exp - this.exp;
        if (n3 < 0) {
            cobolBigDecimal3 = this;
            cobolBigDecimal2 = cobolBigDecimal;
            n3 = -n3;
        } else {
            cobolBigDecimal3 = cobolBigDecimal;
            cobolBigDecimal2 = this;
        }
        int n4 = cobolBigDecimal3.exp;
        int n5 = Math.max(cobolBigDecimal3.digits, n3 + cobolBigDecimal2.digits);
        byte[] byArray = new byte[n5 + 1];
        System.arraycopy(cobolBigDecimal3.mantissa, 0, byArray, 0, cobolBigDecimal3.digits);
        if (n3 >= cobolBigDecimal3.digits) {
            System.arraycopy(cobolBigDecimal2.mantissa, 0, byArray, n3, cobolBigDecimal2.digits);
        } else {
            int n6;
            n2 = n5 - cobolBigDecimal3.digits;
            if (n2 > 0) {
                System.arraycopy(cobolBigDecimal2.mantissa, cobolBigDecimal2.digits - n2, byArray, cobolBigDecimal3.digits, n2);
            }
            byte by = 0;
            int n7 = cobolBigDecimal2.digits - n2;
            int n8 = n3 + n7;
            while (n7 > 0) {
                n6 = byArray[--n8] + cobolBigDecimal2.mantissa[--n7];
                if ((n6 += by) < 10) {
                    by = 0;
                } else {
                    by = 1;
                    n6 -= 10;
                }
                byArray[n8] = (byte)n6;
            }
            while (by != 0 && n8 > 0) {
                if ((n6 = byArray[--n8] + by) < 10) {
                    by = 0;
                } else {
                    by = 1;
                    n6 = 0;
                }
                byArray[n8] = (byte)n6;
            }
            if (by != 0) {
                System.arraycopy(byArray, 0, byArray, 1, n5);
                ++n4;
                byArray[0] = 1;
            }
        }
        n2 = Math.min(byArray.length, 40);
        while (byArray[n2 - 1] == 0) {
            --n2;
        }
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        return new CobolBigDecimal(this.negative, byArray, n4);
    }

    private CobolBigDecimal absSubtract(CobolBigDecimal cobolBigDecimal) {
        int n2;
        int n3;
        CobolBigDecimal cobolBigDecimal2;
        CobolBigDecimal cobolBigDecimal3;
        boolean bl = this.negative;
        int n4 = cobolBigDecimal.exp - this.exp;
        if (n4 > 0) {
            cobolBigDecimal3 = cobolBigDecimal;
            cobolBigDecimal2 = this;
            bl = !bl;
        } else {
            cobolBigDecimal3 = this;
            cobolBigDecimal2 = cobolBigDecimal;
            n4 = -n4;
        }
        int n5 = cobolBigDecimal3.exp;
        int n6 = Math.max(cobolBigDecimal3.digits, n4 + cobolBigDecimal2.digits);
        byte[] byArray = new byte[n6];
        System.arraycopy(cobolBigDecimal3.mantissa, 0, byArray, 0, cobolBigDecimal3.digits);
        byte by = 0;
        int n7 = cobolBigDecimal2.digits;
        int n8 = n4 + n7;
        while (n7 > 0) {
            n3 = byArray[--n8] - cobolBigDecimal2.mantissa[--n7];
            if ((n3 -= by) < 0) {
                n3 += 10;
                by = 1;
            } else {
                by = 0;
            }
            byArray[n8] = (byte)n3;
        }
        while (by != 0 && n8 > 0) {
            if ((n3 = byArray[--n8] - by) < 0) {
                n3 += 10;
            } else {
                by = 0;
            }
            byArray[n8] = (byte)n3;
        }
        while (n6 != 0 && byArray[n6 - 1] == 0) {
            --n6;
        }
        if (by != 0) {
            byArray[n6 - 1] = (byte)(10 - byArray[n6 - 1]);
            for (n2 = n6 - 2; n2 >= 0; --n2) {
                byArray[n2] = (byte)(9 - byArray[n2]);
            }
            while (n6 != 0 && byArray[n6 - 1] == 0) {
                --n6;
            }
            bl = !bl;
        }
        for (n2 = 0; n2 < n6 && byArray[n2] == 0; ++n2) {
        }
        n5 -= n2;
        if ((n6 -= n2) == 0) {
            return ZERO;
        }
        if (n6 != byArray.length) {
            byte[] byArray2 = new byte[n6];
            System.arraycopy(byArray, n2, byArray2, 0, n6);
            byArray = byArray2;
        }
        return new CobolBigDecimal(bl, byArray, n5);
    }

    private CobolBigDecimal alignedMultiply(CobolBigDecimal cobolBigDecimal, int n2) {
        int n3;
        int n4;
        int n5 = this.exp + cobolBigDecimal.exp;
        if (this.isPowerOfTen()) {
            return new CobolBigDecimal(cobolBigDecimal.negative != this.negative, cobolBigDecimal.mantissa, n5 - 1);
        }
        if (cobolBigDecimal.isPowerOfTen()) {
            return new CobolBigDecimal(this.negative != cobolBigDecimal.negative, this.mantissa, n5 - 1);
        }
        int n6 = this.digits + cobolBigDecimal.digits;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        int n8 = this.digits - 1;
        int n9 = cobolBigDecimal.digits - 1;
        while (n9 >= 0) {
            n4 = n8;
            for (n3 = n9; n4 < this.digits && n3 >= 0; ++n4, --n3) {
                n7 += this.mantissa[n4] * cobolBigDecimal.mantissa[n3];
            }
            byArray[--n6] = (byte)(n7 % 10);
            n7 /= 10;
            if (n8 > 0) {
                --n8;
                continue;
            }
            --n9;
        }
        byArray[0] = (byte)n7;
        n4 = n5 - Math.max(n2, n5 - byArray.length);
        n3 = 0;
        if (n7 == 0) {
            n3 = 1;
            --n4;
            --n5;
        }
        n4 = Math.min(n4, 40);
        for (int i2 = n4 + n3 - 1; i2 >= n3 && byArray[i2] == 0; --i2) {
            --n4;
        }
        if (n3 != 0 || n4 != byArray.length) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n3, byArray2, 0, n4);
            byArray = byArray2;
        }
        return new CobolBigDecimal(this.negative != cobolBigDecimal.negative, byArray, n5);
    }

    private DivResult alignedDivide(CobolBigDecimal cobolBigDecimal, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.exp - cobolBigDecimal.exp + (bl ? 1 : 0) < n2) {
            return new DivResult(ZERO, this);
        }
        int n7 = n2 == Integer.MIN_VALUE ? 7 : this.exp - cobolBigDecimal.exp - n2 & 7;
        int n8 = 8 - n7;
        int n9 = n2 == Integer.MIN_VALUE ? 11 : this.exp - cobolBigDecimal.exp - n2 + 7 + n8 >> 3;
        int n10 = this.digits + 7 + n8 >> 3;
        int n11 = cobolBigDecimal.digits + 7 >> 3;
        int n12 = Math.max(n11, n10 - n9);
        boolean bl2 = false;
        int[] nArray = new int[23];
        int[] nArray2 = new int[n11];
        int[] nArray3 = new int[n9];
        CobolBigDecimal.convert(this.mantissa, n7, nArray);
        CobolBigDecimal.convert(cobolBigDecimal.mantissa, -1, nArray2);
        if (n11 == 1) {
            CobolBigDecimal.oneWordDivide(nArray, nArray2[0], nArray3);
            if (bl) {
                bl2 = nArray[n9] * 2 >= nArray2[0];
            }
        } else {
            n6 = 100000000 / (nArray2[0] + 1);
            if (n6 > 1) {
                CobolBigDecimal.normalize(nArray2, n11, n6);
                CobolBigDecimal.normalize(nArray, n10, n6);
            }
            CobolBigDecimal.multiWordDivide(nArray, nArray2, nArray3);
            if (bl) {
                n5 = 0;
                n4 = 0;
                for (n3 = 0; n5 == 0 && n3 <= n10; n5 -= nArray[n10 + n3], ++n3) {
                    n5 = n4 + nArray2[n3] >> 1;
                    n4 = (nArray2[n3] & 1) != 0 ? 100000000 : 0;
                }
                boolean bl3 = bl2 = n5 < 0;
            }
            if (n6 > 1) {
                CobolBigDecimal.unnormalize(nArray, n9, n12, n6);
            }
        }
        n6 = this.exp - cobolBigDecimal.exp + n8;
        n5 = this.exp + n8 - n9 * 8;
        n4 = n9;
        if (bl2) {
            n3 = 1;
            for (int i2 = n9 - 1; i2 >= 0; --i2) {
                int n13 = i2;
                nArray3[n13] = nArray3[n13] + 1;
                if ((long)nArray3[n13] != 100000000L) {
                    n3 = 0;
                    break;
                }
                nArray3[i2] = 0;
            }
            if (n3 != 0) {
                nArray3[0] = 1;
                n4 = 1;
                n6 += 8;
            }
        }
        return new DivResult(CobolBigDecimal.from(this.negative != cobolBigDecimal.negative, nArray3, 0, n4, n6), CobolBigDecimal.from(this.negative, nArray, n9, n12, n5));
    }

    private static void multiWordDivide(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i2 = 0; i2 != nArray3.length; ++i2) {
            long l2;
            int n2;
            long l3;
            long l4 = (long)nArray[i2] * 100000000L + (long)nArray[i2 + 1];
            long l5 = l4 - l3 * (long)nArray2[0];
            for (l3 = l4 / (long)nArray2[0]; l3 >= 100000000L || l3 * (long)nArray2[1] > 100000000L * l5 + (long)nArray[i2 + 2]; --l3) {
                if ((l5 += (long)nArray2[0]) < 100000000L) continue;
            }
            l4 = 0L;
            for (n2 = nArray2.length; n2 > 0; --n2) {
                long l6 = (long)nArray[n2 + i2] + l4 - l3 * (long)nArray2[n2 - 1];
                l4 = l6 / 100000000L;
                l2 = l6 % 100000000L;
                if (l2 < 0L) {
                    l2 += 100000000L;
                    --l4;
                }
                nArray[n2 + i2] = (int)l2;
            }
            int n3 = i2;
            nArray[n3] = (int)((long)nArray[n3] + l4);
            if (nArray[i2] < 0) {
                --l3;
                int n4 = i2;
                nArray[n4] = (int)((long)nArray[n4] + 100000000L);
                l4 = 0L;
                for (n2 = nArray2.length; n2 > 0; --n2) {
                    l2 = (long)(nArray[i2 + n2] + nArray2[n2 - 1]) + l4;
                    nArray[i2 + n2] = (int)(l2 % 100000000L);
                    l4 = l2 / 100000000L;
                }
            }
            nArray3[i2] = (int)l3;
        }
    }

    private static void oneWordDivide(int[] nArray, int n2, int[] nArray2) {
        int n3 = nArray[0];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            long l2 = (long)n3 * 100000000L + (long)nArray[i2 + 1];
            nArray2[i2] = (int)(l2 / (long)n2);
            n3 = (int)(l2 % (long)n2);
        }
        nArray[nArray2.length] = n3;
    }

    private static void normalize(int[] nArray, int n2, int n3) {
        long l2 = 0L;
        while (n2 > 0) {
            long l3 = (long)nArray[--n2] * (long)n3 + l2;
            nArray[n2] = (int)(l3 % 100000000L);
            l2 = l3 / 100000000L;
        }
    }

    private static void unnormalize(int[] nArray, int n2, int n3, int n4) {
        long l2 = 0L;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            long l3 = l2 * 100000000L + (long)nArray[i2];
            nArray[i2] = (int)(l3 / (long)n4);
            l2 = l3 % (long)n4;
        }
    }

    private static void convert(byte[] byArray, int n2, int[] nArray) {
        int n3;
        int n4 = n3 = byArray.length;
        if (n2 > -1) {
            n4 += 8 - n2;
        }
        n4 >>= 3;
        if (n2 > n3) {
            int n5 = 0;
            while (n5 < n3) {
                nArray[0] = nArray[0] * 10 + byArray[n5++];
            }
            nArray[0] = nArray[0] * WORD_ALIGNER[n2 - n5];
        } else {
            int n6 = 0;
            int n7 = 0;
            if (n2 > -1) {
                while (n6 < n2) {
                    nArray[0] = nArray[0] * 10 + byArray[n6++];
                }
                n7 = 1;
            }
            while (n7 < n4) {
                nArray[n7++] = byArray[n6++] * 10000000 + byArray[n6++] * 1000000 + byArray[n6++] * 100000 + byArray[n6++] * 10000 + byArray[n6++] * 1000 + byArray[n6++] * 100 + byArray[n6++] * 10 + byArray[n6++];
            }
            if (n6 != n3) {
                int n8 = 8;
                while (n6 < n3) {
                    nArray[n7] = nArray[n7] * 10 + byArray[n6++];
                    --n8;
                }
                int n9 = n7;
                nArray[n9] = nArray[n9] * WORD_ALIGNER[n8];
            }
        }
    }

    public int compare(CobolBigDecimal cobolBigDecimal) {
        if (this.negative != cobolBigDecimal.negative) {
            return this.negative ? -1 : 1;
        }
        if (this.isZero()) {
            return cobolBigDecimal.isZero() ? 0 : -1;
        }
        if (cobolBigDecimal.isZero()) {
            return 1;
        }
        return this.negative ? -this.absCompare(cobolBigDecimal) : this.absCompare(cobolBigDecimal);
    }

    private int absCompare(CobolBigDecimal cobolBigDecimal) {
        if (this.exp != cobolBigDecimal.exp) {
            return this.exp - cobolBigDecimal.exp;
        }
        int n2 = Math.min(this.digits, cobolBigDecimal.digits);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.mantissa[i2] - cobolBigDecimal.mantissa[i2];
            if (n3 == 0) continue;
            return n3;
        }
        return this.digits - cobolBigDecimal.digits;
    }

    public static CobolBigDecimal from(boolean bl, byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = byArray.length;
        if (n4 > 38) {
            n3 = n4 - 38;
            n4 = 38;
        }
        return CobolBigDecimal.from(bl, byArray, n3, n4, n2);
    }

    public static CobolBigDecimal from(boolean bl, byte[] byArray, int n2, int n3, int n4) {
        int n5 = n2 + n3;
        while (n3 != 0 && (byArray[--n5] & 0xF) == 0) {
            ++n4;
            --n3;
        }
        if (n3 == 0) {
            return ZERO;
        }
        while ((byArray[n2] & 0xF) == 0) {
            ++n2;
            --n3;
        }
        byte[] byArray2 = new byte[n3];
        while (n3 != 0) {
            byArray2[--n3] = (byte)(byArray[n2 + n3] & 0xF);
        }
        return new CobolBigDecimal(bl, byArray2, n4 + byArray2.length);
    }

    public static CobolBigDecimal from(boolean bl, IMemory iMemory, int n2, int n3, int n4) {
        int n5 = n2 + n3;
        while (n3 != 0 && (iMemory.get(--n5) & 0xF) == 0) {
            ++n4;
            --n3;
        }
        if (n3 == 0) {
            return ZERO;
        }
        while ((iMemory.get(n2) & 0xF) == 0) {
            ++n2;
            --n3;
        }
        byte[] byArray = new byte[n3];
        while (n3 != 0) {
            byArray[--n3] = (byte)(iMemory.get(n2 + n3) & 0xF);
        }
        return new CobolBigDecimal(bl, byArray, n4 + byArray.length);
    }

    public static CobolBigDecimal from(boolean bl, int[] nArray, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        for (n7 = n2 + n3; n7 > n2 && nArray[n7 - 1] == 0; --n7) {
        }
        if (n7 == n2) {
            return ZERO;
        }
        int n8 = n2;
        while (nArray[n8] == 0) {
            ++n8;
            n4 -= 8;
        }
        int n9 = (n7 - n8) * 8;
        byte[] byArray = new byte[n9];
        int n10 = 1;
        for (n6 = 7; n6 > 0; --n6) {
            if (nArray[n8] < WORD_ALIGNER[n6]) continue;
            n10 += n6;
            break;
        }
        n4 -= 8 - n10;
        n6 = nArray[n8];
        for (n5 = n10 - 1; n5 > 0; --n5) {
            byArray[n5] = (byte)(n6 % 10);
            n6 /= 10;
        }
        byArray[0] = (byte)n6;
        while (++n8 < n7) {
            n6 = nArray[n8];
            for (n5 = n10 + 8 - 1; n5 > n10; --n5) {
                byArray[n5] = (byte)(n6 % 10);
                n6 /= 10;
            }
            byArray[n10] = (byte)n6;
            n10 += 8;
        }
        if (n10 > 40) {
            n10 = 40;
        }
        while (byArray[n10 - 1] == 0) {
            --n10;
        }
        if (n10 != n9) {
            byte[] byArray2 = new byte[n10];
            System.arraycopy(byArray, 0, byArray2, 0, n10);
            byArray = byArray2;
        }
        return new CobolBigDecimal(bl, byArray, n4);
    }

    public static CobolBigDecimal from(int n2, int n3) {
        byte by;
        boolean bl;
        if (n2 == 0) {
            return ZERO;
        }
        if (n2 == Integer.MIN_VALUE) {
            return CobolBigDecimal.from((long)n2, n3);
        }
        boolean bl2 = bl = n2 < 0;
        if (bl) {
            n2 = -n2;
        }
        do {
            by = (byte)(n2 % 10);
            n2 /= 10;
            ++n3;
        } while (by == 0);
        byte[] byArray = new byte[10];
        byArray[9] = by;
        int n4 = 1;
        while (n2 != 0) {
            by = (byte)(n2 % 10);
            n2 /= 10;
            byArray[10 - ++n4] = by;
        }
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 10 - n4, byArray2, 0, n4);
        return new CobolBigDecimal(bl, byArray2, n3 - 1 + n4);
    }

    public static CobolBigDecimal from(long l2, int n2) {
        byte by;
        boolean bl;
        if (l2 == 0L) {
            return ZERO;
        }
        if (l2 > Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE) {
            return CobolBigDecimal.from((int)l2, n2);
        }
        if (l2 == Long.MIN_VALUE) {
            return CobolBigDecimal.from(0L, l2, true, n2);
        }
        boolean bl2 = bl = l2 < 0L;
        if (bl) {
            l2 = -l2;
        }
        do {
            by = (byte)(l2 % 10L);
            l2 /= 10L;
            ++n2;
        } while (by == 0);
        byte[] byArray = new byte[20];
        byArray[19] = by;
        int n3 = 1;
        while (l2 != 0L) {
            by = (byte)(l2 % 10L);
            l2 /= 10L;
            byArray[20 - ++n3] = by;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 20 - n3, byArray2, 0, n3);
        return new CobolBigDecimal(bl, byArray2, n2 - 1 + n3);
    }

    public static CobolBigDecimal from(long l2, long l3, boolean bl, int n2) {
        if (l2 == 0L && l3 >= 0L) {
            return CobolBigDecimal.from(bl ? -l3 : l3, n2);
        }
        long[] lArray = new long[]{l2 >>> 32, l2 & 0xFFFFFFFFL, l3 >>> 32, l3 & 0xFFFFFFFFL};
        byte[] byArray = new byte[40];
        int n3 = 0;
        long l4 = 0L;
        while (true) {
            if (lArray[n3] != 0L) {
                int n4;
                for (n4 = n3; n4 < lArray.length; ++n4) {
                    long l5 = lArray[n4] + (l4 << 32);
                    long l6 = l5 / 10L;
                    l4 = l5 % 10L;
                    lArray[n4] = l6;
                }
                ++n2;
                if (l4 == 0L) continue;
                byArray[39] = (byte)l4;
                n4 = 1;
                while (true) {
                    if (n3 >= lArray.length || lArray[n3] != 0L) {
                        if (n3 == lArray.length) {
                            byte[] byArray2 = new byte[n4];
                            System.arraycopy(byArray, 40 - n4, byArray2, 0, n4);
                            return new CobolBigDecimal(bl, byArray2, n2 - 1 + n4);
                        }
                        ++n4;
                        l4 = 0L;
                        for (int i2 = n3; i2 < lArray.length; ++i2) {
                            long l7 = lArray[i2] + (l4 << 32);
                            long l8 = l7 / 10L;
                            l4 = l7 % 10L;
                            lArray[i2] = l8;
                        }
                        byArray[40 - n4] = (byte)l4;
                        continue;
                    }
                    ++n3;
                }
            }
            ++n3;
        }
    }

    public int getInt(int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = n2 != 0 && n3 + n2 < this.exp ? this.exp - (n3 + n2) : 0;
        int n6 = this.exp - n3;
        int n7 = 0;
        if (n6 > this.digits) {
            n7 = n6 - this.digits;
            n6 = this.digits;
        }
        while (n5 < n6) {
            n4 = n4 * 10 + this.mantissa[n5++];
        }
        while (n7 != 0) {
            n4 *= 10;
            --n7;
        }
        return bl && this.negative ? -n4 : n4;
    }

    public long getLong(int n2, int n3, boolean bl) {
        long l2 = 0L;
        int n4 = n2 != 0 && n3 + n2 < this.exp ? this.exp - (n3 + n2) : 0;
        int n5 = this.exp - n3;
        int n6 = 0;
        if (n5 > this.digits) {
            n6 = n5 - this.digits;
            n5 = this.digits;
        }
        while (n4 < n5) {
            l2 = l2 * 10L + (long)this.mantissa[n4++];
        }
        while (n6 != 0) {
            l2 *= 10L;
            --n6;
        }
        return bl && this.negative ? -l2 : l2;
    }

    public String toString() {
        return "CobolBigDecimal{negative=" + this.negative + ", mantissa=" + Arrays.toString(this.mantissa) + ", digits=" + this.digits + ", exp=" + this.exp + '}';
    }

    public class DivResult {
        private final CobolBigDecimal quotient;
        private final CobolBigDecimal remainder;

        public CobolBigDecimal getQuotient() {
            return this.quotient;
        }

        public CobolBigDecimal getRemainder() {
            return this.remainder;
        }

        public DivResult(CobolBigDecimal cobolBigDecimal2, CobolBigDecimal cobolBigDecimal3) {
            this.quotient = cobolBigDecimal2;
            this.remainder = cobolBigDecimal3;
        }

        public String toString() {
            return "quotient: " + this.quotient + ", remainder: " + this.remainder;
        }
    }
}

