/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.data;

import com.veryant.cobol.data.IMemory;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class NativeMemory
implements IMemory {
    private static Unsafe unsafe;
    private final long baseAddress;
    private final int size;

    @Override
    public long getBaseAddress() {
        return this.baseAddress;
    }

    @Override
    public long getAddress(int n2) {
        return this.getBaseAddress() + (long)n2;
    }

    @Override
    public void free() {
        unsafe.freeMemory(this.baseAddress);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public byte get(int n2) {
        return unsafe.getByte(this.getAddress(n2));
    }

    @Override
    public void put(int n2, byte by) {
        unsafe.putByte(this.getAddress(n2), by);
    }

    @Override
    public void or(int n2, byte by) {
        long l2 = this.getAddress(n2);
        unsafe.putByte(l2, (byte)(unsafe.getByte(l2) | by));
    }

    @Override
    public void and(int n2, byte by) {
        long l2 = this.getAddress(n2);
        unsafe.putByte(l2, (byte)(unsafe.getByte(l2) & by));
    }

    @Override
    public void xor(int n2, byte by) {
        long l2 = this.getAddress(n2);
        unsafe.putByte(l2, (byte)(unsafe.getByte(l2) ^ by));
    }

    @Override
    public void copy(IMemory iMemory, int n2, int n3, int n4) {
        while (n4-- > 0) {
            this.put(n3++, iMemory.get(n2++));
        }
    }

    @Override
    public void copy(byte[] byArray, int n2, int n3, int n4) {
        while (n4-- > 0) {
            this.put(n3++, byArray[n2++]);
        }
    }

    @Override
    public byte[] toArray() {
        return this.toArray(0, this.size);
    }

    @Override
    public byte[] toArray(int n2, int n3) {
        return this.toArrayWithTrailingBytes(n2, n3, 0);
    }

    @Override
    public byte[] toArrayWithTrailingBytes(int n2, int n3, int n4) {
        byte[] byArray = new byte[n3 + n4];
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[i2] = this.get(n2++);
        }
        return byArray;
    }

    @Override
    public byte[] toArrayWithLeadingBytes(int n2, int n3, int n4) {
        byte[] byArray = new byte[n3 + n4];
        n3 += n4;
        for (int i2 = n4; i2 < n3; ++i2) {
            byArray[i2] = this.get(n2++);
        }
        return byArray;
    }

    public NativeMemory(int n2) {
        this.size = n2;
        this.baseAddress = unsafe.allocateMemory(n2);
    }

    protected void finalize() throws Throwable {
        this.free();
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

