/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.filehandler;

import com.veryant.cobol.converters.CMP5S;
import com.veryant.cobol.converters.CMPXU;
import com.veryant.cobol.data.CobolDataReference;
import com.veryant.cobol.data.IMemory;
import com.veryant.cobol.rununit.RunUnit;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;

public abstract class CobolFileBase {
    protected static final OpenOption openOptionRead = StandardOpenOption.READ;
    protected static final OpenOption[] openOptionCreateNew = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW};
    protected static final OpenOption[] openOptionTruncateExisting = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
    protected static final OpenOption[] openOptionAppend = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND};
    protected static final OpenOption[] openOptionReadWrite = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
    public static final byte[] errSuccess = new byte[]{48, 48};
    public static final byte[] errDuplicateKeyAllowed = new byte[]{48, 50};
    public static final byte[] errRecordLengthMismatch = new byte[]{48, 52};
    public static final byte[] errOptionalFileMissing = new byte[]{48, 53};
    public static final byte[] errDeviceMismatch = new byte[]{48, 55};
    public static final byte[] errCannotUseOptionalFeatures = new byte[]{48, 77};
    public static final byte[] errAtEnd = new byte[]{49, 48};
    public static final byte[] errRelativeAtEnd = new byte[]{49, 52};
    public static final byte[] errPrimaryKeyOutOfSequence = new byte[]{50, 49};
    public static final byte[] errDuplicateKey = new byte[]{50, 50};
    public static final byte[] errRecordNotFound = new byte[]{50, 51};
    public static final byte[] errRelativeKeyTooSmall = new byte[]{50, 52, 48, 49};
    public static final byte[] errDiskFullForRelativeOrIndexedFile = new byte[]{50, 52};
    public static final byte[] errPermanent = new byte[]{51, 48};
    public static final byte[] errDiskFullForSequentialOrSortFile = new byte[]{51, 52};
    public static final byte[] errFileNotFound = new byte[]{51, 53};
    public static final byte[] errNotAMassStorageDivice = new byte[]{51, 55, 48, 49};
    public static final byte[] errFixedSequentialAsSpoolFile = new byte[]{51, 55, 48, 50};
    public static final byte[] errNoPermissions = new byte[]{51, 55, 48, 55};
    public static final byte[] errOpenInputPrintFile = new byte[]{51, 55, 48, 56};
    public static final byte[] errOpenIoTextFile = new byte[]{51, 55, 48, 57};
    public static final byte[] errNoNetworkLicense = new byte[]{51, 55, 57, 57};
    public static final byte[] errGenericNoPermissions = new byte[]{51, 55};
    public static final byte[] errFilePreviouslyClosedWithLock = new byte[]{51, 56};
    public static final byte[] errFileStructureClash = new byte[]{51, 57};
    public static final byte[] errFileAlreadyOpen = new byte[]{52, 49};
    public static final byte[] errFileNotOpen = new byte[]{52, 50};
    public static final byte[] errNoCurrentRecordSequential = new byte[]{52, 51};
    public static final byte[] errRecordSizeChanged = new byte[]{52, 52};
    public static final byte[] errNoCurrentRecord = new byte[]{52, 54};
    public static final byte[] errFileNotOpenForReadOrStart = new byte[]{52, 55, 48, 50};
    public static final byte[] errFileNotOpenForInputOrIo = new byte[]{52, 55};
    public static final byte[] errFileNotOpenForWrite = new byte[]{52, 56, 48, 50};
    public static final byte[] errInvalidOpenMode = new byte[]{52, 56};
    public static final byte[] errFileNotOpenForIoForRewriteOrDelete = new byte[]{52, 57, 48, 49};
    public static final byte[] errFileNotOpenForRewriteOrDelete = new byte[]{52, 57};
    public static final byte[] errEofBeforeEor = new byte[]{57, 18};
    public static final byte[] errFileLocked = new byte[]{57, 51};
    public static final byte[] errTooManyFilesOpen = new byte[]{57, 52, 49, 48};
    public static final byte[] errIllegalValue = new byte[]{57, 52, 54, 50};
    public static final byte[] errSortMergeKeyNotSpecified = new byte[]{57, 52, 54, 51};
    public static final byte[] errIndexedFileCorrupt = new byte[]{57, 56};
    public static final byte[] errRecordLocked = new byte[]{57, 57};
    public static final byte[] errInadequateMemory = new byte[]{57, 65};
    public static final byte[] errUnsupported = new byte[]{57, 66};
    public static final byte[] errTooManyLocks = new byte[]{57, 67};
    public static final byte[] errInternalError = new byte[]{57, 68};
    public static final byte[] errTransactionError = new byte[]{57, 69};
    public static final byte[] errRecordLimitExceeded = new byte[]{57, 90};
    private static final boolean[] needsFileName = new boolean[256];
    protected int desiredOpenMode = 128;
    protected boolean isAccessSequential = false;
    protected boolean isAccessRandom = false;
    protected boolean isAccessDynamic = false;
    protected boolean isFixedLength = true;
    protected int minRecordLength = 0;
    protected int maxRecordLength = 0;
    protected boolean hasFileStatus = false;
    protected boolean isMultiLock = false;
    protected boolean isLockAutomatic = false;
    protected int currentOpenMode = 128;
    public long handle = 0L;
    protected final RunUnit $RU$;
    protected final CobolDataReference fcd;

    public static String getFileName(RunUnit runUnit, int n2, IMemory iMemory, int n3) {
        if (!needsFileName[n2]) {
            return null;
        }
        long l2 = CMP5S.loadLong(iMemory, n3 + 168, 8);
        int n4 = CMPXU.loadInt(iMemory, n3 + 54, 2);
        String string = runUnit.readDirectString(l2, n4);
        return string.trim();
    }

    public static boolean isStatusSuccess(byte[] byArray) {
        return byArray.length > 0 && byArray[0] == errSuccess[0];
    }

    public static byte[] deleteFile(String string) {
        return new byte[0];
    }

    public void setOpenInfo(int n2) {
        int n3;
        this.desiredOpenMode = n2;
        int n4 = this.getFcdAccessMode();
        this.isAccessDynamic = (n4 & 8) != 0;
        this.isAccessSequential = this.isAccessDynamic || (n4 & 4) == 0;
        this.isAccessRandom = this.isAccessDynamic || (n4 & 4) != 0;
        this.hasFileStatus = (n4 & 0x80) != 0;
        this.isFixedLength = (this.getRecordingMode() & 1) == 0;
        this.maxRecordLength = this.getFcdMaxRecordLen();
        if (!this.isFixedLength) {
            this.minRecordLength = this.getFcdMinRecordLen();
        }
        this.isMultiLock = ((n3 = this.getLockMode()) & 0x80) != 0;
        this.isLockAutomatic = (n3 & 2) != 0;
    }

    public CobolFileBase(RunUnit runUnit, CobolDataReference cobolDataReference) {
        this.$RU$ = runUnit;
        this.fcd = cobolDataReference;
    }

    public abstract byte[] open(int var1, int var2, String var3, byte var4, byte var5);

    public abstract byte[] close(int var1);

    public abstract byte[] commit();

    public abstract byte[] delete();

    public abstract byte[] read(int var1, LockTypes var2);

    public abstract byte[] next(int var1, LockTypes var2);

    public abstract byte[] previous(int var1, LockTypes var2);

    public abstract byte[] rollback();

    public abstract byte[] start(int var1);

    public abstract byte[] unlock();

    public abstract byte[] write(int var1);

    public abstract byte[] rewrite();

    public byte getFcdByte(int n2) {
        return this.fcd.getMemory().get(this.fcd.getOffset() + n2);
    }

    public void setFcdByte(int n2, byte by) {
        this.fcd.getMemory().put(this.fcd.getOffset() + n2, by);
    }

    protected boolean fcdIsOptional() {
        return (this.getFcdByte(21) & 0x80) != 0;
    }

    public int getFcdCurrentOpenMode() {
        return this.getFcdByte(7);
    }

    public void setFcdCurrentOpenMode(int n2) {
        this.setFcdByte(7, (byte)n2);
    }

    public int getFcdAccessMode() {
        return this.getFcdByte(6);
    }

    protected int getRecordingMode() {
        return this.getFcdByte(8);
    }

    protected int getLockMode() {
        return this.getFcdByte(28);
    }

    protected int getFcdMaxRecordLen() {
        return CMPXU.loadInt(this.fcd.getMemory(), this.fcd.getOffset() + 96, 4);
    }

    protected int getFcdMinRecordLen() {
        return CMPXU.loadInt(this.fcd.getMemory(), this.fcd.getOffset() + 92, 4);
    }

    protected byte[] getFcdRecordContent() {
        long l2 = CMP5S.loadLong(this.fcd.getMemory(), this.fcd.getOffset() + 160, 8);
        int n2 = CMPXU.loadInt(this.fcd.getMemory(), this.fcd.getOffset() + 88, 4);
        return this.$RU$.readDirectBytes(l2, n2);
    }

    protected byte[] getFcdRecordContentWithTrailingBytes(int n2) {
        long l2 = CMP5S.loadLong(this.fcd.getMemory(), this.fcd.getOffset() + 160, 8);
        int n3 = CMPXU.loadInt(this.fcd.getMemory(), this.fcd.getOffset() + 88, 4);
        return this.$RU$.readDirectBytesWithTrailingBytes(l2, n3, n2);
    }

    protected byte[] getFcdRecordContentWithLeadingBytes(int n2) {
        long l2 = CMP5S.loadLong(this.fcd.getMemory(), this.fcd.getOffset() + 160, 8);
        int n3 = CMPXU.loadInt(this.fcd.getMemory(), this.fcd.getOffset() + 88, 4);
        return this.$RU$.readDirectBytesWithLeadingBytes(l2, n3, n2);
    }

    protected void putFcdRecordContent(byte[] byArray, int n2) {
        long l2 = CMP5S.loadLong(this.fcd.getMemory(), this.fcd.getOffset() + 160, 8);
        int n3 = CMPXU.loadInt(this.fcd.getMemory(), this.fcd.getOffset() + 96, 4);
        if (n2 > n3) {
            n2 = n3;
        }
        this.$RU$.writeDirectBytes(byArray, l2, n2);
        this.setFcdCurrentRecLen(n2);
    }

    protected void putFcdRecordContent(ByteBuffer byteBuffer) {
        long l2 = CMP5S.loadLong(this.fcd.getMemory(), this.fcd.getOffset() + 160, 8);
        int n2 = CMPXU.loadInt(this.fcd.getMemory(), this.fcd.getOffset() + 96, 4);
        int n3 = byteBuffer.limit() - byteBuffer.position();
        if (n3 > n2) {
            n3 = n2;
        }
        this.$RU$.writeDirectBytes(byteBuffer.array(), l2, byteBuffer.position(), n3);
        this.setFcdCurrentRecLen(n3);
    }

    protected void setFcdCurrentRecLen(int n2) {
        CMPXU.store(n2, this.fcd.getMemory(), this.fcd.getOffset() + 88, 4);
    }

    protected long getFcdRelativeKey() {
        return CMPXU.loadLong(this.fcd.getMemory(), this.fcd.getOffset() + 144, 8);
    }

    protected void setFcdRelativeKey(long l2) {
        CMPXU.store(l2, this.fcd.getMemory(), this.fcd.getOffset() + 144, 8);
    }

    public long getHandle() {
        return this.handle;
    }

    static {
        CobolFileBase.needsFileName[0] = true;
        CobolFileBase.needsFileName[1] = true;
        CobolFileBase.needsFileName[2] = true;
        CobolFileBase.needsFileName[3] = true;
        CobolFileBase.needsFileName[4] = true;
        CobolFileBase.needsFileName[5] = true;
        CobolFileBase.needsFileName[8] = true;
        CobolFileBase.needsFileName[248] = true;
    }

    public static enum LockTypes {
        None,
        WithLock,
        WithNoLock,
        WithKeptLock;

    }
}

