/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.filehandler;

import com.veryant.cobol.data.CobolDataReference;
import com.veryant.cobol.filehandler.CobolBufferedFileWriter;
import com.veryant.cobol.filehandler.CobolFileBase;
import com.veryant.cobol.filehandler.CobolFileSequentialBase;
import com.veryant.cobol.rununit.RunUnit;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class CobolFileRelative
extends CobolFileSequentialBase {
    private PointerStatuses pointerStatus = PointerStatuses.BeforeFirst;
    private long filePointer = -1L;
    private long appendKeyValue;
    private ByteBuffer readByteBuffer = null;
    private ByteBuffer emptyByteBuffer = null;

    public CobolFileRelative(RunUnit runUnit, CobolDataReference cobolDataReference) {
        super(runUnit, cobolDataReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] delete() {
        block33: {
            byte[] byArray = super.delete();
            if (!CobolFileRelative.isStatusSuccess(byArray)) {
                return byArray;
            }
            PointerStatuses pointerStatuses = this.pointerStatus;
            long l2 = this.readPosition;
            this.pointerStatus = PointerStatuses.StartFailed;
            switch (this.currentOpenMode) {
                case 2: {
                    if (this.fileChannel != null) break;
                    return errRecordNotFound;
                }
                default: {
                    return errFileNotOpenForIoForRewriteOrDelete;
                }
            }
            try {
                if (this.isAccessRandom) {
                    byArray = this.read(218, CobolFileBase.LockTypes.WithLock);
                    if (CobolFileRelative.isStatusSuccess(byArray)) {
                        long l3 = (this.getFcdRelativeKey() - 1L) * (long)this.maxRecordLength;
                        this.rewrite(new byte[this.maxRecordLength], l3);
                        break block33;
                    }
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                if (this.isAccessSequential) {
                    switch (pointerStatuses) {
                        case ReadSuccessful: 
                        case NextSuccessful: 
                        case PreviousSuccessful: {
                            this.rewrite(new byte[this.maxRecordLength], this.readPosition - (long)this.maxRecordLength);
                            break block33;
                        }
                        default: {
                            byte[] byArray3 = errNoCurrentRecord;
                            return byArray3;
                        }
                    }
                }
                byte[] byArray4 = errFileNotOpenForIoForRewriteOrDelete;
                return byArray4;
            }
            catch (SecurityException securityException) {
                byte[] byArray5 = this.getSecurityExceptionError(securityException);
                return byArray5;
            }
            catch (IOException iOException) {
                byte[] byArray6 = this.getPermanentError(iOException);
                return byArray6;
            }
            finally {
                this.readPosition = l2;
                this.pointerStatus = pointerStatuses;
                try {
                    this.fileChannel.position(this.readPosition);
                }
                catch (Exception exception) {
                    return this.getPermanentError(exception);
                }
            }
        }
        return errSuccess;
    }

    @Override
    public byte[] read(int n2, CobolFileBase.LockTypes lockTypes) {
        byte[] byArray = super.read(n2, lockTypes);
        if (!CobolFileRelative.isStatusSuccess(byArray)) {
            return byArray;
        }
        this.pointerStatus = PointerStatuses.StartFailed;
        switch (this.currentOpenMode) {
            case 0: 
            case 2: {
                if (this.fileChannel != null) break;
                return errRecordNotFound;
            }
            default: {
                return errFileNotOpenForReadOrStart;
            }
        }
        this.filePointer = (this.getFcdRelativeKey() - 1L) * (long)this.maxRecordLength;
        this.prepareReadByteBuffer();
        try {
            this.readRecord(this.filePointer);
            if (!this.isRecordValid()) {
                return errEofBeforeEor;
            }
            if (!this.recordExists()) {
                return errRecordNotFound;
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        this.pointerStatus = PointerStatuses.ReadSuccessful;
        this.putFcdRecordContent(this.readByteBuffer);
        return errSuccess;
    }

    @Override
    public byte[] next(int n2, CobolFileBase.LockTypes lockTypes) {
        byte[] byArray = super.next(n2, lockTypes);
        if (!CobolFileRelative.isStatusSuccess(byArray)) {
            return byArray;
        }
        switch (this.currentOpenMode) {
            case 0: 
            case 2: {
                if (this.fileChannel != null) break;
                this.pointerStatus = this.pointerStatus == PointerStatuses.BeforeFirst ? PointerStatuses.AfterLast : PointerStatuses.StartFailed;
                return errAtEnd;
            }
            default: {
                return errFileNotOpenForReadOrStart;
            }
        }
        if (this.pointerStatus == PointerStatuses.StartFailed) {
            return errNoCurrentRecord;
        }
        switch (this.pointerStatus) {
            case BeforeFirst: {
                this.filePointer = 0L;
                break;
            }
            case AfterLast: {
                this.pointerStatus = PointerStatuses.StartFailed;
                return errNoCurrentRecord;
            }
            case StartFailed: {
                return errNoCurrentRecord;
            }
            case StartSuccessful: {
                break;
            }
            case ReadSuccessful: 
            case NextSuccessful: 
            case PreviousSuccessful: {
                this.filePointer += (long)this.maxRecordLength;
            }
        }
        this.prepareReadByteBuffer();
        try {
            while (true) {
                this.readRecord(this.filePointer);
                if (!this.isRecordValid()) {
                    this.pointerStatus = PointerStatuses.AfterLast;
                    return errAtEnd;
                }
                if (!this.recordExists()) {
                    this.filePointer += (long)this.maxRecordLength;
                    continue;
                }
                break;
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        this.pointerStatus = PointerStatuses.NextSuccessful;
        this.setFcdRelativeKey(this.filePointer / (long)this.maxRecordLength + 1L);
        this.putFcdRecordContent(this.readByteBuffer);
        return errSuccess;
    }

    @Override
    public byte[] previous(int n2, CobolFileBase.LockTypes lockTypes) {
        switch (this.currentOpenMode) {
            case 0: 
            case 2: {
                if (this.fileChannel != null) break;
                this.pointerStatus = this.pointerStatus == PointerStatuses.BeforeFirst ? PointerStatuses.AfterLast : PointerStatuses.StartFailed;
                return errAtEnd;
            }
            default: {
                return errFileNotOpenForReadOrStart;
            }
        }
        byte[] byArray = super.previous(n2, lockTypes);
        if (!CobolFileRelative.isStatusSuccess(byArray)) {
            return byArray;
        }
        if (this.pointerStatus == PointerStatuses.StartFailed) {
            return errNoCurrentRecord;
        }
        switch (this.pointerStatus) {
            case BeforeFirst: {
                this.pointerStatus = PointerStatuses.StartFailed;
                return errNoCurrentRecord;
            }
            case AfterLast: {
                this.filePointer = this.file.length() - (long)this.maxRecordLength;
                break;
            }
            case StartFailed: {
                return errNoCurrentRecord;
            }
            case StartSuccessful: {
                break;
            }
            case ReadSuccessful: 
            case NextSuccessful: 
            case PreviousSuccessful: {
                this.filePointer -= (long)this.maxRecordLength;
            }
        }
        this.prepareReadByteBuffer();
        try {
            while (true) {
                if (this.filePointer < 0L) {
                    this.pointerStatus = PointerStatuses.BeforeFirst;
                    return errAtEnd;
                }
                this.readRecord(this.filePointer);
                if (!this.recordExists()) {
                    this.filePointer -= (long)this.maxRecordLength;
                    continue;
                }
                break;
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        this.pointerStatus = PointerStatuses.NextSuccessful;
        this.setFcdRelativeKey(this.filePointer / (long)this.maxRecordLength + 1L);
        this.putFcdRecordContent(this.readByteBuffer);
        return errSuccess;
    }

    @Override
    public byte[] start(int n2) {
        this.pointerStatus = PointerStatuses.StartFailed;
        switch (this.currentOpenMode) {
            case 0: 
            case 2: {
                if (this.fileChannel != null) break;
                return errRecordNotFound;
            }
            default: {
                return errFileNotOpenForReadOrStart;
            }
        }
        byte[] byArray = super.start(n2);
        if (!CobolFileRelative.isStatusSuccess(byArray)) {
            return byArray;
        }
        if (this.currentOpenMode == 0 && this.fileChannel == null) {
            return this.fcdIsOptional() ? errRecordNotFound : errFileNotOpenForReadOrStart;
        }
        if (this.currentOpenMode == 2 && this.fileChannel == null) {
            return errFileNotOpenForReadOrStart;
        }
        this.filePointer = (this.getFcdRelativeKey() - 1L) * (long)this.maxRecordLength;
        this.prepareReadByteBuffer();
        try {
            block4 : switch (n2) {
                case 232: 
                case 233: {
                    this.readRecord(this.filePointer);
                    if (!this.isRecordValid()) {
                        return errEofBeforeEor;
                    }
                    if (this.recordExists()) break;
                    return errRecordNotFound;
                }
                case 234: {
                    do {
                        this.filePointer += (long)this.maxRecordLength;
                        this.readRecord(this.filePointer);
                        if (this.isRecordValid()) continue;
                        return errRecordNotFound;
                    } while (!this.recordExists());
                    break;
                }
                case 235: {
                    while (true) {
                        this.readRecord(this.filePointer);
                        if (!this.isRecordValid()) {
                            return errRecordNotFound;
                        }
                        if (this.recordExists()) break block4;
                        this.filePointer += (long)this.maxRecordLength;
                    }
                }
                case 254: {
                    if (this.filePointer < 0L) {
                        return errRecordNotFound;
                    }
                    long l2 = this.file.length();
                    if (this.filePointer > l2) {
                        this.filePointer = l2;
                    }
                    do {
                        this.filePointer -= (long)this.maxRecordLength;
                        if (this.filePointer < 0L) {
                            return errRecordNotFound;
                        }
                        this.readRecord(this.filePointer);
                    } while (!this.recordExists());
                    break;
                }
                case 255: {
                    long l3 = this.file.length();
                    if (this.filePointer > l3) {
                        this.filePointer = l3;
                    }
                    while (this.filePointer >= 0L) {
                        this.readRecord(this.filePointer);
                        if (this.recordExists()) break block4;
                        this.filePointer -= (long)this.maxRecordLength;
                    }
                    return errRecordNotFound;
                }
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        this.pointerStatus = PointerStatuses.StartSuccessful;
        return errSuccess;
    }

    @Override
    public byte[] write(int n2) {
        this.readPosition = -1L;
        byte[] byArray = super.write(n2);
        if (!CobolFileRelative.isStatusSuccess(byArray)) {
            return byArray;
        }
        try {
            switch (this.currentOpenMode) {
                case 1: 
                case 3: {
                    if (this.fileChannel == null && this.rewriteChannel == null) {
                        return errFileNotOpenForWrite;
                    }
                    if (!this.isAccessSequential) {
                        return errRecordNotFound;
                    }
                    this.cobolBufferedFileWriter.append(ByteBuffer.wrap(this.getFcdRecordContent()));
                    this.setFcdRelativeKey(++this.appendKeyValue);
                    break;
                }
                default: {
                    return errFileNotOpenForWrite;
                }
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        return errSuccess;
    }

    @Override
    public byte[] rewrite() {
        long l2 = this.rewritePosition;
        this.rewritePosition = -1L;
        byte[] byArray = super.rewrite();
        if (!CobolFileRelative.isStatusSuccess(byArray)) {
            return byArray;
        }
        try {
            switch (this.currentOpenMode) {
                case 2: {
                    if (l2 < 0L) {
                        return errNoCurrentRecordSequential;
                    }
                    if (this.fileChannel == null && this.rewriteChannel == null) {
                        return errFileNotOpenForIoForRewriteOrDelete;
                    }
                    this.rewrite(this.getFcdRecordContent(), l2);
                    break;
                }
                default: {
                    return errFileNotOpenForIoForRewriteOrDelete;
                }
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        return errSuccess;
    }

    private void rewrite(byte[] byArray, long l2) throws IOException {
        if (l2 != this.rewriteChannelPosition) {
            this.rewriteChannel.position(l2);
        }
        this.rewriteChannel.write(ByteBuffer.wrap(byArray));
        this.rewriteChannelPosition += (long)byArray.length;
    }

    @Override
    protected byte[] beforeOpenInput() {
        return this.beforeOpen();
    }

    @Override
    protected byte[] beforeOpenExtend() {
        return this.beforeOpen();
    }

    @Override
    protected byte[] beforeOpenIO() {
        return this.beforeOpen();
    }

    @Override
    protected byte[] afterOpenOutput(byte[] byArray) {
        if (CobolFileRelative.isStatusSuccess(byArray)) {
            this.createBufferedWriter(-1L);
            this.appendKeyValue = 0L;
        }
        return byArray;
    }

    @Override
    protected byte[] afterOpenExtend(byte[] byArray) throws IOException {
        if (CobolFileRelative.isStatusSuccess(byArray)) {
            this.createBufferedWriter(1000L);
            this.appendKeyValue = this.file.length() / (long)this.maxRecordLength;
        }
        return byArray;
    }

    private byte[] beforeOpen() {
        if (this.file.length() % (long)this.maxRecordLength == 0L) {
            return errSuccess;
        }
        return errFileStructureClash;
    }

    private void createBufferedWriter(long l2) {
        this.cobolBufferedFileWriter = new CobolBufferedFileWriter(this.randomAccessFile.getChannel(), this.maxRecordLength, true);
        if (l2 > 0L) {
            this.cobolBufferedFileWriter.setUpdateInterval(l2);
        }
    }

    private void prepareReadByteBuffer() {
        if (this.readByteBuffer == null) {
            this.readByteBuffer = ByteBuffer.allocate(this.maxRecordLength);
            this.emptyByteBuffer = ByteBuffer.allocate(this.maxRecordLength);
        }
        this.readByteBuffer.position(0);
        this.readByteBuffer.limit(this.maxRecordLength);
    }

    private void readRecord(long l2) throws IOException {
        int n2;
        this.rewritePosition = this.readPosition;
        if (l2 != this.readPosition) {
            this.fileChannel.position(l2);
            this.readPosition = l2;
        }
        for (int i2 = this.maxRecordLength; i2 > 0; i2 -= n2) {
            n2 = this.fileChannel.read(this.readByteBuffer);
            if (n2 >= 0) continue;
            this.readPosition += (long)this.readByteBuffer.position();
            this.readByteBuffer.limit(0);
            return;
        }
        this.readPosition += (long)this.readByteBuffer.position();
        this.readByteBuffer.flip();
    }

    private boolean isRecordValid() {
        return this.readByteBuffer.limit() == this.maxRecordLength;
    }

    private boolean recordExists() {
        return !Arrays.equals(this.readByteBuffer.array(), this.emptyByteBuffer.array());
    }

    private static enum PointerStatuses {
        BeforeFirst,
        AfterLast,
        StartFailed,
        StartSuccessful,
        ReadSuccessful,
        NextSuccessful,
        PreviousSuccessful;

    }
}

