/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.filehandler;

import com.veryant.cobol.data.CobolDataReference;
import com.veryant.cobol.filehandler.CobolBufferedFileReader;
import com.veryant.cobol.filehandler.CobolBufferedFileWriter;
import com.veryant.cobol.filehandler.CobolFileBase;
import com.veryant.cobol.filehandler.CobolFileSequentialBase;
import com.veryant.cobol.filehandler.ICobolFileSequentialNext;
import com.veryant.cobol.filehandler.ICobolFileSequentialRewrite;
import com.veryant.cobol.rununit.RunUnit;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CobolFileSequential
extends CobolFileSequentialBase {
    private final boolean isLineSequential;
    private byte[] recordTerminatorArray = new byte[]{13, 10};
    private ByteBuffer recordTerminator = ByteBuffer.wrap(this.recordTerminatorArray);
    private boolean stripTrailingSpaces = true;
    private CobolBufferedFileReader cobolBufferedFileReader = null;
    private ICobolFileSequentialNext nextMethod = null;
    private ICobolFileSequentialRewrite rewriteMethod = null;
    private ByteBuffer shortByteBuffer = ByteBuffer.allocate(2);
    private ByteBuffer intByteBuffer = ByteBuffer.allocate(4);
    private ByteBuffer readByteBuffer = null;
    private byte[] readByteArray = null;
    private ByteBuffer recordByteBuffer = null;
    private int readRecordLength = -1;
    private static final byte[] delimiter0D0A = new byte[]{13, 10};
    private static final byte[] delimiter0A = new byte[]{13, 10};
    private static final byte[] noDelimiter = new byte[0];
    private byte[] readDelimiter = noDelimiter;
    private boolean eofBeforeEor = false;

    public CobolFileSequential(RunUnit runUnit, CobolDataReference cobolDataReference, boolean bl) {
        super(runUnit, cobolDataReference);
        this.isLineSequential = bl;
    }

    public void setRecordTerminator(byte[] byArray) {
        this.recordTerminatorArray = byArray;
        this.recordTerminator = ByteBuffer.wrap(byArray);
    }

    public void setStripTrailingSpaces(boolean bl) {
        this.stripTrailingSpaces = bl;
    }

    @Override
    public byte[] delete() {
        byte[] byArray = super.delete();
        if (!CobolFileSequential.isStatusSuccess(byArray)) {
            return byArray;
        }
        return errUnsupported;
    }

    @Override
    public byte[] read(int n2, CobolFileBase.LockTypes lockTypes) {
        byte[] byArray = super.read(n2, lockTypes);
        if (!CobolFileSequential.isStatusSuccess(byArray)) {
            return byArray;
        }
        return errUnsupported;
    }

    @Override
    public byte[] next(int n2, CobolFileBase.LockTypes lockTypes) {
        this.rewritePosition = -1L;
        this.readRecordLength = -1;
        byte[] byArray = super.next(n2, lockTypes);
        if (!CobolFileSequential.isStatusSuccess(byArray)) {
            return byArray;
        }
        try {
            switch (this.currentOpenMode) {
                case 0: {
                    if (this.cobolBufferedFileReader == null) {
                        return this.fcdIsOptional() ? errAtEnd : errFileNotOpenForReadOrStart;
                    }
                    ByteBuffer byteBuffer = this.cobolBufferedFileReader.next();
                    if (!this.isLineSequential && this.cobolBufferedFileReader.isEofBeforeEor()) {
                        return this.hasFileStatus && this.isFixedLength ? errEofBeforeEor : errAtEnd;
                    }
                    if (byteBuffer == null) {
                        return errAtEnd;
                    }
                    this.putFcdRecordContent(byteBuffer);
                    break;
                }
                case 2: {
                    byte[] byArray2;
                    if (this.fileChannel == null) {
                        return this.fcdIsOptional() ? errAtEnd : errFileNotOpenForReadOrStart;
                    }
                    ByteBuffer byteBuffer = this.nextMethod.call();
                    if (!this.isLineSequential && this.eofBeforeEor) {
                        return this.hasFileStatus && this.isFixedLength ? errEofBeforeEor : errAtEnd;
                    }
                    if (byteBuffer == null) {
                        return errAtEnd;
                    }
                    if (!this.isLineSequential && (this.isLockAutomatic && lockTypes == CobolFileBase.LockTypes.None || this.isMultiLock && lockTypes == CobolFileBase.LockTypes.WithKeptLock || !this.isMultiLock && lockTypes == CobolFileBase.LockTypes.WithLock) && !CobolFileSequential.isStatusSuccess(byArray2 = this.lockFileSection(this.fileChannel, this.readPosition, this.readRecordLength))) {
                        return byArray2;
                    }
                    this.putFcdRecordContent(byteBuffer.array(), this.readRecordLength);
                    break;
                }
                default: {
                    return errFileNotOpenForReadOrStart;
                }
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        return errSuccess;
    }

    @Override
    public byte[] previous(int n2, CobolFileBase.LockTypes lockTypes) {
        byte[] byArray = super.previous(n2, lockTypes);
        if (!CobolFileSequential.isStatusSuccess(byArray)) {
            return byArray;
        }
        return errUnsupported;
    }

    @Override
    public byte[] start(int n2) {
        byte[] byArray = super.start(n2);
        if (!CobolFileSequential.isStatusSuccess(byArray)) {
            return byArray;
        }
        if (this.currentOpenMode == 0 && this.fileChannel == null) {
            return this.fcdIsOptional() ? errRecordNotFound : errFileNotOpenForReadOrStart;
        }
        if (this.currentOpenMode == 2 && this.fileChannel == null) {
            return errFileNotOpenForReadOrStart;
        }
        return errSuccess;
    }

    @Override
    public byte[] write(int n2) {
        this.rewritePosition = -1L;
        this.readRecordLength = -1;
        byte[] byArray = super.write(n2);
        if (!CobolFileSequential.isStatusSuccess(byArray)) {
            return byArray;
        }
        try {
            switch (this.currentOpenMode) {
                case 1: 
                case 3: {
                    if (this.fileChannel == null) {
                        return errFileNotOpenForWrite;
                    }
                    this.cobolBufferedFileWriter.append(ByteBuffer.wrap(this.getFcdRecordContent()));
                    break;
                }
                default: {
                    return errFileNotOpenForWrite;
                }
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        return errSuccess;
    }

    @Override
    public byte[] rewrite() {
        long l2 = this.rewritePosition;
        long l3 = this.readRecordLength;
        this.rewritePosition = -1L;
        this.readRecordLength = -1;
        byte[] byArray = super.rewrite();
        if (!CobolFileSequential.isStatusSuccess(byArray)) {
            return byArray;
        }
        try {
            switch (this.currentOpenMode) {
                case 2: {
                    if (l2 < 0L) {
                        return errNoCurrentRecordSequential;
                    }
                    if (this.fileChannel == null && this.rewriteChannel == null) {
                        return errFileNotOpenForIoForRewriteOrDelete;
                    }
                    byArray = this.rewriteMethod.call(l2, l3);
                    if (!CobolFileSequential.isStatusSuccess(byArray)) {
                        return byArray;
                    }
                    break;
                }
                default: {
                    return errFileNotOpenForIoForRewriteOrDelete;
                }
            }
        }
        catch (SecurityException securityException) {
            return this.getSecurityExceptionError(securityException);
        }
        catch (IOException iOException) {
            return this.getPermanentError(iOException);
        }
        return errSuccess;
    }

    private byte[] rewriteLineSequentialRecord(long l2, long l3) throws IOException {
        byte[] byArray = this.getFcdRecordContentWithTrailingBytes(this.readDelimiter.length);
        int n2 = this.getLineLength(byArray, byArray.length - this.readDelimiter.length);
        if ((long)n2 != l3) {
            return errRecordSizeChanged;
        }
        System.arraycopy(this.readDelimiter, 0, byArray, n2, this.readDelimiter.length);
        n2 += this.readDelimiter.length;
        if (l2 != this.rewriteChannelPosition) {
            this.rewriteChannel.position(l2);
        }
        this.rewriteChannel.write(ByteBuffer.wrap(byArray, 0, n2));
        this.rewriteChannelPosition += (long)n2;
        return errSuccess;
    }

    private byte[] rewriteSequentialFixedRecord(long l2, long l3) throws IOException {
        byte[] byArray = this.getFcdRecordContent();
        int n2 = byArray.length;
        if ((long)n2 != l3) {
            return errRecordSizeChanged;
        }
        if (l2 != this.rewriteChannelPosition) {
            this.rewriteChannel.position(l2);
        }
        this.rewriteChannel.write(ByteBuffer.wrap(byArray, 0, n2));
        this.rewriteChannelPosition += (long)n2;
        return errSuccess;
    }

    private byte[] rewriteSequentialShortRecord(long l2, long l3) throws IOException {
        byte[] byArray = this.getFcdRecordContentWithLeadingBytes(2);
        int n2 = byArray.length - 2;
        if ((long)n2 != l3) {
            return errRecordSizeChanged;
        }
        if (l2 != this.rewriteChannelPosition) {
            this.rewriteChannel.position(l2);
        }
        this.shortByteBuffer.clear();
        this.shortByteBuffer.putShort((short)n2);
        System.arraycopy(this.shortByteBuffer.array(), 0, byArray, 0, 2);
        this.rewriteChannel.write(ByteBuffer.wrap(byArray));
        this.rewriteChannelPosition += (long)(n2 += 2);
        return errSuccess;
    }

    private byte[] rewriteSequentialIntRecord(long l2, long l3) throws IOException {
        byte[] byArray = this.getFcdRecordContentWithLeadingBytes(4);
        int n2 = byArray.length - 4;
        if ((long)n2 != l3) {
            return errRecordSizeChanged;
        }
        if (l2 != this.rewriteChannelPosition) {
            this.rewriteChannel.position(l2);
        }
        this.intByteBuffer.clear();
        this.intByteBuffer.putInt(n2);
        System.arraycopy(this.intByteBuffer.array(), 0, byArray, 0, 4);
        this.rewriteChannel.write(ByteBuffer.wrap(byArray));
        this.rewriteChannelPosition += (long)(n2 += 4);
        return errSuccess;
    }

    @Override
    protected byte[] afterOpenInput(byte[] byArray) {
        if (CobolFileSequential.isStatusSuccess(byArray)) {
            this.cobolBufferedFileReader = this.isLineSequential ? new CobolBufferedFileReader(this.randomAccessFile.getChannel(), this.maxRecordLength) : new CobolBufferedFileReader(this.randomAccessFile.getChannel(), this.maxRecordLength, this.isFixedLength);
        }
        return byArray;
    }

    @Override
    protected byte[] afterOpenOutput(byte[] byArray) {
        if (CobolFileSequential.isStatusSuccess(byArray)) {
            this.createBufferedWriter(-1L);
        }
        return byArray;
    }

    @Override
    protected byte[] afterOpenIO(byte[] byArray) {
        if (CobolFileSequential.isStatusSuccess(byArray)) {
            if (this.isLineSequential) {
                this.nextMethod = this::getLineSequentialRecord;
                this.rewriteMethod = this::rewriteLineSequentialRecord;
                int n2 = this.maxRecordLength + 2;
                if (n2 < 256) {
                    n2 = 256;
                }
                this.readByteBuffer = ByteBuffer.allocate(n2);
                this.readByteArray = this.readByteBuffer.array();
                this.readByteBuffer.position(this.readByteBuffer.capacity());
                this.recordByteBuffer = ByteBuffer.allocate(this.maxRecordLength);
            } else {
                if (this.isFixedLength) {
                    this.nextMethod = this::getSequentialFixedRecord;
                    this.rewriteMethod = this::rewriteSequentialFixedRecord;
                } else if (this.maxRecordLength <= 65535) {
                    this.nextMethod = this::getSequentialShortRecord;
                    this.rewriteMethod = this::rewriteSequentialShortRecord;
                } else {
                    this.nextMethod = this::getSequentialIntRecord;
                    this.rewriteMethod = this::rewriteSequentialIntRecord;
                }
                this.readByteBuffer = ByteBuffer.allocate(this.maxRecordLength);
                this.readByteBuffer.position(0);
            }
        }
        return byArray;
    }

    @Override
    protected byte[] afterOpenExtend(byte[] byArray) throws IOException {
        if (CobolFileSequential.isStatusSuccess(byArray)) {
            this.createBufferedWriter(1000L);
            this.randomAccessFile.getChannel().position(this.file.length());
        }
        return byArray;
    }

    private void createBufferedWriter(long l2) {
        CobolBufferedFileWriter cobolBufferedFileWriter = this.cobolBufferedFileWriter = this.isLineSequential ? new CobolBufferedFileWriter(this.randomAccessFile.getChannel(), this.maxRecordLength, this.recordTerminator) : new CobolBufferedFileWriter(this.randomAccessFile.getChannel(), this.maxRecordLength, this.isFixedLength);
        if (l2 > 0L) {
            this.cobolBufferedFileWriter.setUpdateInterval(l2);
        }
    }

    private void updateRecordByteBuffer(int n2) {
        int n3 = this.readByteBuffer.position() - n2;
        if (n3 > 0) {
            this.recordByteBuffer.put(this.readByteArray, n2, n3);
        }
    }

    private boolean readIntoReadByteBuffer() throws IOException {
        this.readByteBuffer.compact();
        long l2 = this.fileChannel.read(this.readByteBuffer);
        if (l2 < 0L) {
            this.readByteBuffer.clear();
            this.readByteBuffer.limit(0);
            return false;
        }
        this.readByteBuffer.flip();
        return true;
    }

    private ByteBuffer getLineSequentialRecord() throws IOException {
        int n2 = this.readByteBuffer.position();
        this.recordByteBuffer.clear();
        this.rewritePosition = this.readPosition;
        this.readRecordLength = 0;
        int n3 = n2;
        block4: while (true) {
            if (n3 >= this.readByteBuffer.limit()) {
                this.readByteBuffer.position(this.readByteBuffer.limit());
                this.updateRecordByteBuffer(n2);
                if (!this.readIntoReadByteBuffer()) {
                    if (this.recordByteBuffer.position() != 0) break;
                    return null;
                }
                n2 = 0;
                n3 = 0;
            }
            switch (this.readByteArray[n3]) {
                case 10: {
                    this.readByteBuffer.position(n3);
                    this.updateRecordByteBuffer(n2);
                    this.readByteBuffer.position(n3 + 1);
                    this.readDelimiter = delimiter0A;
                    break block4;
                }
                case 13: {
                    if (++n3 >= this.readByteBuffer.limit()) {
                        this.readByteBuffer.position(this.readByteBuffer.limit());
                        this.updateRecordByteBuffer(n2);
                        if (!this.readIntoReadByteBuffer()) {
                            if (this.recordByteBuffer.position() != 0) break block4;
                            return null;
                        }
                        n2 = 0;
                        n3 = 0;
                    }
                    if (this.readByteArray[n3] == 10) {
                        if (n3 > 0) {
                            this.readByteBuffer.position(n3 - 1);
                            this.updateRecordByteBuffer(n2);
                        }
                        this.readByteBuffer.position(n3 + 1);
                        this.readDelimiter = delimiter0D0A;
                        break block4;
                    }
                    if (this.readRecordLength >= this.maxRecordLength) {
                        this.readByteBuffer.position(this.recordByteBuffer.capacity() - this.recordByteBuffer.position());
                        this.updateRecordByteBuffer(n2);
                        this.readDelimiter = noDelimiter;
                        break block4;
                    }
                    ++this.readRecordLength;
                    break;
                }
                default: {
                    if (this.readRecordLength >= this.maxRecordLength) {
                        this.readByteBuffer.position(this.recordByteBuffer.capacity() - this.recordByteBuffer.position());
                        this.updateRecordByteBuffer(n2);
                        this.readDelimiter = noDelimiter;
                        break block4;
                    }
                    ++this.readRecordLength;
                }
            }
            ++n3;
        }
        this.recordByteBuffer.flip();
        this.readPosition += (long)(this.recordByteBuffer.limit() + this.readDelimiter.length);
        return this.recordByteBuffer;
    }

    private ByteBuffer getSequentialFixedRecord() throws IOException {
        this.rewritePosition = this.readPosition;
        return this.readIntoByteBuffer(this.readByteBuffer, this.maxRecordLength);
    }

    private ByteBuffer getSequentialShortRecord() throws IOException {
        int n2;
        this.rewritePosition = this.readPosition;
        this.readPosition += 2L;
        try {
            n2 = this.randomAccessFile.readShort() & 0xFFFF;
        }
        catch (EOFException eOFException) {
            return null;
        }
        this.readByteBuffer.limit(n2);
        return this.readIntoByteBuffer(this.readByteBuffer, n2);
    }

    private ByteBuffer getSequentialIntRecord() throws IOException {
        int n2;
        this.rewritePosition = this.readPosition;
        this.readPosition += 4L;
        try {
            n2 = this.randomAccessFile.readInt();
        }
        catch (EOFException eOFException) {
            return null;
        }
        this.readByteBuffer.limit(n2);
        return this.readIntoByteBuffer(this.readByteBuffer, n2);
    }

    private ByteBuffer readIntoByteBuffer(ByteBuffer byteBuffer, int n2) throws IOException {
        int n3;
        this.readRecordLength = 0;
        this.eofBeforeEor = false;
        for (int i2 = n2; i2 > 0; i2 -= n3) {
            n3 = this.fileChannel.read(byteBuffer);
            if (n3 >= 0) continue;
            this.eofBeforeEor = true;
            return null;
        }
        this.readRecordLength = n2;
        this.readPosition += (long)n2;
        byteBuffer.flip();
        return byteBuffer;
    }

    private int getLineLength(byte[] byArray, int n2) {
        if (!this.stripTrailingSpaces) {
            return n2;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (byArray[i2] == 32) continue;
            return i2 + 1;
        }
        return 0;
    }
}

