/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.filehandler;

import com.veryant.cobol.annotations.Entrypoint;
import com.veryant.cobol.annotations.MemoryModel;
import com.veryant.cobol.converters.CMP5S;
import com.veryant.cobol.converters.CMPXU;
import com.veryant.cobol.data.CobolDataReference;
import com.veryant.cobol.data.IMemory;
import com.veryant.cobol.data.Model;
import com.veryant.cobol.filehandler.CobolFileBase;
import com.veryant.cobol.filehandler.CobolFileRelative;
import com.veryant.cobol.filehandler.CobolFileSequential;
import com.veryant.cobol.filehandler.CobolFileVisitor;
import com.veryant.cobol.filehandler.ICobolFileBase;
import com.veryant.cobol.rununit.Console;
import com.veryant.cobol.rununit.Environment;
import com.veryant.cobol.rununit.ICallable;
import com.veryant.cobol.rununit.RunUnitThread;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.logging.Logger;

@MemoryModel(value=Model.Target)
public class EXTFH
implements ICallable {
    private static final char[] opcodes = new char[256];
    private final RunUnitThread $RUT$ = Environment.init();
    private boolean $INITIALIZED$ = false;
    private Method extfhMethod;
    private final Logger LOGGER = Logger.getLogger("com.veryant.cobol.rununit");
    private static final ICobolFileBase[] standardMethods;
    private static final boolean[] isOpenOpcode;
    private static final boolean[] isCloseOpcode;
    private static final boolean[] needsInputRecordOpcode;
    private static final boolean[] needsOutputRecordOpcode;
    private static final byte[] emptyByteArray;
    private long nextHandle = 1L;
    private Hashtable<Long, CobolFileBase> handles = new Hashtable();

    @Override
    public RunUnitThread getRunUnitThread() {
        return this.$RUT$;
    }

    private void init() {
        if (!this.$INITIALIZED$) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass("com.iscobol.extfh3.InExtfh");
                this.extfhMethod = clazz.getMethod("extfh", Character.TYPE, byte[].class, byte[].class, Integer.TYPE, Integer.TYPE, String.class, byte[].class);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                Console.writeLine(reflectiveOperationException.getClass() + ": " + reflectiveOperationException.getMessage());
            }
            this.$INITIALIZED$ = true;
        }
    }

    @Override
    public void cancel() {
        if (this.$INITIALIZED$) {
            // empty if block
        }
        this.$INITIALIZED$ = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Entrypoint(value="EXTFH")
    public int extfh(CobolDataReference cobolDataReference, CobolDataReference cobolDataReference2) {
        try {
            Environment.enter(this.$RUT$, this);
            this.init();
            switch (cobolDataReference.getMemory().get(cobolDataReference.getOffset()) & 0xFF) {
                case 250: {
                    this.standardOperation(cobolDataReference.getMemory().get(cobolDataReference.getOffset() + 1) & 0xFF, cobolDataReference2);
                    return 0;
                }
                case 0: {
                    this.specialOperation(cobolDataReference.getMemory().get(cobolDataReference.getOffset() + 1) & 0xFF, cobolDataReference2);
                    return 0;
                }
            }
            return 0;
        }
        finally {
            Environment.exit(this.$RUT$, this);
        }
    }

    public void standardOperation(int n2, CobolDataReference cobolDataReference) {
        CobolFileBase cobolFileBase;
        IMemory iMemory = cobolDataReference.getMemory();
        int n3 = cobolDataReference.getOffset();
        int n4 = cobolDataReference.getLength();
        byte by = iMemory.get(n3 + 5);
        if (by == 2) {
            byte[] byArray;
            int n5;
            long l2;
            byte[] byArray2;
            byte[] byArray3 = iMemory.toArray(n3, n4);
            if (!isOpenOpcode[n2]) {
                byArray2 = emptyByteArray;
            } else {
                l2 = CMP5S.loadLong(iMemory, n3 + 184, 8);
                byArray2 = this.$RUT$.getRunUnit().readDirectBytes(l2, 2);
                int n6 = (byArray2[0] << 8) + byArray2[1];
                byArray2 = this.$RUT$.getRunUnit().readDirectBytes(l2, n6);
            }
            l2 = 0L;
            if (needsInputRecordOpcode[n2]) {
                l2 = CMP5S.loadLong(iMemory, n3 + 160, 8);
                n5 = CMPXU.loadInt(iMemory, n3 + 96, 4);
                byArray = this.$RUT$.getRunUnit().readDirectBytes(l2, n5);
            } else if (needsOutputRecordOpcode[n2]) {
                l2 = CMP5S.loadLong(iMemory, n3 + 160, 8);
                n5 = CMPXU.loadInt(iMemory, n3 + 96, 4);
                byArray = new byte[n5];
            } else {
                byArray = emptyByteArray;
            }
            n5 = 0;
            int n7 = 0;
            String string = CobolFileBase.getFileName(this.$RUT$.getRunUnit(), n2, iMemory, n3);
            try {
                this.extfhMethod.invoke(null, Character.valueOf(opcodes[n2]), byArray3, byArray, n5, n7, string, byArray2);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            iMemory.copy(byArray3, 0, n3, n4);
            this.storeExtendedFileStatus(byArray3, 2);
            if (needsOutputRecordOpcode[n2] && CobolFileBase.isStatusSuccess(byArray3)) {
                int n8 = CMPXU.loadInt(iMemory, n3 + 88, 4);
                this.$RUT$.getRunUnit().writeDirectBytes(byArray, l2, n8);
            }
            return;
        }
        long l3 = CMP5S.loadLong(iMemory, n3 + 152, 8);
        if (isOpenOpcode[n2]) {
            if (this.handles.containsKey(l3)) {
                this.storeFileStatus(CobolFileBase.errFileAlreadyOpen, iMemory, n3);
                return;
            }
            switch (iMemory.get(n3 + 5)) {
                case 0: {
                    cobolFileBase = new CobolFileSequential(this.$RUT$.getRunUnit(), cobolDataReference, true);
                    break;
                }
                case 1: {
                    cobolFileBase = new CobolFileSequential(this.$RUT$.getRunUnit(), cobolDataReference, false);
                    break;
                }
                case 3: {
                    cobolFileBase = new CobolFileRelative(this.$RUT$.getRunUnit(), cobolDataReference);
                    break;
                }
                default: {
                    this.storeFileStatus(CobolFileBase.errUnsupported, iMemory, n3);
                    return;
                }
            }
            l3 = this.assignHandle(cobolFileBase, iMemory, n3);
        } else {
            if (n2 == 248) {
                byte[] byArray = CobolFileBase.deleteFile(CobolFileBase.getFileName(this.$RUT$.getRunUnit(), n2, iMemory, n3));
                this.storeFileStatus(byArray, iMemory, n3);
                return;
            }
            if (n2 == 220 || n2 == 221) {
                return;
            }
            if (this.handles.containsKey(l3)) {
                cobolFileBase = this.handles.get(l3);
            } else {
                this.storeFileStatus(CobolFileBase.errFileNotOpen, iMemory, n3);
                return;
            }
        }
        byte[] byArray = standardMethods[n2].call(cobolFileBase, n2);
        if (byArray.length > 0) {
            if (isOpenOpcode[n2] && !CobolFileBase.isStatusSuccess(byArray) || isCloseOpcode[n2] && CobolFileBase.isStatusSuccess(byArray)) {
                this.removeHandle(l3, iMemory, n3);
            }
            this.storeFileStatus(byArray, iMemory, n3);
        }
    }

    private long assignHandle(CobolFileBase cobolFileBase, IMemory iMemory, int n2) {
        ++this.nextHandle;
        this.handles.put(this.nextHandle, cobolFileBase);
        CMP5S.store(this.nextHandle, iMemory, n2 + 152, 8);
        return this.nextHandle;
    }

    private void removeHandle(long l2, IMemory iMemory, int n2) {
        this.handles.remove(l2);
        CMP5S.store(0, iMemory, n2 + 152, 8);
    }

    private void storeExtendedFileStatus(byte[] byArray, int n2) {
        if (byArray.length > n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            this.$RUT$.getRunUnit().setLastFileError(byArray2);
        } else {
            this.$RUT$.getRunUnit().setLastFileError(byArray);
        }
    }

    private void storeFileStatus(byte[] byArray, IMemory iMemory, int n2, int n3) {
        if (n3 >= 2) {
            iMemory.copy(byArray, 0, n2 + 0, 2);
            this.storeExtendedFileStatus(byArray, n3);
        }
    }

    private void storeFileStatus(byte[] byArray, IMemory iMemory, int n2) {
        this.storeFileStatus(byArray, iMemory, n2, byArray.length);
    }

    public void specialOperation(int n2, CobolDataReference cobolDataReference) {
        Console.writeLine("Special operation " + n2);
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            EXTFH.opcodes[i2] = (char)(64000 + i2);
        }
        standardMethods = new ICobolFileBase[256];
        isOpenOpcode = new boolean[256];
        isCloseOpcode = new boolean[256];
        needsInputRecordOpcode = new boolean[256];
        needsOutputRecordOpcode = new boolean[256];
        emptyByteArray = new byte[0];
        EXTFH.standardMethods[128] = CobolFileVisitor::close;
        EXTFH.standardMethods[129] = CobolFileVisitor::close;
        EXTFH.standardMethods[130] = CobolFileVisitor::close;
        EXTFH.standardMethods[132] = CobolFileVisitor::close;
        EXTFH.standardMethods[133] = CobolFileVisitor::close;
        EXTFH.standardMethods[134] = CobolFileVisitor::close;
        EXTFH.standardMethods[220] = CobolFileVisitor::commit;
        EXTFH.standardMethods[247] = CobolFileVisitor::delete;
        EXTFH.standardMethods[0] = CobolFileVisitor::open;
        EXTFH.standardMethods[1] = CobolFileVisitor::open;
        EXTFH.standardMethods[2] = CobolFileVisitor::open;
        EXTFH.standardMethods[3] = CobolFileVisitor::open;
        EXTFH.standardMethods[4] = CobolFileVisitor::open;
        EXTFH.standardMethods[5] = CobolFileVisitor::open;
        EXTFH.standardMethods[8] = CobolFileVisitor::open;
        EXTFH.standardMethods[141] = CobolFileVisitor::nextWithNoLock;
        EXTFH.standardMethods[216] = CobolFileVisitor::nextWithLock;
        EXTFH.standardMethods[217] = CobolFileVisitor::nextWithKeptLock;
        EXTFH.standardMethods[245] = CobolFileVisitor::next;
        EXTFH.standardMethods[140] = CobolFileVisitor::previousWithNoLock;
        EXTFH.standardMethods[222] = CobolFileVisitor::previousWithLock;
        EXTFH.standardMethods[223] = CobolFileVisitor::previousWithKeptLock;
        EXTFH.standardMethods[249] = CobolFileVisitor::previous;
        EXTFH.standardMethods[142] = CobolFileVisitor::readWithNoLock;
        EXTFH.standardMethods[218] = CobolFileVisitor::readWithLock;
        EXTFH.standardMethods[219] = CobolFileVisitor::readWithKeptLock;
        EXTFH.standardMethods[246] = CobolFileVisitor::read;
        EXTFH.standardMethods[143] = CobolFileVisitor::readWithNoLock;
        EXTFH.standardMethods[214] = CobolFileVisitor::readWithLock;
        EXTFH.standardMethods[215] = CobolFileVisitor::readWithKeptLock;
        EXTFH.standardMethods[201] = CobolFileVisitor::read;
        EXTFH.standardMethods[221] = CobolFileVisitor::rollback;
        EXTFH.standardMethods[232] = CobolFileVisitor::start;
        EXTFH.standardMethods[233] = CobolFileVisitor::start;
        EXTFH.standardMethods[234] = CobolFileVisitor::start;
        EXTFH.standardMethods[235] = CobolFileVisitor::start;
        EXTFH.standardMethods[254] = CobolFileVisitor::start;
        EXTFH.standardMethods[255] = CobolFileVisitor::start;
        EXTFH.standardMethods[144] = CobolFileVisitor::step;
        EXTFH.standardMethods[145] = CobolFileVisitor::step;
        EXTFH.standardMethods[146] = CobolFileVisitor::step;
        EXTFH.standardMethods[147] = CobolFileVisitor::step;
        EXTFH.standardMethods[202] = CobolFileVisitor::step;
        EXTFH.standardMethods[203] = CobolFileVisitor::step;
        EXTFH.standardMethods[204] = CobolFileVisitor::step;
        EXTFH.standardMethods[205] = CobolFileVisitor::step;
        EXTFH.standardMethods[206] = CobolFileVisitor::step;
        EXTFH.standardMethods[207] = CobolFileVisitor::step;
        EXTFH.standardMethods[208] = CobolFileVisitor::step;
        EXTFH.standardMethods[209] = CobolFileVisitor::step;
        EXTFH.standardMethods[210] = CobolFileVisitor::step;
        EXTFH.standardMethods[211] = CobolFileVisitor::step;
        EXTFH.standardMethods[212] = CobolFileVisitor::step;
        EXTFH.standardMethods[213] = CobolFileVisitor::step;
        EXTFH.standardMethods[14] = CobolFileVisitor::unlock;
        EXTFH.standardMethods[225] = CobolFileVisitor::write;
        EXTFH.standardMethods[226] = CobolFileVisitor::write;
        EXTFH.standardMethods[227] = CobolFileVisitor::write;
        EXTFH.standardMethods[228] = CobolFileVisitor::write;
        EXTFH.standardMethods[229] = CobolFileVisitor::write;
        EXTFH.standardMethods[230] = CobolFileVisitor::write;
        EXTFH.standardMethods[236] = CobolFileVisitor::write;
        EXTFH.standardMethods[237] = CobolFileVisitor::write;
        EXTFH.standardMethods[243] = CobolFileVisitor::write;
        EXTFH.standardMethods[244] = CobolFileVisitor::rewrite;
        EXTFH.isOpenOpcode[0] = true;
        EXTFH.isOpenOpcode[1] = true;
        EXTFH.isOpenOpcode[2] = true;
        EXTFH.isOpenOpcode[3] = true;
        EXTFH.isOpenOpcode[4] = true;
        EXTFH.isOpenOpcode[5] = true;
        EXTFH.isOpenOpcode[8] = true;
        EXTFH.isCloseOpcode[128] = true;
        EXTFH.isCloseOpcode[129] = true;
        EXTFH.isCloseOpcode[130] = true;
        EXTFH.isCloseOpcode[132] = true;
        EXTFH.isCloseOpcode[133] = true;
        EXTFH.isCloseOpcode[134] = true;
        EXTFH.needsInputRecordOpcode[247] = true;
        EXTFH.needsInputRecordOpcode[142] = true;
        EXTFH.needsInputRecordOpcode[218] = true;
        EXTFH.needsInputRecordOpcode[219] = true;
        EXTFH.needsInputRecordOpcode[246] = true;
        EXTFH.needsInputRecordOpcode[143] = true;
        EXTFH.needsInputRecordOpcode[214] = true;
        EXTFH.needsInputRecordOpcode[215] = true;
        EXTFH.needsInputRecordOpcode[201] = true;
        EXTFH.needsInputRecordOpcode[232] = true;
        EXTFH.needsInputRecordOpcode[233] = true;
        EXTFH.needsInputRecordOpcode[234] = true;
        EXTFH.needsInputRecordOpcode[235] = true;
        EXTFH.needsInputRecordOpcode[254] = true;
        EXTFH.needsInputRecordOpcode[255] = true;
        EXTFH.needsInputRecordOpcode[225] = true;
        EXTFH.needsInputRecordOpcode[226] = true;
        EXTFH.needsInputRecordOpcode[227] = true;
        EXTFH.needsInputRecordOpcode[228] = true;
        EXTFH.needsInputRecordOpcode[229] = true;
        EXTFH.needsInputRecordOpcode[230] = true;
        EXTFH.needsInputRecordOpcode[236] = true;
        EXTFH.needsInputRecordOpcode[237] = true;
        EXTFH.needsInputRecordOpcode[243] = true;
        EXTFH.needsInputRecordOpcode[244] = true;
        EXTFH.needsOutputRecordOpcode[141] = true;
        EXTFH.needsOutputRecordOpcode[216] = true;
        EXTFH.needsOutputRecordOpcode[217] = true;
        EXTFH.needsOutputRecordOpcode[245] = true;
        EXTFH.needsOutputRecordOpcode[140] = true;
        EXTFH.needsOutputRecordOpcode[222] = true;
        EXTFH.needsOutputRecordOpcode[223] = true;
        EXTFH.needsOutputRecordOpcode[249] = true;
        EXTFH.needsOutputRecordOpcode[142] = true;
        EXTFH.needsOutputRecordOpcode[218] = true;
        EXTFH.needsOutputRecordOpcode[219] = true;
        EXTFH.needsOutputRecordOpcode[246] = true;
        EXTFH.needsOutputRecordOpcode[143] = true;
        EXTFH.needsOutputRecordOpcode[214] = true;
        EXTFH.needsOutputRecordOpcode[215] = true;
        EXTFH.needsOutputRecordOpcode[201] = true;
    }
}

