/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.preproc;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.SOURCEENCODING;
import com.veryant.cobol.preproc.AbstractPreprocessor;
import com.veryant.cobol.preproc.CachedCobolLine;
import com.veryant.cobol.preproc.CobolLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class BasePreprocessor
extends AbstractPreprocessor {
    private final BufferedReader reader;
    private int lineNumber;
    private CobolLine pendingMessage;

    public BasePreprocessor(String string, Directives directives) throws IOException {
        super(string, directives);
        this.reader = Files.newBufferedReader(Paths.get(string, new String[0]).toAbsolutePath(), ((SOURCEENCODING)directives.getDirective(286)).getCodepage().getCharset());
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reader.close();
    }

    private String safeSubstring(String string, int n2) {
        if (n2 < string.length()) {
            return string.substring(n2);
        }
        return "";
    }

    private CobolLine getCobolLine(String string) {
        String string2;
        int n2;
        if (string.isEmpty()) {
            return CobolLine.EMPTY_LINE;
        }
        if (string.charAt(0) == '*') {
            return new CobolLine(0, this.safeSubstring(string, 1));
        }
        String string3 = this.getTabReplacer();
        if (string3 != null) {
            string = string.replace("\t", string3);
        }
        if ((n2 = this.getCommentDelimiter()) > 0 && (string = this.safeSubstring(string, n2 - 1)).isEmpty()) {
            return CobolLine.EMPTY_LINE;
        }
        int n3 = this.getCodeDelimiter();
        if (n3 > 0 && string.length() > n3) {
            string = n2 > 0 ? string.substring(0, n3 + 1) : string.substring(0, n3);
        }
        int n4 = 4;
        if (n2 > 0) {
            char c2 = string.charAt(0);
            switch (c2) {
                case '$': {
                    n4 = 3;
                    break;
                }
                case 'D': 
                case 'd': {
                    n4 = 2;
                    break;
                }
                case '*': 
                case '/': {
                    n4 = 0;
                    break;
                }
                case '-': {
                    n4 = 1;
                    break;
                }
                default: {
                    if (c2 == ' ') break;
                    this.pendingMessage = new CobolLine(8, "Unknown indicator character, ignored");
                }
            }
            string = this.safeSubstring(string, 1);
            if (n4 != 4) {
                if ((n4 == 1 || n4 == 2) && string.trim().isEmpty()) {
                    return CobolLine.EMPTY_LINE;
                }
                return new CobolLine(n4, string);
            }
        }
        if ((string2 = string.trim()).isEmpty()) {
            return CobolLine.EMPTY_LINE;
        }
        if (string2.charAt(0) == '$') {
            return new CobolLine(3, this.safeSubstring(string2, 1));
        }
        return new CobolLine(4, string);
    }

    @Override
    public CachedCobolLine getLine() throws IOException {
        CachedCobolLine cachedCobolLine;
        if (this.pendingMessage != null) {
            cachedCobolLine = new CachedCobolLine(this.getFilePath(), this.lineNumber, this.pendingMessage, this.getCommentDelimiter(), this.getCodeDelimiter());
            this.pendingMessage = null;
        } else {
            String string = this.reader.readLine();
            if (string == null) {
                return null;
            }
            CobolLine cobolLine = this.getCobolLine(string);
            ++this.lineNumber;
            cachedCobolLine = new CachedCobolLine(this.getFilePath(), this.lineNumber, cobolLine, this.getCommentDelimiter(), this.getCodeDelimiter());
        }
        return cachedCobolLine;
    }
}

