/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.preproc;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import com.veryant.cobol.preproc.BasePreprocessor;
import com.veryant.cobol.preproc.CachedCobolLine;
import com.veryant.cobol.preproc.CobolLine;
import java.io.IOException;
import java.util.LinkedList;

public class InternalPreprocessor
extends BasePreprocessor {
    private static final int EOF = -2;
    private static final int EOL = -1;
    private static final int RAW_CHAR = 0;
    private static final int COBOL_WORD = 1;
    private static final int QUOTED_STRING = 2;
    private static final CobolLine UNCLOSED_STRING = new CobolLine(8, "Continuation character expected, end of literal assumed");
    private final LinkedList<CachedCobolLine> output = new LinkedList();
    private final StringBuilder buffer = new StringBuilder(65);
    private CachedCobolLine peek;
    private CobolLine cobolLine;
    private String cobolLineText;
    private int cobolLineLength;
    private int state;
    private char c;
    private int offset;
    private final StringBuilder island = new StringBuilder(12);
    private boolean delayedNewLine;
    private char quoteChar;
    private BaseDirective.Phase phase = BaseDirective.Phase.Init;

    public InternalPreprocessor(String string, Directives directives) throws IOException {
        super(string, directives);
        this.peek();
    }

    @Override
    public CachedCobolLine getLine() throws IOException {
        if (this.output.isEmpty() && this.peek != null) {
            this.scan();
        }
        if (!this.output.isEmpty()) {
            return this.output.poll();
        }
        return null;
    }

    protected static boolean isValidTokenChar(int n2) {
        if (n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122 || n2 >= 48 && n2 <= 57) {
            return true;
        }
        switch (n2) {
            case 35: 
            case 45: 
            case 95: {
                return true;
            }
        }
        if (n2 >= 0 && n2 <= 127 || n2 >= 55296 && n2 <= 56319) {
            return false;
        }
        return n2 >= -671032320 && n2 <= -603987969;
    }

    protected static int skipWhiteSpaces(String string) {
        int n2;
        for (n2 = 0; n2 < string.length() && string.charAt(n2) <= ' '; ++n2) {
        }
        return n2;
    }

    private void peek() throws IOException {
        if (this.peek != null) {
            this.output.add(this.peek);
        }
        this.cobolLine = null;
        this.cobolLineText = null;
        this.cobolLineLength = 0;
        while ((this.peek = super.getLine()) != null) {
            CobolLine cobolLine = this.peek.getCobolLine();
            if (cobolLine.getType() == 4 || cobolLine.getType() == 1) {
                this.phase = BaseDirective.Phase.AfterInit;
                this.cobolLine = cobolLine;
                this.cobolLineText = this.cobolLine.getText();
                this.cobolLineLength = this.cobolLineText.length();
                break;
            }
            if (cobolLine.getType() == 3) {
                String string = cobolLine.getText().trim();
                String string2 = string.toUpperCase();
                if (string2.startsWith("SET ")) {
                    try {
                        this.getDirectives().set(this.phase, string.substring(3).trim());
                    }
                    catch (InvalidDirectiveException invalidDirectiveException) {
                        this.output.add(this.peek);
                        this.peek = new CachedCobolLine(this.peek.getSourceFile(), this.peek.getSourceLine(), new CobolLine(8, invalidDirectiveException.getMessage()), this.peek.getSourceColumn());
                    }
                } else {
                    this.output.add(this.peek);
                    this.peek = new CachedCobolLine(this.peek.getSourceFile(), this.peek.getSourceLine(), new CobolLine(8, cobolLine.getText()), this.peek.getSourceColumn());
                }
            }
            this.output.add(this.peek);
        }
        this.offset = -1;
    }

    private void dump(CachedCobolLine cachedCobolLine) {
        if (!cachedCobolLine.getCobolLine().getText().trim().isEmpty()) {
            this.output.add(cachedCobolLine);
        }
    }

    private void scan() throws IOException {
        int n2 = -2;
        CachedCobolLine cachedCobolLine = this.peek;
        this.buffer.setLength(0);
        while (true) {
            int n3;
            if ((n3 = this.nextChar()) != n2) {
                if (this.island.length() > 0) {
                    CobolLine cobolLine = this.pDispatch(n2, this.island);
                    if (cobolLine == null) {
                        this.buffer.append((CharSequence)this.island);
                        this.island.setLength(0);
                    } else {
                        this.dump(new CachedCobolLine(cachedCobolLine.getSourceFile(), cachedCobolLine.getSourceLine(), new CobolLine(7, this.buffer.toString()), cachedCobolLine.getSourceColumn(), cachedCobolLine.getRightDelimiter()));
                        this.buffer.setLength(0);
                        for (int i2 = this.offset; i2 > 0; --i2) {
                            this.buffer.append(' ');
                        }
                        this.dump(new CachedCobolLine(cachedCobolLine.getSourceFile(), cachedCobolLine.getSourceLine(), cobolLine));
                        this.island.setLength(0);
                        continue;
                    }
                }
                n2 = n3;
            }
            if (n3 < 0) break;
            this.island.append(this.c);
        }
        if (this.buffer.length() > 0) {
            this.dump(new CachedCobolLine(cachedCobolLine.getSourceFile(), cachedCobolLine.getSourceLine(), new CobolLine(7, this.buffer.toString()), cachedCobolLine.getSourceColumn(), cachedCobolLine.getRightDelimiter()));
        }
    }

    private CobolLine pDispatch(int n2, StringBuilder stringBuilder) throws IOException {
        CobolLine cobolLine = null;
        if (n2 == 1) {
            switch (stringBuilder.charAt(0)) {
                case 'C': 
                case 'c': {
                    String string = stringBuilder.toString();
                    if (!string.equalsIgnoreCase("COPY")) break;
                    cobolLine = this.pCopyStatement();
                }
            }
        }
        return cobolLine;
    }

    private int nextChar() throws IOException {
        this.c = '\u0000';
        if (this.delayedNewLine) {
            this.delayedNewLine = false;
            return -1;
        }
        if (this.peek == null) {
            return -2;
        }
        block13: while (true) {
            int n2;
            if ((n2 = this.offset + 1) >= this.cobolLineLength) {
                if (this.state == 2 && n2 < this.peek.getRightDelimiter()) {
                    this.offset = n2;
                    this.c = (char)32;
                    return 2;
                }
                CachedCobolLine cachedCobolLine = this.peek;
                this.peek();
                if (this.peek == null || this.cobolLine.getType() == 4) {
                    if (this.state == 2) {
                        this.output.add(new CachedCobolLine(cachedCobolLine.getSourceFile(), cachedCobolLine.getSourceLine(), UNCLOSED_STRING, this.offset, 0));
                        this.state = 0;
                        this.c = this.quoteChar;
                        this.delayedNewLine = true;
                        return 2;
                    }
                    this.state = 0;
                    return -1;
                }
                if (this.cobolLine.getType() == 1) {
                    this.offset = InternalPreprocessor.skipWhiteSpaces(this.cobolLineText);
                    switch (this.state) {
                        case 0: {
                            --this.offset;
                            this.c = (char)32;
                            return 0;
                        }
                        case 2: {
                            if (this.cobolLineText.charAt(this.offset) == this.quoteChar) {
                                ++this.offset;
                                if (this.offset < this.peek.getRightDelimiter()) break;
                                continue block13;
                            }
                            this.offset = 0;
                            break;
                        }
                    }
                }
            } else {
                ++this.offset;
            }
            this.c = this.cobolLineText.charAt(this.offset);
            switch (this.state) {
                case 2: {
                    if (this.c == this.quoteChar) {
                        this.state = 0;
                    }
                    return 2;
                }
                case 1: {
                    if (InternalPreprocessor.isValidTokenChar(this.c)) {
                        if (((BaseDirective)this.getDirectives().getDirective(6)).isSet() && this.c == '_') {
                            this.c = (char)45;
                        }
                        return 1;
                    }
                    this.state = 0;
                }
                case 0: {
                    switch (this.c) {
                        case '*': {
                            n2 = this.offset + 1;
                            int n3 = this.cobolLineText.length();
                            if (n2 >= n3 || this.cobolLineText.charAt(n2) != '>') break block13;
                            this.offset = n3;
                            continue block13;
                        }
                        case '\"': 
                        case '\'': {
                            this.state = 2;
                            this.quoteChar = this.c;
                            break block13;
                        }
                    }
                    if (this.c == '-' || !InternalPreprocessor.isValidTokenChar(this.c)) break block13;
                    this.state = 1;
                }
            }
            break;
        }
        return this.state;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CobolLine pCopyStatement() throws IOException {
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        block6: while (true) {
            if (this.nextChar() == -2) {
                string = "Bad COPY format, EOF";
                break;
            }
            switch (n2) {
                case 0: {
                    if (this.c <= ' ') break;
                    if (this.c == '\'' || this.c == '\"') {
                        n2 = 2;
                        break;
                    }
                    n2 = 1;
                }
                case 1: {
                    if (this.c <= ' ') {
                        int n3 = stringBuilder.length() - 1;
                        if (stringBuilder.charAt(n3) == '.') {
                            stringBuilder.setLength(n3);
                            break block6;
                        }
                        n2 = 3;
                        break;
                    }
                    if (this.c == '\'' || this.c == '\"') {
                        string = "Bad COPY format, missing dot";
                        break block6;
                    }
                    stringBuilder.append(this.c);
                    break;
                }
                case 2: {
                    if (this.c == this.quoteChar) {
                        n2 = 3;
                        break;
                    }
                    stringBuilder.append(this.c);
                    break;
                }
                case 3: {
                    if (this.c <= ' ') break;
                    if (this.c == '.') break block6;
                    string = "Bad COPY format, missing dot";
                    break block6;
                }
            }
        }
        if (string != null) {
            return new CobolLine(9, string);
        }
        return new CobolLine(6, stringBuilder.toString());
    }
}

