/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.preproc;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.compiler.directives.IDirectiveListener;
import com.veryant.cobol.compiler.directives.LISTWIDTH;
import com.veryant.cobol.preproc.CobolLine;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class ListWriter
extends BufferedWriter
implements IDirectiveListener {
    private int listWidth;
    private int lineCounter = 0;
    private final StringBuilder lineBuilder = new StringBuilder();
    private Directives directives;
    private boolean[] _subscribedDirectivesFlags = null;

    public ListWriter(String string, Directives directives) throws IOException {
        super(new FileWriter(string));
        this.registerListener(directives);
    }

    @Override
    public void write(String string) throws IOException {
        if (string.length() > this.listWidth) {
            string = string.substring(0, this.listWidth);
        }
        super.write(string);
    }

    public void write(CobolLine cobolLine) throws IOException {
        this.lineBuilder.setLength(0);
        int n2 = cobolLine.getType();
        switch (n2) {
            case 6: {
                this.lineBuilder.append("      * [COPY] ");
                this.lineBuilder.append(cobolLine.getText());
                this.write(this.lineBuilder.toString());
                this.newLine();
                return;
            }
            case 8: {
                this.lineBuilder.append("      * [WARNING] ");
                this.lineBuilder.append(cobolLine.getText());
                this.write(this.lineBuilder.toString());
                this.newLine();
                return;
            }
            case 9: {
                this.lineBuilder.append("      * [ERROR] ");
                this.lineBuilder.append(cobolLine.getText());
                this.write(this.lineBuilder.toString());
                this.newLine();
                return;
            }
        }
        if (this.lineCounter >= 999999) {
            this.lineCounter = 0;
        }
        ++this.lineCounter;
        this.lineBuilder.append(String.format("%6d", this.lineCounter));
        switch (n2) {
            case 0: {
                this.lineBuilder.append('*');
                break;
            }
            case 1: {
                this.lineBuilder.append('-');
                break;
            }
            case 2: {
                this.lineBuilder.append('D');
                break;
            }
            case 3: {
                this.lineBuilder.append('$');
                break;
            }
            default: {
                this.lineBuilder.append(' ');
            }
        }
        this.lineBuilder.append(cobolLine.getText());
        this.write(this.lineBuilder.toString());
        this.newLine();
    }

    @Override
    public Directives getDirectives() {
        return this.directives;
    }

    @Override
    public void setDirectives(Directives directives) {
        this.directives = directives;
    }

    @Override
    public boolean[] getSubscribedDirectivesFlags() {
        if (this._subscribedDirectivesFlags == null) {
            this._subscribedDirectivesFlags = new boolean[323];
            this._subscribedDirectivesFlags[179] = true;
        }
        return this._subscribedDirectivesFlags;
    }

    @Override
    public void onDirectiveChanged(BaseDirective baseDirective) {
        switch (baseDirective.getIndex()) {
            case 179: {
                this.listWidth = ((LISTWIDTH)baseDirective).getWidth();
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        IDirectiveListener.super.close();
    }
}

